/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.argumentselectiondefects.NamedParameterComment;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.Comments;
import com.google.errorprone.util.ErrorProneToken;
import com.google.errorprone.util.ErrorProneTokens;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Name;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;

@BugPattern(name="ParameterName", summary="Detects `/* name= */`-style comments on actual parameters where the name doesn't match the formal parameter", severity=BugPattern.SeverityLevel.WARNING, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class ParameterName
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.NewClassTreeMatcher {
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        this.checkArguments(tree, tree.getArguments(), state);
        return Description.NO_MATCH;
    }

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        this.checkArguments(tree, tree.getArguments(), state);
        return Description.NO_MATCH;
    }

    private void checkArguments(Tree tree, List<? extends ExpressionTree> arguments, VisitorState state) {
        if (arguments.isEmpty()) {
            return;
        }
        Symbol.MethodSymbol sym = (Symbol.MethodSymbol)ASTHelpers.getSymbol((Tree)tree);
        if (NamedParameterComment.containsSyntheticParameterName(sym)) {
            return;
        }
        int start = ((JCTree)tree).getStartPosition();
        int end = state.getEndPosition((Tree)Iterables.getLast(arguments));
        String source = state.getSourceCode().subSequence(start, end).toString();
        if (!source.contains("/*")) {
            return;
        }
        ArrayDeque tokens = new ArrayDeque(ErrorProneTokens.getTokens((String)source, (Context)state.context));
        Streams.forEachPair(sym.getParameters().stream(), arguments.stream(), (p, a) -> {
            while (!tokens.isEmpty() && start + ((ErrorProneToken)tokens.peekFirst()).pos() < ((JCTree)((Object)a)).getStartPosition()) {
                tokens.removeFirst();
            }
            if (tokens.isEmpty()) {
                return;
            }
            Range argRange = Range.closedOpen((Comparable)Integer.valueOf(((JCTree)((Object)a)).getStartPosition()), (Comparable)Integer.valueOf(state.getEndPosition((Tree)a)));
            if (!argRange.contains((Comparable)Integer.valueOf(start + ((ErrorProneToken)tokens.peekFirst()).pos()))) {
                return;
            }
            this.checkArgument((Symbol.VarSymbol)p, (ExpressionTree)a, start, (ErrorProneToken)tokens.removeFirst(), state);
        });
    }

    private void checkArgument(Symbol.VarSymbol formal, ExpressionTree actual, int start, ErrorProneToken token, VisitorState state) {
        ArrayList<Tokens.Comment> matches = new ArrayList<Tokens.Comment>();
        for (Tokens.Comment comment : token.comments()) {
            Matcher m;
            if (comment.getStyle() != Tokens.Comment.CommentStyle.BLOCK || !(m = NamedParameterComment.PARAMETER_COMMENT_PATTERN.matcher(Comments.getTextFromComment((Tokens.Comment)comment))).matches()) continue;
            String name = m.group(1);
            if (((Name)formal.getSimpleName()).contentEquals(name)) {
                return;
            }
            matches.add(comment);
        }
        for (Tokens.Comment match : matches) {
            state.reportMatch(this.buildDescription(actual).setMessage(String.format("%s does not match parameter name '%s'", match.getText(), formal.getSimpleName())).addFix((Fix)SuggestedFix.replace((int)(start + match.getSourcePos(0)), (int)(start + match.getSourcePos(match.getText().length() - 1) + 1), (String)String.format("/* %s= */", formal.getSimpleName()))).build());
        }
    }
}

