/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import java.io.IOException;
import org.basex.build.csv.CsvOptions;
import org.basex.build.csv.CsvParserOptions;
import org.basex.build.csv.CsvW3ArraysOptions;
import org.basex.build.csv.CsvW3Options;
import org.basex.io.in.TextInput;
import org.basex.io.parse.csv.CsvConverter;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.fn.ParseFn;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.options.Options;

public abstract class ParseCsv
extends ParseFn {
    protected abstract CsvOptions.CsvFormat format();

    @Override
    protected final Options options(QueryContext qc) throws QueryException {
        CsvOptions.CsvFormat format = this.format();
        CsvW3Options copts = format == CsvOptions.CsvFormat.W3 || format == CsvOptions.CsvFormat.W3_XML ? new CsvW3Options() : (format == CsvOptions.CsvFormat.W3_ARRAYS ? new CsvW3ArraysOptions() : new CsvParserOptions());
        return this.toOptions(this.arg(1), copts, qc);
    }

    @Override
    final boolean nl() {
        return true;
    }

    @Override
    final QueryError error() {
        return QueryError.CSV_ERROR_X;
    }

    @Override
    final Value parse(TextInput ti, Options options, QueryContext qc) throws QueryException, IOException {
        CsvParserOptions cpopts;
        CsvOptions.CsvFormat format = this.format();
        CsvW3Options copts = format == CsvOptions.CsvFormat.W3 || format == CsvOptions.CsvFormat.W3_XML ? new CsvW3Options() : (format == CsvOptions.CsvFormat.W3_ARRAYS ? new CsvW3ArraysOptions() : new CsvParserOptions());
        this.toOptions(this.arg(1), copts, qc);
        if (format == CsvOptions.CsvFormat.W3 || format == CsvOptions.CsvFormat.W3_XML || format == CsvOptions.CsvFormat.W3_ARRAYS) {
            cpopts = ((CsvW3ArraysOptions)copts).finish(this.info, format);
        } else {
            Boolean b;
            cpopts = (CsvParserOptions)((Object)copts);
            Value hdr = copts.get(CsvOptions.HEADER);
            if (hdr.size() == 1L && hdr.seqType().type.isStringOrUntyped() && (b = Strings.toBoolean(Token.string(((Item)hdr).string(null)))) != null) {
                copts.put(CsvOptions.HEADER, Bln.get(b));
            }
        }
        if (format != null) {
            cpopts.set(CsvOptions.FORMAT, format);
        }
        CsvConverter converter = CsvConverter.get(cpopts);
        return converter.convert(ti, "", this.info, qc);
    }
}

