// Copyright 2011 Google Inc. All Rights Reserved.

package com.google.appengine.api.xmpp;

/**
 * Values for the 'type' attribute of presences. These are only types from stanzas dealing with
 * presence. Types used for subscriptions are enumerated in {@link SubscriptionType} even though
 * they are both communicated via presence stanzas.
 *
 * @see <a href="http://tools.ietf.org/html/rfc3921#section-2.2.1">RFC 3921, Section 2.2.1</a> for
 *     the specification of XMPP message Presence Types.
 * @deprecated This API has been <a
 *     href="https://cloud.google.com/appengine/docs/deprecations/xmpp">deprecated</a>.
 */
@Deprecated
public enum PresenceType {
  /**
   * Signals that an entity is online and available for communication.
   */
  AVAILABLE,

  /**
   * Signals that an entity is no longer available for communication.
   */
  UNAVAILABLE,

  /**
   * A request for an entity's current presence.
   */
  PROBE
}
