// Copyright 2012 Google Inc. All rights reserved.
package com.google.appengine.api.taskqueue;

import com.google.appengine.spi.FactoryProvider;
import com.google.appengine.spi.ServiceProvider;
import com.google.auto.service.AutoService;

/**
 * Factory provider for {@link IQueueFactory}.
 *
 * <p><b>Note:</b> This class is not intended for end users.
 *
 */
@AutoService(FactoryProvider.class)
@ServiceProvider(precedence = Integer.MIN_VALUE)
public final class IQueueFactoryProvider extends FactoryProvider<IQueueFactory> {

  private final QueueFactoryImpl implementation = new QueueFactoryImpl();

  public IQueueFactoryProvider() {
    super(IQueueFactory.class);
  }

  @Override
  protected IQueueFactory getFactoryInstance() {
    return implementation;
  }

}
