#!/bin/bash
# Copyright 2009 Google Inc. All Rights Reserved.
#
# Launches the Development AppServer.  This utility allows developers
# to test a Google App Engine application on their local workstation.
(>&2 echo \
'The dev_appserver shipped with the standalone Java SDK is deprecated. Please
use the java_dev_appserver.sh shipped with the Cloud SDK instead.
https://cloud.google.com/appengine/docs/standard/java/download')

[[ -z "${DEBUG}" ]] || set -x  # trace if $DEBUG env. var. is non-zero

# Construct the absolute name of the SDK bin directory.
# Use -P so pwd will see the real name, independent of symbolic links.
readonly SDK_BIN="$(cd -P "$(dirname "$0")" && pwd)"
readonly SDK_ROOT="$(dirname "${SDK_BIN}")"
readonly SDK_LIB="${SDK_ROOT}/lib"
readonly JAR_FILE="${SDK_LIB}/appengine-tools-api.jar"

if [[ ! -e "${JAR_FILE}" ]]; then
    echo "${JAR_FILE} not found" >&2
    exit 1
fi

readonly SCRIPT_NAME=$(basename "$0")
readonly RUN_JAVA=$(dirname "$0")/run_java.sh
exec "${RUN_JAVA}" "${SCRIPT_NAME}" \
    -ea -cp "${JAR_FILE}" \
    com.google.appengine.tools.KickStart \
    com.google.appengine.tools.development.DevAppServerMain \
    --sdk_root="${SDK_ROOT}" \
    "$@"
