/**********************************************************************
Copyright (c) 2005 Erik Bengtson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
    ...
**********************************************************************/
package org.datanucleus.store.mapped.expression;

/**
 * Interface that allows one datastore adapt expression and operators
 * @version $Revision: 1.2 $
 */
public interface ExpressionOperatorAdapter
{
    /**
     * Method to generate a modulus expression. The binary % operator is said to
     * yield the remainder of its operands from an implied division; the
     * left-hand operand is the dividend and the right-hand operand is the
     * divisor.
     * @param operand1 the left expression
     * @param operand2 the right expression
     * @return The Expression for modulus
     */
    NumericExpression modOperator(ScalarExpression operand1, ScalarExpression operand2);

    /**
     * <p>
     * If only one operand expression is of type String, then string conversion
     * is performed on the other operand to produce a string at run time. The
     * result is a reference to a String object (newly created, unless the
     * expression is a compile-time constant expression (15.28))that is the
     * concatenation of the two operand strings. The characters of the left-hand
     * operand precede the characters of the right-hand operand in the newly
     * created string. If an operand of type String is null, then the string
     * "null" is used instead of that operand. "null" is used instead of that
     * operand.
     * </p>
     * <p>
     * Concatenates two or more character or binary strings, columns, or a
     * combination of strings and column names into one expression (a string
     * operator).
     * </p>
     * @param operand1 the left expression
     * @param operand2 the right expression
     * @return The Expression for concatenation
     */
    ScalarExpression concatOperator(ScalarExpression operand1, ScalarExpression operand2);
    
    /**
     * An operator in a string expression that concatenates two or more
     * character or binary strings, columns, or a combination of strings and
     * column names into one expression (a string operator).
     * 
     * @return the operator String
     */
    String getOperatorConcat();
}
