/**********************************************************************
Copyright (c) 2007 Thomas Marti and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
    ...
**********************************************************************/
package org.datanucleus.store.mapped.mapping;

import java.awt.geom.CubicCurve2D;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.ObjectManager;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.mapped.DatastoreAdapter;
import org.datanucleus.store.mapped.DatastoreContainerObject;

/**
 * Mapping for java.awt.geom.CubicCurve2D.Double, maps the x1, y1, ctrlx1, ctrly1, 
 * ctrlx2, ctrly2, x2 and y2 values to double-precision datastore fields.
 */
public class CubicCurve2dDoubleMapping extends SingleFieldMultiMapping
{

    private static final CubicCurve2D.Double sampleValue = new CubicCurve2D.Double();

	/* (non-Javadoc)
     * @see org.datanucleus.store.mapping.JavaTypeMapping#initialize()
     */
    public void initialize(DatastoreAdapter dba, AbstractMemberMetaData fmd, DatastoreContainerObject container, ClassLoaderResolver clr)
    {
		super.initialize(dba, fmd, container, clr);

        addDatastoreField(ClassNameConstants.DOUBLE); // X1
        addDatastoreField(ClassNameConstants.DOUBLE); // Y1
        addDatastoreField(ClassNameConstants.DOUBLE); // CtrlX1
        addDatastoreField(ClassNameConstants.DOUBLE); // CtrlY1
        addDatastoreField(ClassNameConstants.DOUBLE); // CtrlX2
        addDatastoreField(ClassNameConstants.DOUBLE); // CtrlY2
        addDatastoreField(ClassNameConstants.DOUBLE); // X2
        addDatastoreField(ClassNameConstants.DOUBLE); // Y2
    }

    /* (non-Javadoc)
     * @see org.datanucleus.store.mapping.JavaTypeMapping#getJavaType()
     */
    public Class getJavaType()
    {
        return CubicCurve2D.Double.class;
    }

    /* (non-Javadoc)
     * @see org.datanucleus.store.mapping.JavaTypeMapping#getSampleValue()
     */
    public Object getSampleValue(ClassLoaderResolver clr)
    {
        return sampleValue;
    }
    
    /* (non-Javadoc)
     * @see org.datanucleus.store.mapping.JavaTypeMapping#setObject(org.datanucleus.ObjectManager, java.lang.Object, int[], java.lang.Object)
     */
    public void setObject(ObjectManager om, Object preparedStatement, int[] exprIndex, Object value)
    {    	
    	CubicCurve2D.Double cubicCurve = (CubicCurve2D.Double)value;
        if (cubicCurve == null)
        {
    		for (int i = 0; i < exprIndex.length; i++) 
    		{
    			getDataStoreMapping(i).setObject(preparedStatement, exprIndex[i], null);					
			}
        }
        else
        {
            getDataStoreMapping(0).setDouble(preparedStatement,exprIndex[0],cubicCurve.getX1());
            getDataStoreMapping(1).setDouble(preparedStatement,exprIndex[1],cubicCurve.getY1());
            getDataStoreMapping(2).setDouble(preparedStatement,exprIndex[2],cubicCurve.getCtrlX1());
            getDataStoreMapping(3).setDouble(preparedStatement,exprIndex[3],cubicCurve.getCtrlY1());
            getDataStoreMapping(4).setDouble(preparedStatement,exprIndex[4],cubicCurve.getCtrlX2());
            getDataStoreMapping(5).setDouble(preparedStatement,exprIndex[5],cubicCurve.getCtrlY2());
            getDataStoreMapping(6).setDouble(preparedStatement,exprIndex[6],cubicCurve.getX2());
            getDataStoreMapping(7).setDouble(preparedStatement,exprIndex[7],cubicCurve.getY2());
        }
    }
    
    /* (non-Javadoc)
     * @see org.datanucleus.store.mapping.JavaTypeMapping#getObject(org.datanucleus.ObjectManager, java.lang.Object, int[])
     */
    public Object getObject(ObjectManager om, Object resultSet, int[] exprIndex)
    {
        // Check for null entries
        if (getDataStoreMapping(0).getObject(resultSet, exprIndex[0]) == null)
        {
            return null;
        }
        
        double x1 = getDataStoreMapping(0).getDouble(resultSet,exprIndex[0]); 
        double y1 = getDataStoreMapping(1).getDouble(resultSet,exprIndex[1]); 
        double ctrlx1 = getDataStoreMapping(2).getDouble(resultSet,exprIndex[2]); 
        double ctrly1 = getDataStoreMapping(3).getDouble(resultSet,exprIndex[3]); 
        double ctrlx2 = getDataStoreMapping(4).getDouble(resultSet,exprIndex[4]);
        double ctrly2 = getDataStoreMapping(5).getDouble(resultSet,exprIndex[5]); 
        double x2 = getDataStoreMapping(6).getDouble(resultSet,exprIndex[6]);
        double y2 = getDataStoreMapping(7).getDouble(resultSet,exprIndex[7]);
        return new CubicCurve2D.Double(x1, y1, ctrlx1, ctrly1, ctrlx2, ctrly2, x2, y2);
    }
}