/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.InheritanceStrategy;
import org.datanucleus.store.mapped.ColumnCreator;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MultiPersistableMapping;
import org.datanucleus.util.NucleusLogger;

public class SubclassPCMapping
extends MultiPersistableMapping {
    public void initialize(AbstractMemberMetaData fmd, DatastoreContainerObject container, ClassLoaderResolver clr) {
        super.initialize(fmd, container, clr);
        this.prepareDatastoreMapping(clr);
    }

    protected void prepareDatastoreMapping(ClassLoaderResolver clr) {
        if (this.roleForMember != 4 && this.roleForMember != 3 && this.roleForMember != 5 && this.roleForMember != 6) {
            AbstractClassMetaData refCmd = this.storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForClass(this.mmd.getType(), clr);
            if (refCmd.getInheritanceMetaData().getStrategy() != InheritanceStrategy.SUBCLASS_TABLE) {
                throw new NucleusUserException(LOCALISER.msg("020185", (Object)this.mmd.getFullFieldName()));
            }
            AbstractClassMetaData[] subclassCmds = this.storeMgr.getClassesManagingTableForClass(refCmd, clr);
            boolean pk = false;
            if (subclassCmds.length > 1) {
                pk = false;
            }
            boolean nullable = true;
            if (subclassCmds.length > 1) {
                nullable = true;
            }
            int colPos = 0;
            for (int i = 0; i < subclassCmds.length; ++i) {
                Class type = clr.classForName(subclassCmds[i].getFullClassName());
                DatastoreClass dc = this.storeMgr.getDatastoreClass(subclassCmds[i].getFullClassName(), clr);
                JavaTypeMapping m = dc.getIdMapping();
                ColumnMetaData[] columnMetaDataForType = null;
                if (this.mmd.getColumnMetaData() != null && this.mmd.getColumnMetaData().length > 0) {
                    if (this.mmd.getColumnMetaData().length < colPos + m.getNumberOfDatastoreMappings()) {
                        throw new NucleusUserException(LOCALISER.msg("020186", (Object)this.mmd.getFullFieldName(), (Object)("" + this.mmd.getColumnMetaData().length), (Object)("" + (colPos + m.getNumberOfDatastoreMappings()))));
                    }
                    columnMetaDataForType = new ColumnMetaData[m.getNumberOfDatastoreMappings()];
                    System.arraycopy(this.mmd.getColumnMetaData(), colPos, columnMetaDataForType, 0, columnMetaDataForType.length);
                    colPos += columnMetaDataForType.length;
                }
                ColumnCreator.createColumnsForField(type, this, this.datastoreContainer, this.storeMgr, this.mmd, pk, nullable, false, false, 2, columnMetaDataForType, clr, true);
                if (!NucleusLogger.DATASTORE.isInfoEnabled()) continue;
                NucleusLogger.DATASTORE.info(LOCALISER.msg("020187", type, (Object)this.mmd.getName()));
            }
        }
    }

    public Class getJavaType() {
        return null;
    }
}

