/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.tools.devserver;

import java.util.HashMap;
import java.util.Map;

public class ErrorMap {
    private static Map<Integer, ErrorMapError> errors = ErrorMap.createErrorMap();

    public int getHttpStatus(int lilyStatus) {
        if (lilyStatus >= 500) {
            return 503;
        }
        ErrorMapError error = errors.get(lilyStatus);
        if (error == null) {
            return 404;
        }
        return error.httpStatus;
    }

    public int getRpcStatus(int lilyStatus) {
        if (lilyStatus >= 500) {
            return -32099;
        }
        ErrorMapError error = errors.get(lilyStatus);
        if (error == null) {
            return 404;
        }
        return error.rpcStatus;
    }

    public String getReason(int lilyStatus) {
        if (lilyStatus >= 500) {
            return "backendError";
        }
        ErrorMapError error = errors.get(lilyStatus);
        if (error == null) {
            return "unsupportedProtocol";
        }
        return error.reason;
    }

    public String getDomain(int lilyStatus) {
        if (lilyStatus >= 500) {
            return "global";
        }
        ErrorMapError error = errors.get(lilyStatus);
        if (error == null) {
            return "global";
        }
        return error.domain;
    }

    private static Map<Integer, ErrorMapError> createErrorMap() {
        HashMap<Integer, ErrorMapError> errors = new HashMap<Integer, ErrorMapError>();
        errors.put(400, new ErrorMapError(400, 400, "badRequest", "global"));
        errors.put(401, new ErrorMapError(401, 401, "required", "global"));
        errors.put(402, new ErrorMapError(404, 404, "unsupportedProtocol", "global"));
        errors.put(403, new ErrorMapError(403, 403, "forbidden", "global"));
        errors.put(404, new ErrorMapError(404, 404, "notFound", "global"));
        errors.put(405, new ErrorMapError(501, 501, "unsupportedMethod", "global"));
        errors.put(406, new ErrorMapError(404, 404, "unsupportedProtocol", "global"));
        errors.put(407, new ErrorMapError(404, 404, "unsupportedProtocol", "global"));
        errors.put(408, new ErrorMapError(503, -32099, "backendError", "global"));
        errors.put(409, new ErrorMapError(409, 409, "conflict", "global"));
        errors.put(410, new ErrorMapError(410, 410, "deleted", "global"));
        errors.put(411, new ErrorMapError(404, 404, "unsupportedProtocol", "global"));
        errors.put(412, new ErrorMapError(412, 412, "conditionNotMet", "global"));
        errors.put(413, new ErrorMapError(413, 413, "uploadTooLarge", "global"));
        errors.put(414, new ErrorMapError(404, 404, "unsupportedProtocol", "global"));
        errors.put(415, new ErrorMapError(404, 404, "unsupportedProtocol", "global"));
        errors.put(416, new ErrorMapError(404, 404, "unsupportedProtocol", "global"));
        errors.put(417, new ErrorMapError(404, 404, "unsupportedProtocol", "global"));
        return errors;
    }

    private static class ErrorMapError {
        private final int httpStatus;
        private final int rpcStatus;
        private final String reason;
        private final String domain;

        ErrorMapError(int httpStatus, int rpcStatus, String reason, String domain) {
            this.httpStatus = httpStatus;
            this.rpcStatus = rpcStatus;
            this.reason = reason;
            this.domain = domain;
        }
    }
}

