/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config.annotationreader;

import com.google.api.server.spi.config.AnnotationBoolean;
import com.google.api.server.spi.config.ApiConfig;
import com.google.api.server.spi.config.ApiResourceProperty;
import com.google.api.server.spi.config.ApiSerializationConfig;
import com.google.api.server.spi.config.ApiTransformer;
import com.google.api.server.spi.config.ResourcePropertySchema;
import com.google.api.server.spi.config.ResourceTransformer;
import com.google.api.server.spi.config.Serializers;
import com.google.api.server.spi.config.Transformer;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.reflect.TypeToken;
import com.google.appengine.repackaged.org.codehaus.jackson.JsonGenerator;
import com.google.appengine.repackaged.org.codehaus.jackson.JsonParser;
import com.google.appengine.repackaged.org.codehaus.jackson.JsonProcessingException;
import com.google.appengine.repackaged.org.codehaus.jackson.JsonToken;
import com.google.appengine.repackaged.org.codehaus.jackson.map.DeserializationContext;
import com.google.appengine.repackaged.org.codehaus.jackson.map.JsonDeserializer;
import com.google.appengine.repackaged.org.codehaus.jackson.map.JsonSerializer;
import com.google.appengine.repackaged.org.codehaus.jackson.map.SerializerProvider;
import com.google.appengine.repackaged.org.codehaus.jackson.map.introspect.Annotated;
import com.google.appengine.repackaged.org.codehaus.jackson.map.introspect.AnnotatedClass;
import com.google.appengine.repackaged.org.codehaus.jackson.map.introspect.AnnotatedField;
import com.google.appengine.repackaged.org.codehaus.jackson.map.introspect.AnnotatedMember;
import com.google.appengine.repackaged.org.codehaus.jackson.map.introspect.AnnotatedMethod;
import com.google.appengine.repackaged.org.codehaus.jackson.map.introspect.NopAnnotationIntrospector;
import com.google.appengine.repackaged.org.codehaus.jackson.type.TypeReference;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ApiAnnotationIntrospector
extends NopAnnotationIntrospector {
    private final ApiSerializationConfig config;

    public ApiAnnotationIntrospector() {
        this(new ApiSerializationConfig());
    }

    public ApiAnnotationIntrospector(ApiSerializationConfig config) {
        this.config = config;
    }

    @Override
    public boolean isHandled(Annotation ann) {
        return ann instanceof ApiResourceProperty || ann instanceof ApiTransformer;
    }

    @Override
    public boolean hasIgnoreMarker(AnnotatedMember member) {
        ApiResourceProperty apiProperty = member.getAnnotation(ApiResourceProperty.class);
        if (apiProperty != null) {
            return apiProperty.ignored() == AnnotationBoolean.TRUE;
        }
        return false;
    }

    @Override
    public boolean isIgnorableMethod(AnnotatedMethod method) {
        ApiResourceProperty apiProperty = method.getAnnotation(ApiResourceProperty.class);
        if (apiProperty != null) {
            return apiProperty.ignored() == AnnotationBoolean.TRUE;
        }
        return false;
    }

    @Override
    public String findGettablePropertyName(AnnotatedMethod method) {
        ApiResourceProperty apiName = method.getAnnotation(ApiResourceProperty.class);
        if (apiName != null && apiName.ignored() != AnnotationBoolean.TRUE) {
            return apiName.name();
        }
        return null;
    }

    @Override
    public String findSettablePropertyName(AnnotatedMethod method) {
        ApiResourceProperty apiName = method.getAnnotation(ApiResourceProperty.class);
        if (apiName != null && apiName.ignored() != AnnotationBoolean.TRUE) {
            return apiName.name();
        }
        return null;
    }

    @Override
    public JsonSerializer<?> findSerializer(Annotated method) {
        return ApiAnnotationIntrospector.getJsonSerializer(this.findSerializerInstance(method));
    }

    @Override
    public String findEnumValue(Enum<?> value) {
        return value.name();
    }

    private static <TFrom, TTo> @Nullable JsonSerializer<TFrom> getJsonSerializer(final @Nullable Transformer<TFrom, TTo> serializer) {
        if (serializer == null) {
            return null;
        }
        return new JsonSerializer<TFrom>(){

            @Override
            public void serialize(TFrom value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
                jgen.writeObject(serializer.transformTo(value));
            }
        };
    }

    @Override
    public JsonDeserializer<?> findDeserializer(Annotated a) {
        return ApiAnnotationIntrospector.getJsonDeserializer(this.findSerializerInstance(a));
    }

    @Override
    public String findSerializablePropertyName(AnnotatedField af) {
        ApiResourceProperty apiName = af.getAnnotation(ApiResourceProperty.class);
        if (apiName != null) {
            if (apiName.ignored() != AnnotationBoolean.TRUE) {
                return apiName.name();
            }
        } else if (af.isPublic()) {
            return "";
        }
        return null;
    }

    @Override
    public String findDeserializablePropertyName(AnnotatedField af) {
        ApiResourceProperty apiName = af.getAnnotation(ApiResourceProperty.class);
        if (apiName != null) {
            if (apiName.ignored() != AnnotationBoolean.TRUE) {
                return apiName.name();
            }
        } else if (af.isPublic()) {
            return "";
        }
        return null;
    }

    private static <TFrom, TTo> JsonDeserializer<TFrom> getJsonDeserializer(final @Nullable Transformer<TFrom, TTo> serializer) {
        if (serializer == null) {
            return null;
        }
        final TypeReference<TTo> serializedType = ApiAnnotationIntrospector.typeReferenceOf(serializer);
        if (serializer instanceof ResourceTransformer) {
            ResourceTransformer resourceSerializer = (ResourceTransformer)serializer;
            return new ResourceDeserializer(resourceSerializer);
        }
        return new JsonDeserializer<TFrom>(){

            @Override
            public TFrom deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                Object deserialized = jp.readValueAs(serializedType);
                return serializer.transformFrom(deserialized);
            }
        };
    }

    public static Type getSchemaType(Type type, ApiConfig config) {
        List<Class<Transformer<?, ?>>> serializers;
        if ((type instanceof Class || type instanceof ParameterizedType) && !(serializers = Serializers.getSerializerClasses(type, config.getSerializationConfig())).isEmpty() && !ResourceTransformer.class.isAssignableFrom(serializers.get(0))) {
            Type sourceType = Serializers.getSourceType(serializers.get(0));
            Type serializedType = Serializers.getTargetType(serializers.get(0));
            Preconditions.checkArgument(TypeToken.of(sourceType).isSupertypeOf(type), "Serializer specified for %s, but only serializes for %s: %s", (Object)type, (Object)sourceType, serializers.get(0));
            Preconditions.checkArgument(serializedType != null, "Couldn't find Serializer interface in serializer for %s: %s", (Object)type, serializers.get(0));
            return serializedType;
        }
        return type;
    }

    private @Nullable Transformer<?, ?> findSerializerInstance(Annotated a) {
        AnnotatedClass clazz;
        List<Class<Transformer<?, ?>>> serializerClasses;
        if (a instanceof AnnotatedClass && !(serializerClasses = Serializers.getSerializerClasses((clazz = (AnnotatedClass)a).getRawType(), this.config)).isEmpty()) {
            return Serializers.instantiate(serializerClasses.get(0), a.getGenericType());
        }
        return null;
    }

    private static <T> TypeReference<T> typeReferenceOf(Transformer<?, T> serializer) {
        Class<?> serializerClass = serializer.getClass();
        final Type type = Serializers.getTargetType(serializerClass);
        return new TypeReference<T>(){

            @Override
            public Type getType() {
                return type;
            }
        };
    }

    private static class ResourceDeserializer<TFrom>
    extends JsonDeserializer<TFrom> {
        private final ResourceTransformer<TFrom> resourceSerializer;

        private ResourceDeserializer(ResourceTransformer<TFrom> resourceSerializer) {
            this.resourceSerializer = resourceSerializer;
        }

        @Override
        public TFrom deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            Map<String, ResourcePropertySchema> properties = this.resourceSerializer.getResourceSchema().getProperties();
            ImmutableMap.Builder values = ImmutableMap.builder();
            while (jp.nextValue() != JsonToken.END_OBJECT) {
                String property = jp.getCurrentName();
                final ResourcePropertySchema schemaType = properties.get(property);
                if (schemaType != null) {
                    TypeReference<Object> jacksonTypeRef = new TypeReference<Object>(this){

                        @Override
                        public Type getType() {
                            return schemaType.getJavaType();
                        }
                    };
                    values.put(property, jp.readValueAs(jacksonTypeRef));
                }
                jp.skipChildren();
            }
            return this.resourceSerializer.transformFrom(values.build());
        }
    }
}

