/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.auth;

import com.google.api.server.spi.Client;
import com.google.api.server.spi.Strings;
import com.google.appengine.repackaged.com.google.api.client.http.GenericUrl;
import com.google.appengine.repackaged.com.google.api.client.http.HttpRequest;
import com.google.appengine.repackaged.com.google.api.client.util.Key;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public class GoogleAuth {
    private static final Logger logger = Logger.getLogger(GoogleAuth.class.getName());
    private static final String BASE64_REGEX = "[a-zA-Z0-9+/=_-]{6,}+";
    private static final Pattern JWT_PATTERN = Pattern.compile(String.format("%s\\.%s\\.%s", "[a-zA-Z0-9+/=_-]{6,}+", "[a-zA-Z0-9+/=_-]{6,}+", "[a-zA-Z0-9+/=_-]{6,}+"));
    private static final String TOKEN_INFO_ENDPOINT = "https://www.googleapis.com/oauth2/v2/tokeninfo?access_token=";
    @VisibleForTesting
    static final String AUTHORIZATION_HEADER = "Authorization";
    @VisibleForTesting
    static final String[] ALLOWED_AUTH_SCHEMES = new String[]{"Bearer", "OAuth"};
    @VisibleForTesting
    static final String[] BEARER_TOKEN_PARAMETER_NAMES = new String[]{"access_token", "bearer_token"};
    @VisibleForTesting
    static final String[] OAUTH2_TOKEN_PREFIXES = new String[]{"ya29.", "1/"};
    @VisibleForTesting
    static final ImmutableList<String> SKIP_CLIENT_ID_CHECK_LIST = ImmutableList.of("*");

    public static String getAuthToken(HttpServletRequest request) {
        if (request.getAttribute("endpoints:Auth-Token") == null) {
            String token = GoogleAuth.getAuthTokenFromHeader(request.getHeader(AUTHORIZATION_HEADER));
            if (token == null) {
                token = GoogleAuth.getAuthTokenFromQueryParameters(request);
            }
            request.setAttribute("endpoints:Auth-Token", (Object)token);
        }
        return (String)request.getAttribute("endpoints:Auth-Token");
    }

    private static String getAuthTokenFromQueryParameters(HttpServletRequest request) {
        for (String parameterName : BEARER_TOKEN_PARAMETER_NAMES) {
            String token = request.getParameter(parameterName);
            if (token == null) continue;
            return token;
        }
        return null;
    }

    private static String getAuthTokenFromHeader(String authHeader) {
        String authScheme = GoogleAuth.matchAuthScheme(authHeader);
        if (authScheme == null) {
            return null;
        }
        return authHeader.substring(authScheme.length() + 1);
    }

    private static String matchAuthScheme(String authHeader) {
        if (authHeader == null) {
            return null;
        }
        for (String authScheme : ALLOWED_AUTH_SCHEMES) {
            if (!authHeader.startsWith(authScheme)) continue;
            return authScheme;
        }
        return null;
    }

    static boolean isJwt(String token) {
        if (token == null) {
            return false;
        }
        return JWT_PATTERN.matcher(token).matches();
    }

    static boolean isOAuth2Token(String token) {
        if (token == null) {
            return false;
        }
        String strippedToken = token.trim().replaceFirst("^['\"]", "");
        for (String prefix : OAUTH2_TOKEN_PREFIXES) {
            if (!strippedToken.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    static boolean checkClientId(String clientId, List<String> allowedClientIds, boolean allowSkipClientIdCheck) {
        if (Strings.isWhitelisted(clientId, allowedClientIds)) {
            return true;
        }
        return allowSkipClientIdCheck && !Strings.isEmptyOrNull(allowedClientIds) && allowedClientIds.equals(SKIP_CLIENT_ID_CHECK_LIST);
    }

    static boolean checkAudience(String audience, List<String> allowedAudiences, String clientId) {
        if (Strings.isWhitelisted(audience, allowedAudiences)) {
            return true;
        }
        return !Strings.isEmptyOrWhitespace(audience) && audience.equals(clientId);
    }

    static TokenInfo getTokenInfoRemote(String token) {
        try {
            String string = String.valueOf(TOKEN_INFO_ENDPOINT);
            String string2 = String.valueOf(token);
            HttpRequest request = Client.getInstance().getJsonHttpRequestFactory().buildGetRequest(new GenericUrl(string2.length() != 0 ? string.concat(string2) : new String(string)));
            return GoogleAuth.parseTokenInfo(request);
        }
        catch (IOException e) {
            logger.logp(Level.WARNING, "com.google.api.server.spi.auth.GoogleAuth", "getTokenInfoRemote", "Failed to retrieve tokeninfo", e);
            return null;
        }
    }

    @VisibleForTesting
    static TokenInfo parseTokenInfo(HttpRequest request) throws IOException {
        TokenInfo info = request.execute().parseAs(TokenInfo.class);
        if (info == null || Strings.isEmptyOrWhitespace(info.email)) {
            logger.logp(Level.WARNING, "com.google.api.server.spi.auth.GoogleAuth", "parseTokenInfo", "Access token does not contain email scope");
            return null;
        }
        return info;
    }

    public static class TokenInfo {
        @Key(value="email")
        public String email;
        @Key(value="issued_to")
        public String clientId;
        @Key(value="scope")
        public String scopes;
        @Key(value="user_id")
        public String userId;
    }
}

