/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.plugin;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import javax.xml.parsers.DocumentBuilder;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.OMFContext;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.jdo.JDOPersistenceManagerFactory;
import org.datanucleus.plugin.Bundle;
import org.datanucleus.plugin.ConfigurationElement;
import org.datanucleus.plugin.Extension;
import org.datanucleus.plugin.ExtensionPoint;
import org.datanucleus.plugin.PluginParser;
import org.datanucleus.plugin.PluginRegistry;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonManagedPluginRegistry
implements PluginRegistry {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", OMFContext.class.getClassLoader());
    private static final String PLUGIN_DIR = "/";
    private static final FilenameFilter MANIFEST_FILE_FILTER = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            if (name.equalsIgnoreCase("meta-inf")) {
                return true;
            }
            if (!dir.getName().equalsIgnoreCase("meta-inf")) {
                return false;
            }
            return name.equalsIgnoreCase("manifest.mf");
        }
    };
    private static final char JAR_SEPARATOR = '!';
    private final ClassLoaderResolver clr;
    Map<String, ExtensionPoint> extensionPointsByUniqueId = new HashMap<String, ExtensionPoint>();
    Map<String, Bundle> registeredPluginByPluginId = new HashMap<String, Bundle>();
    ExtensionPoint[] extensionPoints;
    private boolean registeredExtensions;
    private String bundleCheckType = "EXCEPTION";

    public NonManagedPluginRegistry(ClassLoaderResolver clr, String bundleCheckType) {
        this.clr = clr;
        this.extensionPoints = new ExtensionPoint[0];
        if (bundleCheckType != null) {
            this.bundleCheckType = bundleCheckType;
        }
    }

    @Override
    public ExtensionPoint getExtensionPoint(String id) {
        return this.extensionPointsByUniqueId.get(id);
    }

    @Override
    public ExtensionPoint[] getExtensionPoints() {
        return this.extensionPoints;
    }

    @Override
    public void registerExtensionPoints() {
        this.registerExtensions();
    }

    public void registerPluginExtensions(URL plugin, Bundle bundle) {
        int i;
        ArrayList registeringExtensions = new ArrayList();
        List[] elements = PluginParser.parsePluginElements(PluginParser.getDocumentBuilder(), this, plugin, bundle, this.clr);
        for (i = 0; i < elements[0].size(); ++i) {
            ExtensionPoint exPoint = (ExtensionPoint)elements[0].get(i);
            this.extensionPointsByUniqueId.put(exPoint.getUniqueId(), exPoint);
        }
        registeringExtensions.addAll(elements[1]);
        this.extensionPoints = this.extensionPointsByUniqueId.values().toArray(new ExtensionPoint[this.extensionPointsByUniqueId.values().size()]);
        for (i = 0; i < registeringExtensions.size(); ++i) {
            Extension extension = (Extension)registeringExtensions.get(i);
            ExtensionPoint exPoint = this.getExtensionPoint(extension.getExtensionPointId());
            if (exPoint == null) {
                NucleusLogger.PLUGIN.warn(LOCALISER.msg("024002", (Object)extension.getExtensionPointId(), (Object)extension.getPlugin().getSymbolicName(), (Object)extension.getPlugin().getManifestLocation().toString()));
                continue;
            }
            extension.setExtensionPoint(exPoint);
            exPoint.addExtension(extension);
        }
    }

    @Override
    public void registerExtensions() {
        if (this.registeredExtensions) {
            return;
        }
        ArrayList registeringExtensions = new ArrayList();
        Set<URL> pluginURLs = this.getPluginURLs();
        Iterator<URL> it = pluginURLs.iterator();
        DocumentBuilder docBuilder = PluginParser.getDocumentBuilder();
        while (it.hasNext()) {
            Bundle bundle;
            URL pluginURL = it.next();
            URL manifest = this.getManifestURL(pluginURL);
            if (manifest == null || (bundle = this.registerBundle(manifest)) == null) continue;
            List[] elements = PluginParser.parsePluginElements(docBuilder, this, pluginURL, bundle, this.clr);
            for (int i = 0; i < elements[0].size(); ++i) {
                ExtensionPoint exPoint = (ExtensionPoint)elements[0].get(i);
                this.extensionPointsByUniqueId.put(exPoint.getUniqueId(), exPoint);
            }
            registeringExtensions.addAll(elements[1]);
        }
        this.extensionPoints = this.extensionPointsByUniqueId.values().toArray(new ExtensionPoint[this.extensionPointsByUniqueId.values().size()]);
        for (int i = 0; i < registeringExtensions.size(); ++i) {
            Extension extension = (Extension)registeringExtensions.get(i);
            ExtensionPoint exPoint = this.getExtensionPoint(extension.getExtensionPointId());
            if (exPoint == null) {
                System.out.println("LUDO...");
                NucleusLogger.PLUGIN.warn(LOCALISER.msg("024002", (Object)extension.getExtensionPointId(), (Object)extension.getPlugin().getSymbolicName(), (Object)extension.getPlugin().getManifestLocation().toString()));
                continue;
            }
            extension.setExtensionPoint(exPoint);
            exPoint.addExtension(extension);
        }
        this.registeredExtensions = true;
    }

    private Set<URL> getPluginURLs() {
        HashSet<URL> set = new HashSet<URL>();
        try {
            Enumeration<URL> paths = this.clr.getResources("/plugin.xml", JDOPersistenceManagerFactory.class.getClassLoader());
            while (paths.hasMoreElements()) {
                set.add(paths.nextElement());
            }
        }
        catch (IOException e) {
            throw new NucleusException("Error loading resource", e).setFatal();
        }
        return set;
    }

    /*
     * Loose catch block
     */
    protected Bundle registerBundle(URL manifest) {
        Bundle bundle;
        InputStream is;
        block42: {
            Manifest mf;
            block38: {
                Bundle bundle2;
                block41: {
                    URL jarUrl;
                    block39: {
                        Bundle bundle3;
                        block40: {
                            int index;
                            block34: {
                                Bundle bundle4;
                                block37: {
                                    URL rarUrl;
                                    block35: {
                                        Bundle bundle5;
                                        block36: {
                                            block26: {
                                                Bundle bundle6;
                                                block33: {
                                                    File jarFile;
                                                    block31: {
                                                        Bundle bundle7;
                                                        block32: {
                                                            int index2;
                                                            String path;
                                                            String jarPath;
                                                            block27: {
                                                                Bundle bundle8;
                                                                block30: {
                                                                    URL url;
                                                                    block28: {
                                                                        Bundle bundle9;
                                                                        block29: {
                                                                            if (manifest == null) {
                                                                                throw new IllegalArgumentException(LOCALISER.msg("024007"));
                                                                            }
                                                                            is = null;
                                                                            mf = null;
                                                                            if (!manifest.getProtocol().equals("jar") && !manifest.getProtocol().equals("zip") && !manifest.getProtocol().equals("wsjar")) break block26;
                                                                            if (!manifest.getPath().startsWith("http://")) break block27;
                                                                            JarURLConnection jarConnection = (JarURLConnection)manifest.openConnection();
                                                                            url = jarConnection.getJarFileURL();
                                                                            mf = jarConnection.getManifest();
                                                                            if (mf != null) break block28;
                                                                            bundle9 = null;
                                                                            Object var13_19 = null;
                                                                            if (is == null) break block29;
                                                                            try {
                                                                                is.close();
                                                                            }
                                                                            catch (IOException iOException) {
                                                                                // empty catch block
                                                                            }
                                                                        }
                                                                        return bundle9;
                                                                    }
                                                                    bundle8 = this.registerBundle(mf, url);
                                                                    Object var13_20 = null;
                                                                    if (is == null) break block30;
                                                                    try {
                                                                        is.close();
                                                                    }
                                                                    catch (IOException iOException) {
                                                                        // empty catch block
                                                                    }
                                                                }
                                                                return bundle8;
                                                            }
                                                            int begin = 4;
                                                            if (manifest.getProtocol().equals("wsjar")) {
                                                                begin = 6;
                                                            }
                                                            if ((jarPath = (path = StringUtils.getDecodedStringFromURLString(manifest.toExternalForm())).substring(begin, index2 = path.indexOf(33))).startsWith("file:")) {
                                                                jarPath = jarPath.substring(5);
                                                            }
                                                            if ((mf = new JarFile(jarFile = new File(jarPath)).getManifest()) != null) break block31;
                                                            bundle7 = null;
                                                            Object var13_21 = null;
                                                            if (is == null) break block32;
                                                            try {
                                                                is.close();
                                                            }
                                                            catch (IOException iOException) {
                                                                // empty catch block
                                                            }
                                                        }
                                                        return bundle7;
                                                    }
                                                    bundle6 = this.registerBundle(mf, jarFile.toURI().toURL());
                                                    Object var13_22 = null;
                                                    if (is == null) break block33;
                                                    try {
                                                        is.close();
                                                    }
                                                    catch (IOException iOException) {
                                                        // empty catch block
                                                    }
                                                }
                                                return bundle6;
                                            }
                                            if (!manifest.getProtocol().equals("rar") && !manifest.getProtocol().equals("war")) break block34;
                                            String path = StringUtils.getDecodedStringFromURLString(manifest.toExternalForm());
                                            int index3 = path.indexOf(33);
                                            String rarPath = path.substring(4, index3);
                                            File file = new File(rarPath);
                                            rarUrl = file.toURI().toURL();
                                            JarFile rarFile = new JarFile(file);
                                            String jarPath = path.substring(index3 + 1, path.indexOf(33, index3 + 1));
                                            mf = new JarInputStream(rarFile.getInputStream(rarFile.getEntry(jarPath))).getManifest();
                                            if (mf != null) break block35;
                                            bundle5 = null;
                                            Object var13_23 = null;
                                            if (is == null) break block36;
                                            try {
                                                is.close();
                                            }
                                            catch (IOException iOException) {
                                                // empty catch block
                                            }
                                        }
                                        return bundle5;
                                    }
                                    bundle4 = this.registerBundle(mf, rarUrl);
                                    Object var13_24 = null;
                                    if (is == null) break block37;
                                    try {
                                        is.close();
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                }
                                return bundle4;
                            }
                            if (!manifest.getProtocol().equals("vfsfile") && !manifest.getProtocol().equals("vfsjar") && !manifest.getProtocol().equals("vfszip")) break block38;
                            String path = StringUtils.getDecodedStringFromURLString(manifest.toExternalForm());
                            String jarPath = path.substring(0, index = path.indexOf(33));
                            jarUrl = new URL(jarPath);
                            JarInputStream jis = new JarInputStream(jarUrl.openConnection().getInputStream());
                            mf = jis.getManifest();
                            if (mf != null) break block39;
                            bundle3 = null;
                            Object var13_25 = null;
                            if (is == null) break block40;
                            try {
                                is.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        return bundle3;
                    }
                    bundle2 = this.registerBundle(mf, jarUrl);
                    Object var13_26 = null;
                    if (is == null) break block41;
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return bundle2;
            }
            is = manifest.openStream();
            mf = new Manifest(is);
            bundle = this.registerBundle(mf, manifest);
            Object var13_27 = null;
            if (is == null) break block42;
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return bundle;
        catch (IOException e) {
            try {
                throw new NucleusException(LOCALISER.msg("024008", manifest), e).setFatal();
            }
            catch (Throwable throwable) {
                block43: {
                    Object var13_28 = null;
                    if (is == null) break block43;
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
        }
    }

    protected Bundle registerBundle(Manifest mf, URL manifest) {
        Bundle bundle = PluginParser.parseManifest(mf, manifest);
        if (this.registeredPluginByPluginId.get(bundle.getSymbolicName()) == null) {
            if (NucleusLogger.PLUGIN.isDebugEnabled()) {
                NucleusLogger.PLUGIN.debug("Registering bundle " + bundle.getSymbolicName() + " version " + bundle.getVersion() + " at URL " + bundle.getManifestLocation() + ".");
            }
            this.registeredPluginByPluginId.put(bundle.getSymbolicName(), bundle);
        } else {
            Bundle previousBundle = this.registeredPluginByPluginId.get(bundle.getSymbolicName());
            if (!bundle.getManifestLocation().toExternalForm().equals(previousBundle.getManifestLocation().toExternalForm())) {
                String msg = LOCALISER.msg("024009", (Object)bundle.getSymbolicName(), (Object)bundle.getManifestLocation(), (Object)previousBundle.getManifestLocation());
                if (this.bundleCheckType.equalsIgnoreCase("EXCEPTION")) {
                    throw new NucleusException(msg);
                }
                if (this.bundleCheckType.equalsIgnoreCase("LOG")) {
                    NucleusLogger.PLUGIN.warn(msg);
                }
            }
        }
        return bundle;
    }

    private URL getManifestURL(URL pluginURL) {
        if (pluginURL == null) {
            return null;
        }
        if (pluginURL.toString().startsWith("jar") || pluginURL.toString().startsWith("zip") || pluginURL.toString().startsWith("rar") || pluginURL.toString().startsWith("war") || pluginURL.toString().startsWith("wsjar")) {
            return pluginURL;
        }
        if (pluginURL.toString().startsWith("vfsfile") || pluginURL.toString().startsWith("vfsjar") || pluginURL.toString().startsWith("vfszip")) {
            String urlStr = pluginURL.toString().replaceAll("\\.jar/", ".jar!/");
            try {
                return new URL(urlStr);
            }
            catch (MalformedURLException e) {
                NucleusLogger.PLUGIN.warn(LOCALISER.msg("024010", (Object)urlStr), e);
                return null;
            }
        }
        if (pluginURL.toString().startsWith("jndi")) {
            String urlStr = pluginURL.toString().substring(5);
            urlStr = urlStr.replaceAll("\\.jar/", ".jar!/");
            urlStr = "jar:file:" + urlStr;
            try {
                return new URL(urlStr);
            }
            catch (MalformedURLException e) {
                NucleusLogger.PLUGIN.warn(LOCALISER.msg("024010", (Object)urlStr), e);
                return null;
            }
        }
        if (pluginURL.toString().startsWith("code-source")) {
            String urlStr = pluginURL.toString().substring(12);
            urlStr = "jar:file:" + urlStr;
            try {
                return new URL(urlStr);
            }
            catch (MalformedURLException e) {
                NucleusLogger.PLUGIN.warn(LOCALISER.msg("024010", (Object)urlStr), e);
                return null;
            }
        }
        try {
            File[] files;
            File file = new File(new URI(pluginURL.toString()).getPath());
            File[] dirs = new File(file.getParent()).listFiles(MANIFEST_FILE_FILTER);
            if (dirs != null && dirs.length > 0 && (files = dirs[0].listFiles(MANIFEST_FILE_FILTER)) != null && files.length > 0) {
                try {
                    return files[0].toURI().toURL();
                }
                catch (MalformedURLException e) {
                    NucleusLogger.PLUGIN.warn(LOCALISER.msg("024011", pluginURL), e);
                    return null;
                }
            }
        }
        catch (URISyntaxException use) {
            use.printStackTrace();
            NucleusLogger.PLUGIN.warn(LOCALISER.msg("024011", pluginURL), use);
            return null;
        }
        NucleusLogger.PLUGIN.warn(LOCALISER.msg("024012", pluginURL));
        return null;
    }

    @Override
    public Object createExecutableExtension(ConfigurationElement confElm, String name, Class[] argsClass, Object[] args) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class cls = this.clr.classForName(confElm.getAttribute(name), OMFContext.class.getClassLoader());
        Constructor constructor = cls.getConstructor(argsClass);
        return constructor.newInstance(args);
    }

    @Override
    public Class loadClass(String pluginId, String className) throws ClassNotFoundException {
        return this.clr.classForName(className, OMFContext.class.getClassLoader());
    }

    @Override
    public URL resolveURLAsFileURL(URL url) throws IOException {
        return url;
    }

    @Override
    public void resolveConstraints() {
        for (Bundle bundle : this.registeredPluginByPluginId.values()) {
            List set = bundle.getRequireBundle();
            for (Bundle.BundleDescription bd : set) {
                String symbolicName = bd.getBundleSymbolicName();
                Bundle requiredBundle = this.registeredPluginByPluginId.get(symbolicName);
                if (requiredBundle == null) {
                    if (bd.getParameter("resolution") != null && bd.getParameter("resolution").equalsIgnoreCase("optional")) {
                        NucleusLogger.PLUGIN.info(LOCALISER.msg("024013", (Object)bundle.getSymbolicName(), (Object)symbolicName));
                    } else {
                        NucleusLogger.PLUGIN.error(LOCALISER.msg("024014", (Object)bundle.getSymbolicName(), (Object)symbolicName));
                    }
                }
                if (bd.getParameter("bundle-version") == null || requiredBundle == null || this.isVersionInInterval(requiredBundle.getVersion(), bd.getParameter("bundle-version"))) continue;
                NucleusLogger.PLUGIN.error(LOCALISER.msg("024015", (Object)bundle.getSymbolicName(), (Object)symbolicName, (Object)bd.getParameter("bundle-version"), (Object)bundle.getVersion()));
            }
        }
    }

    private boolean isVersionInInterval(String version, String interval) {
        Bundle.BundleVersionRange versionRange = PluginParser.parseVersionRange(version);
        Bundle.BundleVersionRange intervalRange = PluginParser.parseVersionRange(interval);
        int compare_floor = versionRange.floor.compareTo(intervalRange.floor);
        boolean result = true;
        if (intervalRange.floor_inclusive) {
            result = compare_floor >= 0;
        } else {
            boolean bl = result = compare_floor > 0;
        }
        if (intervalRange.ceiling != null) {
            int compare_ceiling = versionRange.floor.compareTo(intervalRange.ceiling);
            result = intervalRange.ceiling_inclusive ? compare_ceiling <= 0 : compare_ceiling < 0;
        }
        return result;
    }

    @Override
    public Bundle[] getBundles() {
        return this.registeredPluginByPluginId.values().toArray(new Bundle[this.registeredPluginByPluginId.values().size()]);
    }
}

