/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.joda.time.chrono;

import com.google.appengine.repackaged.org.joda.time.Chronology;
import com.google.appengine.repackaged.org.joda.time.chrono.BasicChronology;

abstract class BasicFixedMonthChronology
extends BasicChronology {
    private static final long serialVersionUID = 261387371998L;
    static final int MONTH_LENGTH = 30;
    static final long MILLIS_PER_YEAR = 31557600000L;
    static final long MILLIS_PER_MONTH = 2592000000L;

    BasicFixedMonthChronology(Chronology base, Object param, int minDaysInFirstWeek) {
        super(base, param, minDaysInFirstWeek);
    }

    @Override
    long setYear(long instant, int year) {
        int thisYear = this.getYear(instant);
        int dayOfYear = this.getDayOfYear(instant, thisYear);
        int millisOfDay = this.getMillisOfDay(instant);
        if (dayOfYear > 365 && !this.isLeapYear(year)) {
            --dayOfYear;
        }
        instant = this.getYearMonthDayMillis(year, 1, dayOfYear);
        return instant += (long)millisOfDay;
    }

    @Override
    long getYearDifference(long minuendInstant, long subtrahendInstant) {
        int minuendYear = this.getYear(minuendInstant);
        int subtrahendYear = this.getYear(subtrahendInstant);
        long minuendRem = minuendInstant - this.getYearMillis(minuendYear);
        long subtrahendRem = subtrahendInstant - this.getYearMillis(subtrahendYear);
        int difference = minuendYear - subtrahendYear;
        if (minuendRem < subtrahendRem) {
            --difference;
        }
        return difference;
    }

    @Override
    long getTotalMillisByYearMonth(int year, int month) {
        return (long)(month - 1) * 2592000000L;
    }

    @Override
    int getDayOfMonth(long millis) {
        return (this.getDayOfYear(millis) - 1) % 30 + 1;
    }

    @Override
    boolean isLeapYear(int year) {
        return (year & 3) == 3;
    }

    @Override
    int getDaysInYearMonth(int year, int month) {
        return month != 13 ? 30 : (this.isLeapYear(year) ? 6 : 5);
    }

    @Override
    int getDaysInMonthMax() {
        return 30;
    }

    @Override
    int getDaysInMonthMax(int month) {
        return month != 13 ? 30 : 6;
    }

    @Override
    int getMonthOfYear(long millis) {
        return (this.getDayOfYear(millis) - 1) / 30 + 1;
    }

    @Override
    int getMonthOfYear(long millis, int year) {
        long monthZeroBased = (millis - this.getYearMillis(year)) / 2592000000L;
        return (int)monthZeroBased + 1;
    }

    @Override
    int getMaxMonth() {
        return 13;
    }

    @Override
    long getAverageMillisPerYear() {
        return 31557600000L;
    }

    @Override
    long getAverageMillisPerYearDividedByTwo() {
        return 15778800000L;
    }

    @Override
    long getAverageMillisPerMonth() {
        return 2592000000L;
    }
}

