/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import java.security.SecureRandom;
import java.util.Random;

@GoogleInternal
@GwtIncompatible
public final class Randoms {
    private static final Random RANDOM = new ReadOnlyRandom();
    private static final SecureRandom SECURE_RANDOM = Randoms.newDefaultSecureRandom();
    private static final Random THREAD_LOCAL_SECURE_RANDOM = new ThreadLocalSecureRandom();
    private static final ThreadLocal<SecureRandom> localRandom = new ThreadLocal<SecureRandom>(){

        @Override
        protected SecureRandom initialValue() {
            return Randoms.newDefaultSecureRandom();
        }
    };

    private Randoms() {
    }

    public static SecureRandom secureRandom() {
        return SECURE_RANDOM;
    }

    public static SecureRandom secureRandom(byte[] seed) {
        SecureRandom retval = new SecureRandom(seed);
        retval.nextLong();
        return retval;
    }

    public static Random threadLocalSecureRandom() {
        return THREAD_LOCAL_SECURE_RANDOM;
    }

    public static Random insecureRandom() {
        return RANDOM;
    }

    public static Random insecureRandom(long seed) {
        return new Random(seed);
    }

    private static SecureRandom newDefaultSecureRandom() {
        SecureRandom retval = new SecureRandom();
        retval.nextLong();
        return retval;
    }

    private static final class ThreadLocalSecureRandom
    extends Random {
        private boolean initializationComplete = true;

        private ThreadLocalSecureRandom() {
        }

        SecureRandom current() {
            return (SecureRandom)localRandom.get();
        }

        @Override
        protected int next(int bits) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean nextBoolean() {
            return this.current().nextBoolean();
        }

        @Override
        public void nextBytes(byte[] bytes) {
            this.current().nextBytes(bytes);
        }

        @Override
        public double nextDouble() {
            return this.current().nextDouble();
        }

        @Override
        public float nextFloat() {
            return this.current().nextFloat();
        }

        @Override
        public double nextGaussian() {
            return this.current().nextGaussian();
        }

        @Override
        public int nextInt() {
            return this.current().nextInt();
        }

        @Override
        public int nextInt(int n) {
            return this.current().nextInt(n);
        }

        @Override
        public long nextLong() {
            return this.current().nextLong();
        }

        @Override
        public void setSeed(long seed) {
            if (this.initializationComplete) {
                throw new UnsupportedOperationException("Setting the seed on a thread-local Random object is not permitted");
            }
            super.setSeed(seed);
        }
    }

    private static class ReadOnlyRandom
    extends Random {
        private static final long serialVersionUID = 898001275432099254L;
        private boolean initializationComplete = true;

        private ReadOnlyRandom() {
        }

        @Override
        public void setSeed(long seed) {
            if (this.initializationComplete) {
                throw new UnsupportedOperationException("Setting the seed on the shared Random object is not permitted");
            }
            super.setSeed(seed);
        }
    }
}

