/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.time;

import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.base.Verify;
import com.google.appengine.repackaged.com.google.common.time.Durations;
import com.google.appengine.repackaged.com.google.common.time.Sleeper;
import java.time.Duration;

@GwtIncompatible
final class Sleepers {
    private Sleepers() {
    }

    static enum NoOpSleeper implements Sleeper
    {
        INSTANCE;


        @Override
        public void sleep(Duration duration) throws InterruptedException {
            Durations.checkNotNegative(duration);
        }

        public String toString() {
            return "Sleeper.noOpSleeper()";
        }
    }

    static enum DefaultSleeper implements Sleeper
    {
        INSTANCE;


        @Override
        public void sleep(Duration duration) throws InterruptedException {
            Durations.checkNotNegative(duration);
            try {
                long millis = duration.toMillis();
                Duration nanosOnly = duration.minusMillis(millis);
                Verify.verify(nanosOnly.getSeconds() == 0L);
                int nanos = nanosOnly.getNano();
                Thread.sleep(millis, nanos);
            }
            catch (ArithmeticException tooBig) {
                Thread.sleep(Long.MAX_VALUE);
            }
        }

        public String toString() {
            return "Sleeper.defaultSleeper()";
        }
    }
}

