/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.flags.ext;

import com.google.appengine.repackaged.com.google.common.base.Strings;
import com.google.appengine.repackaged.com.google.common.flags.Flag;
import com.google.appengine.repackaged.com.google.common.flags.InvalidFlagValueException;
import com.google.appengine.repackaged.org.joda.time.DateTime;
import com.google.appengine.repackaged.org.joda.time.DateTimeZone;
import com.google.appengine.repackaged.org.joda.time.Duration;
import com.google.appengine.repackaged.org.joda.time.ReadableDuration;
import com.google.appengine.repackaged.org.joda.time.ReadableInstant;
import com.google.appengine.repackaged.org.joda.time.format.DateTimeFormatter;
import com.google.appengine.repackaged.org.joda.time.format.ISODateTimeFormat;
import javax.annotation.Nullable;

public final class JodaDateTimeFlag
extends Flag<DateTime> {
    private final DateTimeFormatter format;

    public static JodaDateTimeFlag now() {
        return new JodaDateTimeFlag(DateTime.now());
    }

    public static JodaDateTimeFlag yesterday() {
        return new JodaDateTimeFlag(DateTime.now().minus((ReadableDuration)Duration.standardDays((long)1L)));
    }

    public static JodaDateTimeFlag tomorrow() {
        return new JodaDateTimeFlag(DateTime.now().plus((ReadableDuration)Duration.standardDays((long)1L)));
    }

    public JodaDateTimeFlag(@Nullable DateTime defaultValue) {
        this(defaultValue, DateTimeZone.UTC);
    }

    public JodaDateTimeFlag(@Nullable DateTime defaultValue, DateTimeZone zone) {
        this(defaultValue, ISODateTimeFormat.dateTimeParser().withZone(zone));
    }

    public JodaDateTimeFlag(@Nullable DateTime defaultValue, DateTimeFormatter format) {
        super(defaultValue);
        this.format = format;
    }

    public static JodaDateTimeFlag nullValue() {
        return new JodaDateTimeFlag(null);
    }

    @Override
    protected DateTime parse(String value) throws InvalidFlagValueException {
        try {
            return this.format.parseDateTime(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFlagValueException(e.getMessage());
        }
    }

    @Override
    protected String parsableStringValue(DateTime value) {
        if (this.format.isPrinter()) {
            return this.format.print((ReadableInstant)value);
        }
        return super.parsableStringValue(value);
    }

    public static final class JodaDateTimeFlagFactory {
        public static Flag<DateTime> value(@Nullable DateTime defaultValue) {
            return new JodaDateTimeFlag(defaultValue);
        }

        @Nullable
        public static DateTime valueOf(@Nullable String value) {
            return Strings.isNullOrEmpty(value) ? null : DateTime.parse((String)value);
        }
    }
}

