/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.utils;

import com.google.appengine.repackaged.org.apache.commons.dbcp.BasicDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import org.quartz.utils.ConnectionProvider;
import org.quartz.utils.PropertiesParser;

public class PoolingConnectionProvider
implements ConnectionProvider {
    public static final String DB_PROPS_PREFIX = "org.quartz.db.";
    public static final String DB_JNDI_DATASOURCE_URL = "jndiURL";
    public static final String DB_DRIVER = "driver";
    public static final String DB_URL = "URL";
    public static final String DB_USER = "user";
    public static final String DB_PASSWORD = "password";
    public static final String DB_MAX_CONNECTIONS = "maxConnections";
    public static final String DB_VALIDATION_QUERY = "validationQuery";
    private BasicDataSource datasource;

    public PoolingConnectionProvider(String dbDriver, String dbURL, String dbUser, String dbPassword, int maxConnections, String dbValidationQuery) throws SQLException {
        this.initialize(dbDriver, dbURL, dbUser, dbPassword, maxConnections, dbValidationQuery);
    }

    private void initialize(String dbDriver, String dbURL, String dbUser, String dbPassword, int maxConnections, String dbValidationQuery) throws SQLException {
        if (dbDriver == null) {
            throw new SQLException("DB driver class name cannot be null!");
        }
        if (dbURL == null) {
            throw new SQLException("DB URL cannot be null!");
        }
        if (maxConnections < 0) {
            throw new SQLException("Max connections must be greater than zero!");
        }
        this.datasource = new BasicDataSource();
        this.datasource.setDriverClassName(dbDriver);
        this.datasource.setUrl(dbURL);
        this.datasource.setUsername(dbUser);
        this.datasource.setPassword(dbPassword);
        this.datasource.setMaxActive(maxConnections);
        if (dbValidationQuery != null) {
            this.datasource.setValidationQuery(dbValidationQuery);
        }
    }

    public PoolingConnectionProvider(Properties config) throws SQLException {
        PropertiesParser cfg = new PropertiesParser(config);
        String url = config.getProperty(DB_URL);
        try {
            this.initialize(config.getProperty(DB_DRIVER), url, config.getProperty(DB_USER), config.getProperty(DB_PASSWORD), cfg.getIntProperty(DB_MAX_CONNECTIONS, 3), cfg.getStringProperty(DB_VALIDATION_QUERY));
        }
        catch (Exception e) {
            throw new SQLException("DBPool '" + url + "' could not be created: " + e.toString());
        }
    }

    public Connection getConnection() throws SQLException {
        return this.datasource.getConnection();
    }

    public void shutdown() throws SQLException {
        this.datasource.close();
    }
}

