/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep.validator;

import com.google.apphosting.datastore.shared.Config;
import com.google.cloud.datastore.core.exception.ProblemCode;
import com.google.cloud.datastore.core.exception.ValidationException;
import com.google.cloud.datastore.core.names.ProjectIds;
import com.google.cloud.datastore.core.rep.DatabaseRef;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.EntitySize;
import com.google.cloud.datastore.core.rep.PartitionRef;
import com.google.cloud.datastore.core.rep.validator.BaseDatastoreValidator;
import com.google.cloud.datastore.core.rep.validator.DatabaseRefValidator;
import com.google.cloud.datastore.core.rep.validator.ValidationConstraint;
import com.google.cloud.datastore.core.rep.validator.ValidationUtils;

public class EntityValidator
extends BaseDatastoreValidator {
    private static final ValidationUtils VALIDATION_UTILS = ValidationUtils.INSTANCE;

    public EntityValidator(Config.DatastoreConfig config) {
        super(config);
    }

    public void validateKey(ValidationConstraint constraint, EntityRef entityRef) throws ValidationException {
        int keySizeLimit;
        boolean lastElementComplete;
        this.validatePartitionRef(constraint, entityRef.partitionRef());
        EntityRef.Path path = entityRef.path();
        ValidationException.validateAssertion(!path.isEmpty(), "Key path is empty.", new Object[0]);
        ValidationException.validateAssertion(path.size() <= 100, "Key path is too long. Cannot exceed %d elements.", 100);
        for (int i = 0; i < path.size(); ++i) {
            EntityRef.PathElement element = (EntityRef.PathElement)path.elements().get(i);
            this.validateKind(constraint, element.collectionId(), "key path element kind");
            EntityRef.ResourceId resourceId = element.resourceId();
            if (resourceId != null) {
                if (!resourceId.isString()) continue;
                this.validateKeyPathName(constraint, resourceId.asString());
                continue;
            }
            ValidationException.validateAssertion(i == path.size() - 1, "Key path element must not be incomplete: %s", VALIDATION_UTILS.toPathString(path));
        }
        boolean bl = lastElementComplete = entityRef.lastPathElement().resourceId() != null;
        if (!constraint.allowCompleteKey()) {
            ValidationException.validateAssertion(!lastElementComplete, "Key path element must not be complete: %s", VALIDATION_UTILS.toPathString(path));
        }
        if (!constraint.allowIncompleteKey(this.config.getAllowIncompleteKeyPathsInQueryFilters())) {
            ValidationException.validateAssertion(lastElementComplete, ProblemCode.INCOMPLETE_KEY_PATHS_IN_QUERY_FILTERS, "Key path element must not be incomplete: %s", VALIDATION_UTILS.toPathString(path));
        }
        if ((keySizeLimit = constraint.getCustomizableConfig(this.config).getMaxEntityKeySizeBytes()) > 0) {
            this.validateLength(EntitySize.entityRefSize(entityRef), keySizeLimit, ProblemCode.KEY_SIZE_OVER_LIMIT, "entity key");
        }
    }

    void validatePartitionRef(ValidationConstraint constraint, PartitionRef partitionRef) throws ValidationException {
        this.validateDatabaseRef(constraint, partitionRef.databaseRef());
        this.validateNamespace(constraint, partitionRef.namespace());
        if (constraint.getCustomizableConfig(this.config).getEnableAppEngV3ValidateEntityRefIntraPartition()) {
            String constraintPartitionId = constraint.partitionId();
            String keyPartitionId = partitionRef.databaseRef().partitionId();
            ValidationException.validateAssertion(constraintPartitionId == null || constraintPartitionId.equals(keyPartitionId), ProblemCode.CROSS_PARTITION_ENTITY_REF, "Entity key's app id's partition id '%s' does not match containing entity's '%s'.", keyPartitionId, constraintPartitionId);
        }
    }

    void validateDatabaseRef(ValidationConstraint constraint, DatabaseRef databaseRef) throws ValidationException {
        ValidationException.validateAssertion(!databaseRef.rawProjectId().isEmpty(), "The app id is the empty string.", new Object[0]);
        ValidationException.validateAssertion(ProjectIds.isValidProjectId(databaseRef.rawProjectId()), "\"%s\" is an invalid app id.", databaseRef.rawProjectId());
        if (!this.config.getAllowDatabases()) {
            ValidationException.validateAssertion(databaseRef.databaseId().isEmpty(), ProblemCode.NO_DB_SUPPORT, "Database support is not enabled.", new Object[0]);
        }
        if (!databaseRef.databaseId().isEmpty()) {
            this.validateDatabase(constraint, databaseRef.databaseId());
        }
        if (!constraint.allowMetadataAccess()) {
            ValidationException.validateAssertion(!databaseRef.isMetadata(), "The app id %s is reserved.", databaseRef.appId());
        }
        if (!constraint.allowReservedKey()) {
            this.validateStringNotReserved(databaseRef.projectId(), "app id");
        }
    }

    public void validateKeyInPartition(EntityRef value, PartitionRef expectedPartition, String desc) throws ValidationException {
        PartitionRef partitionRef = value.partitionRef();
        DatabaseRef dbName = partitionRef.databaseRef();
        DatabaseRefValidator.INSTANCE.validateDatabaseRefMatch(dbName, expectedPartition.databaseRef());
        String expectedNamespace = expectedPartition.namespace();
        ValidationException.validateAssertion(expectedNamespace.isEmpty() && partitionRef.namespace().isEmpty() || "__all__".equals(expectedNamespace) || partitionRef.namespace().equals(expectedNamespace), "The query namespace is '%s' but %s namespace is '%s'.", expectedNamespace, desc, partitionRef.namespace());
    }
}

