/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.AutoValue_IndexValueAndRemainder;
import com.google.cloud.datastore.core.rep.IndexValue;
import com.google.storage.onestore.v3.OnestoreEntity;

@AutoValue
public abstract class IndexValueAndRemainder {
    public static IndexValueAndRemainder createWithoutRemainder(IndexValue indexValue) {
        return new AutoValue_IndexValueAndRemainder(indexValue, OnestoreEntity.Property.Meaning.NO_MEANING);
    }

    public static IndexValueAndRemainder createForDatastore(IndexValue indexValue, OnestoreEntity.Property.Meaning meaning) {
        return new AutoValue_IndexValueAndRemainder(indexValue, meaning);
    }

    public static IndexValueAndRemainder createForFirestore(IndexValue indexValue) {
        return new AutoValue_IndexValueAndRemainder(indexValue, OnestoreEntity.Property.Meaning.NO_MEANING);
    }

    public static IndexValueAndRemainder createStringForDatastore(String value) {
        IndexValue indexValue = IndexValue.createDatastoreUntruncatedBytesWithStringNaturalSize(ByteString.copyFromUtf8((String)value));
        return new AutoValue_IndexValueAndRemainder(indexValue, OnestoreEntity.Property.Meaning.NO_MEANING);
    }

    public abstract IndexValue indexValue();

    public abstract OnestoreEntity.Property.Meaning meaning();

    public int naturalSize() {
        return this.indexValue().naturalSize();
    }
}

