/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.appengv3;

import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.Ordering;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.protobuf.Message;
import com.google.appengine.repackaged.com.google.protobuf.bridge.ProtoConverter;
import com.google.appengine.repackaged.com.google.storage.onestore.v3.proto2api.OnestoreEntity;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;

public class Canonicalize {
    private static final ProtoConverter<OnestoreEntity.EntityProto, OnestoreEntity.EntityProto> PB1_TO_PB2_CONVERTER = ProtoConverter.forProtos((ProtocolMessage)OnestoreEntity.EntityProto.getDefaultInstance(), (Message)OnestoreEntity.EntityProto.getDefaultInstance());
    private static final Comparator<OnestoreEntity.Property> PROPERTY_NAME_COMPARATOR = Comparator.comparing(OnestoreEntity.Property::getName);

    public static OnestoreEntity.EntityProto canonicalizeEntity(@Nullable OnestoreEntity.EntityProto entity) {
        if (entity == null) {
            return null;
        }
        OnestoreEntity.EntityProto canonical = (OnestoreEntity.EntityProto)entity.clone();
        canonical.clearProperty().mutablePropertys().addAll(Canonicalize.canonicalizeProperties(entity.propertys()));
        canonical.clearRawProperty().mutableRawPropertys().addAll(Canonicalize.canonicalizeProperties(entity.rawPropertys()));
        return canonical;
    }

    public static OnestoreEntity.EntityProto canonicalizeEntity(@Nullable OnestoreEntity.EntityProto entity) {
        return (OnestoreEntity.EntityProto)PB1_TO_PB2_CONVERTER.convert((Object)Canonicalize.canonicalizeEntity((OnestoreEntity.EntityProto)PB1_TO_PB2_CONVERTER.reverse().convert((Object)entity)));
    }

    private static List<OnestoreEntity.Property> canonicalizeProperties(List<OnestoreEntity.Property> properties) {
        return (List)properties.stream().map(Canonicalize::canonicalizeProperty).sorted((Comparator<OnestoreEntity.Property>)Ordering.from(PROPERTY_NAME_COMPARATOR)).collect(ImmutableList.toImmutableList());
    }

    private static OnestoreEntity.Property canonicalizeProperty(OnestoreEntity.Property property) {
        OnestoreEntity.Property canonical = property;
        if (property.getMeaningEnum() == OnestoreEntity.Property.Meaning.ENTITY_PROTO) {
            try {
                byte[] entityValueBytes = property.getValue().getStringValueAsBytes();
                OnestoreEntity.EntityProto entityValue = (OnestoreEntity.EntityProto)OnestoreEntity.EntityProto.parser().parsePartialFrom(entityValueBytes);
                byte[] canonicalBytes = Canonicalize.canonicalizeEntity(entityValue).toByteArray();
                canonical = (OnestoreEntity.Property)canonical.clone();
                canonical.getMutableValue().setStringValueAsBytes(canonicalBytes);
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                // empty catch block
            }
        }
        return canonical;
    }

    private Canonicalize() {
    }
}

