/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.lucene.analysis.standard;

import com.google.appengine.repackaged.org.apache.lucene.analysis.TokenFilter;
import com.google.appengine.repackaged.org.apache.lucene.analysis.TokenStream;
import com.google.appengine.repackaged.org.apache.lucene.analysis.standard.StandardTokenizerImpl;
import com.google.appengine.repackaged.org.apache.lucene.analysis.tokenattributes.TermAttribute;
import com.google.appengine.repackaged.org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import java.io.IOException;

public final class StandardFilter
extends TokenFilter {
    private static final String APOSTROPHE_TYPE = StandardTokenizerImpl.TOKEN_TYPES[1];
    private static final String ACRONYM_TYPE = StandardTokenizerImpl.TOKEN_TYPES[2];
    private TypeAttribute typeAtt;
    private TermAttribute termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);

    public StandardFilter(TokenStream in) {
        super(in);
        this.typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);
    }

    public final boolean incrementToken() throws IOException {
        if (!this.input.incrementToken()) {
            return false;
        }
        char[] buffer = this.termAtt.termBuffer();
        int bufferLength = this.termAtt.termLength();
        String type = this.typeAtt.type();
        if (type == APOSTROPHE_TYPE && bufferLength >= 2 && buffer[bufferLength - 2] == '\'' && (buffer[bufferLength - 1] == 's' || buffer[bufferLength - 1] == 'S')) {
            this.termAtt.setTermLength(bufferLength - 2);
        } else if (type == ACRONYM_TYPE) {
            int upto = 0;
            for (int i = 0; i < bufferLength; ++i) {
                char c = buffer[i];
                if (c == '.') continue;
                buffer[upto++] = c;
            }
            this.termAtt.setTermLength(upto);
        }
        return true;
    }
}

