/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.geometry.BigPoint;
import com.google.appengine.repackaged.com.google.common.geometry.Platform;
import com.google.appengine.repackaged.com.google.common.geometry.S1ChordAngle;
import com.google.appengine.repackaged.com.google.common.geometry.S2;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import java.math.BigDecimal;

@GwtCompatible
public strictfp final class S2Predicates {
    private static final double DBL_ERR;
    private static final double T_ERR;
    private static final S1ChordAngle DEG_45;
    private static final BigDecimal QUARTER;
    private static final BigDecimal HALF;
    private static final BigDecimal TWO;
    private static final BigDecimal FOUR;

    public static int sign(S2Point a, S2Point b, S2Point c) {
        return Sign.sign(a, b, c, true);
    }

    public static boolean orderedCCW(S2Point a, S2Point b, S2Point c, S2Point o) {
        int sum = 0;
        if (S2Predicates.sign(b, o, a) >= 0) {
            ++sum;
        }
        if (S2Predicates.sign(c, o, b) >= 0) {
            ++sum;
        }
        if (S2Predicates.sign(a, o, c) > 0) {
            ++sum;
        }
        return sum >= 2;
    }

    static int compareDistances(S2Point x, S2Point a, S2Point b) {
        int sign = CompareDistances.triageCos(x, a, b);
        if (sign != 0) {
            return sign;
        }
        if (a.equalsPoint(b)) {
            return 0;
        }
        double cosAX = a.dotProd(x);
        if (cosAX > S2.M_SQRT1_2) {
            sign = CompareDistances.triageSin2(x, a, b);
        } else if (cosAX < -S2.M_SQRT1_2) {
            sign = -CompareDistances.triageSin2(x, a, b);
        }
        if (sign != 0) {
            return sign;
        }
        sign = CompareDistances.exact(x, a, b);
        if (sign != 0) {
            return sign;
        }
        return CompareDistances.sos(a, b);
    }

    static int compareDistance(S2Point x, S2Point y, double r2) {
        int sign = CompareDistance.triage(x, y, r2);
        if (sign != 0) {
            return sign;
        }
        return CompareDistance.exact(x, y, r2);
    }

    static int compareEdgeDistance(S2Point x, S2Point a, S2Point b, double r2) {
        int sign = CompareEdgeDistance.triage(x, a, b, r2);
        if (sign != 0) {
            return sign;
        }
        if (a.equalsPoint(b)) {
            return S2Predicates.compareDistance(x, a, r2);
        }
        return CompareEdgeDistance.exact(x, a, b, r2);
    }

    static int compareEdgeDirections(S2Point a, S2Point b, S2Point c, S2Point d) {
        int sign = CompareEdgeDirections.triage(a, b, c, d);
        if (sign != 0) {
            return sign;
        }
        if (a.equalsPoint(b) || c.equalsPoint(d)) {
            return 0;
        }
        return CompareEdgeDirections.exact(a, b, c, d);
    }

    static int edgeCircumcenterSign(S2Point p, S2Point q, S2Point a, S2Point b, S2Point c) {
        int abc = S2Predicates.sign(a, b, c);
        int sign = EdgeCircumcenterSign.triage(p, q, a, b, c, abc);
        if (sign != 0) {
            return sign;
        }
        if (p.equalsPoint(q) || a.equalsPoint(b) || b.equalsPoint(c) || c.equalsPoint(a)) {
            return 0;
        }
        sign = EdgeCircumcenterSign.exact(p, q, a, b, c, abc);
        if (sign != 0) {
            return sign;
        }
        return EdgeCircumcenterSign.sos(p, q, a, b, c);
    }

    static Excluded getVoronoiSiteExclusion(S2Point a, S2Point b, S2Point p, S2Point q, double r2) {
        if (S2Predicates.compareDistances(q, a, b) < 0) {
            return Excluded.SECOND;
        }
        Excluded result = VoronoiSiteExclusion.triage(a, b, p, q, r2);
        return result != Excluded.UNCERTAIN ? result : VoronoiSiteExclusion.exact(a, b, p, q, r2);
    }

    private static S2Point ndCross(S2Point a, S2Point b) {
        return a.sub(b).crossProd(a.add(b));
    }

    private static double cosDistance(S2Point x, S2Point y) {
        return x.dotProd(y);
    }

    private static double cosDistanceError(double x) {
        return 9.5 * DBL_ERR * Math.abs(x) + 1.5 * DBL_ERR;
    }

    private static double sin2Distance(S2Point x, S2Point y) {
        return 0.25 * S2Predicates.ndCross(x, y).norm2();
    }

    private static double sin2DistanceError(double x) {
        return (21.0 + 4.0 * Math.sqrt(3.0)) * DBL_ERR * x + 32.0 * Math.sqrt(3.0) * DBL_ERR * DBL_ERR * Math.sqrt(x) + 768.0 * DBL_ERR * DBL_ERR * DBL_ERR * DBL_ERR;
    }

    private static int signum(double value, double error) {
        return value > error ? 1 : (value < -error ? -1 : 0);
    }

    private static int compare(double a, double aError, double b, double bError) {
        double diff = a - b;
        double error = aError + bError;
        return diff > error ? 1 : (diff < -error ? -1 : 0);
    }

    private static S2Point closestVertex(S2Point x, S2Point a, S2Point b, double[] dx2) {
        double bx2;
        double ax2 = a.getDistance2(x);
        if (ax2 < (bx2 = b.getDistance2(x)) || ax2 == bx2 && a.lessThan(b)) {
            dx2[0] = ax2;
            return a;
        }
        dx2[0] = bx2;
        return b;
    }

    private static S2Point circumcenter(S2Point a, S2Point b, S2Point c, double[] error) {
        S2Point abDiff = a.sub(b);
        S2Point abSum = a.add(b);
        S2Point bcDiff = b.sub(c);
        S2Point bcSum = b.add(c);
        S2Point nab = abDiff.crossProd(abSum);
        double nabLen = nab.norm();
        double abLen = abDiff.norm();
        S2Point nbc = bcDiff.crossProd(bcSum);
        double nbcLen = nbc.norm();
        double bcLen = bcDiff.norm();
        S2Point mab = nab.crossProd(abSum);
        S2Point mbc = nbc.crossProd(bcSum);
        error[0] = ((16.0 + 24.0 * Math.sqrt(3.0)) * T_ERR + 8.0 * DBL_ERR * (abLen + bcLen)) * nabLen * nbcLen + 128.0 * Math.sqrt(3.0) * DBL_ERR * T_ERR * (nabLen + nbcLen) + 12288.0 * DBL_ERR * DBL_ERR * T_ERR * T_ERR;
        return mab.crossProd(mbc);
    }

    private static BigPoint big(S2Point p) {
        return new BigPoint(p);
    }

    private static BigDecimal big(double v) {
        return Platform.newBigDecimal(v);
    }

    private static BigDecimal square(BigDecimal v) {
        return v.multiply(v);
    }

    private S2Predicates() {
    }

    static {
        T_ERR = DBL_ERR = S2.DBL_EPSILON / 2.0;
        DEG_45 = S1ChordAngle.fromLength2(2.0 - S2.M_SQRT2);
        QUARTER = new BigDecimal("0.25");
        HALF = new BigDecimal("0.5");
        TWO = new BigDecimal("2");
        FOUR = new BigDecimal("4");
    }

    strictfp static class VoronoiSiteExclusion {
        static final BigDecimal R90 = S2Predicates.access$900(S1ChordAngle.RIGHT.getLength2());

        private VoronoiSiteExclusion() {
        }

        public static Excluded triage(S2Point a, S2Point b, S2Point p, S2Point q, double r2) {
            double cosDError;
            double sinDError;
            double resultError;
            S2Point n = S2Predicates.ndCross(p, q);
            double n2 = n.norm2();
            double n1 = Math.sqrt(n2);
            double dnError = ((3.5 + 2.0 * Math.sqrt(3.0)) * n1 + 32.0 * Math.sqrt(3.0) * DBL_ERR) * T_ERR;
            double cosR = 1.0 - 0.5 * r2;
            double sin2r = r2 * (1.0 - 0.25 * r2);
            double n2sin2r = n2 * sin2r;
            double[] d = new double[]{0.0};
            double aDn = a.sub(S2Predicates.closestVertex(a, p, q, d)).dotProd(n);
            double aDn2 = aDn * aDn;
            double aDnError = dnError * Math.sqrt(d[0]);
            double ra2 = n2sin2r - aDn2;
            double ra2Error = (8.0 * DBL_ERR + 4.0 * T_ERR) * aDn2 + (2.0 * Math.abs(aDn) + aDnError) * aDnError + 6.0 * T_ERR * n2sin2r;
            double minRa2 = ra2 - ra2Error;
            if (minRa2 < 0.0) {
                return Excluded.UNCERTAIN;
            }
            double ra = Math.sqrt(ra2);
            double raError = 1.5 * T_ERR * ra + 0.5 * ra2Error / Math.sqrt(minRa2);
            double[] bx2 = new double[]{0.0};
            double bDn = b.sub(S2Predicates.closestVertex(b, p, q, bx2)).dotProd(n);
            double bDn2 = bDn * bDn;
            double bDnError = dnError * Math.sqrt(bx2[0]);
            double rb2 = n2sin2r - bDn2;
            double rb2Error = (8.0 * DBL_ERR + 4.0 * T_ERR) * bDn2 + (2.0 * Math.abs(bDn) + bDnError) * bDnError + 6.0 * T_ERR * n2sin2r;
            double minRb2 = rb2 - rb2Error;
            if (minRb2 < 0.0) {
                return Excluded.UNCERTAIN;
            }
            double rb = Math.sqrt(rb2);
            double rbError = 1.5 * T_ERR * rb + 0.5 * rb2Error / Math.sqrt(minRb2);
            double lhs3 = cosR * (rb - ra);
            double absLhs3 = Math.abs(lhs3);
            double lhs3Error = cosR * (raError + rbError) + 3.0 * T_ERR * absLhs3;
            S2Point aXb = S2Predicates.ndCross(a, b);
            double aXb1 = aXb.norm();
            double sinD = 0.5 * aXb.dotProd(n);
            double result = absLhs3 - sinD;
            if (result < -(resultError = lhs3Error + (sinDError = (4.0 * DBL_ERR + (2.5 + 2.0 * Math.sqrt(3.0)) * T_ERR) * aXb1 * n1 + 16.0 * Math.sqrt(3.0) * DBL_ERR * T_ERR * (aXb1 + n1)))) {
                return Excluded.NEITHER;
            }
            double cosD = a.dotProd(b) * n2 - aDn * bDn;
            if (cosD <= -(cosDError = ((8.0 * DBL_ERR + 5.0 * T_ERR) * Math.abs(aDn) + aDnError) * Math.abs(bDn) + (Math.abs(aDn) + aDnError) * bDnError + (8.0 * DBL_ERR + 8.0 * T_ERR) * n2)) {
                return Excluded.NEITHER;
            }
            if (cosD < cosDError) {
                return Excluded.UNCERTAIN;
            }
            if (sinD < -sinDError) {
                int cb;
                double r90 = S1ChordAngle.RIGHT.getLength2();
                int ca = lhs3 < -lhs3Error ? -1 : CompareDistance.triageCos(a, p, r90);
                int n3 = cb = lhs3 > lhs3Error ? -1 : CompareDistance.triageCos(b, q, r90);
                if (ca < 0 && cb < 0) {
                    return Excluded.NEITHER;
                }
                if (ca <= 0 && cb <= 0) {
                    return Excluded.UNCERTAIN;
                }
                if (absLhs3 <= lhs3Error) {
                    return Excluded.UNCERTAIN;
                }
            } else if (sinD <= sinDError) {
                return Excluded.UNCERTAIN;
            }
            if (result <= resultError) {
                return Excluded.UNCERTAIN;
            }
            return lhs3 > 0.0 ? Excluded.FIRST : Excluded.SECOND;
        }

        public static Excluded exact(S2Point a, S2Point b, S2Point p, S2Point q, double r2) {
            return VoronoiSiteExclusion.exact(S2Predicates.big(a), S2Predicates.big(b), S2Predicates.big(p), S2Predicates.big(q), S2Predicates.big(r2));
        }

        public static Excluded exact(BigPoint a, BigPoint b, BigPoint p, BigPoint q, BigDecimal r2) {
            BigDecimal rhs4;
            BigPoint n = p.crossProd(q);
            BigDecimal n2 = n.norm2();
            BigDecimal aDn = a.dotProd(n);
            BigDecimal bDn = b.dotProd(n);
            int cosDSign = a.dotProd(b).multiply(n2).compareTo(aDn.multiply(bDn));
            if (cosDSign < 0) {
                return Excluded.NEITHER;
            }
            BigDecimal a2 = a.norm2();
            BigDecimal b2 = b.norm2();
            BigDecimal n2Sin2R = r2.multiply(BigDecimal.ONE.subtract(QUARTER.multiply(r2))).multiply(n2);
            BigDecimal sa2 = b2.multiply(n2Sin2R.multiply(a2).subtract(S2Predicates.square(aDn)));
            BigDecimal sb2 = a2.multiply(n2Sin2R.multiply(b2).subtract(S2Predicates.square(bDn)));
            int lhsSign2 = sb2.compareTo(sa2);
            BigDecimal rhs2 = a.crossProd(b).dotProd(n);
            int rhsSign2 = rhs2.signum();
            if (rhsSign2 < 0) {
                int cb;
                int ca = lhsSign2 < 0 ? -1 : CompareDistance.exact(a, p, R90);
                int n3 = cb = lhsSign2 > 0 ? -1 : CompareDistance.exact(b, q, R90);
                if (ca <= 0 && cb <= 0) {
                    return Excluded.NEITHER;
                }
                return ca == 1 ? Excluded.FIRST : Excluded.SECOND;
            }
            if (lhsSign2 == 0) {
                return Excluded.NEITHER;
            }
            BigDecimal cosR = BigDecimal.ONE.subtract(HALF.multiply(r2));
            BigDecimal cos2R = S2Predicates.square(cosR);
            BigDecimal lhs3 = cos2R.multiply(sa2.add(sb2)).subtract(S2Predicates.square(rhs2));
            if (lhs3.signum() < 0) {
                return Excluded.NEITHER;
            }
            BigDecimal lhs4 = S2Predicates.square(lhs3);
            int result = lhs4.compareTo(rhs4 = FOUR.multiply(S2Predicates.square(cos2R)).multiply(sa2).multiply(sb2));
            if (result < 0) {
                return Excluded.NEITHER;
            }
            if (result == 0 && lhsSign2 > 0 == a.compareTo(b) > 0) {
                return Excluded.NEITHER;
            }
            return lhsSign2 > 0 ? Excluded.FIRST : Excluded.SECOND;
        }
    }

    strictfp static enum Excluded {
        FIRST,
        SECOND,
        NEITHER,
        UNCERTAIN;

    }

    strictfp static class EdgeCircumcenterSign {
        private EdgeCircumcenterSign() {
        }

        public static int triage(S2Point p, S2Point q, S2Point a, S2Point b, S2Point c, int abc) {
            double[] zError = new double[]{0.0};
            S2Point z = S2Predicates.circumcenter(a, b, c, zError);
            S2Point nx = S2Predicates.ndCross(p, q);
            double result = (double)abc * nx.dotProd(z);
            double zLen = z.norm();
            double nxLen = nx.norm();
            double nxError = ((1.0 + 2.0 * Math.sqrt(3.0)) * nxLen + 32.0 * Math.sqrt(3.0) * DBL_ERR) * T_ERR;
            double resultError = (3.0 * T_ERR * nxLen + nxError) * zLen + zError[0] * nxLen;
            return S2Predicates.signum(result, resultError);
        }

        public static int exact(S2Point p, S2Point q, S2Point a, S2Point b, S2Point c, int abc) {
            return EdgeCircumcenterSign.exact(S2Predicates.big(p), S2Predicates.big(q), S2Predicates.big(a), S2Predicates.big(b), S2Predicates.big(c), abc);
        }

        public static int exact(BigPoint p, BigPoint q, BigPoint a, BigPoint b, BigPoint c, int abc) {
            int rhsSign2;
            int result;
            int rhs3Sign;
            if (p.isLinearlyDependent(q)) {
                return 0;
            }
            BigPoint nx = p.crossProd(q);
            BigDecimal dab = nx.dotProd(a.crossProd(b));
            BigDecimal dbc = nx.dotProd(b.crossProd(c));
            BigDecimal dca = nx.dotProd(c.crossProd(a));
            BigDecimal abc2 = a.norm2().multiply(S2Predicates.square(dbc));
            BigDecimal bca2 = b.norm2().multiply(S2Predicates.square(dca));
            BigDecimal cab2 = c.norm2().multiply(S2Predicates.square(dab));
            int lhsSign3 = dab.signum();
            int lhsSign2 = Math.max(-1, Math.min(1, lhsSign3 - (rhs3Sign = -dbc.signum())));
            if (lhsSign2 == 0 && lhsSign3 != 0) {
                lhsSign2 = cab2.compareTo(abc2) * lhsSign3;
            }
            if ((result = Math.max(-1, Math.min(1, lhsSign2 - (rhsSign2 = -dca.signum())))) == 0 && lhsSign2 != 0) {
                BigDecimal rhs4;
                int lhsSign4 = dab.signum() * dbc.signum();
                result = Math.max(-1, Math.min(1, lhsSign4 - (rhs4 = bca2.subtract(cab2).subtract(abc2)).signum()));
                if (result == 0 && lhsSign4 != 0) {
                    result = FOUR.multiply(abc2).multiply(cab2).compareTo(S2Predicates.square(rhs4)) * lhsSign4;
                }
                result *= lhsSign2;
            }
            return abc * result;
        }

        public static int sos(S2Point p, S2Point q, S2Point a, S2Point b, S2Point c) {
            int sign;
            S2Point temp;
            if (a.equalsPoint(b) || b.equalsPoint(c) || c.equalsPoint(a)) {
                return 0;
            }
            if (b.compareTo(a) < 0) {
                temp = a;
                a = b;
                b = temp;
            }
            if (c.compareTo(b) < 0) {
                temp = b;
                b = c;
                c = temp;
            }
            if (b.compareTo(a) < 0) {
                temp = a;
                a = b;
                b = temp;
            }
            if ((sign = Sign.sign(p, q, a, false)) != 0) {
                return sign;
            }
            sign = Sign.sign(p, q, b, false);
            if (sign != 0) {
                return sign;
            }
            return Sign.sign(p, q, c, false);
        }
    }

    strictfp static class CompareEdgeDirections {
        private CompareEdgeDirections() {
        }

        public static int triage(S2Point a, S2Point b, S2Point c, S2Point d) {
            S2Point n1 = S2Predicates.ndCross(a, b);
            S2Point n2 = S2Predicates.ndCross(c, d);
            double len1 = n1.norm();
            double len2 = n2.norm();
            double cos = n1.dotProd(n2);
            double cosError = ((5.0 + 4.0 * Math.sqrt(3.0)) * len1 * len2 + 32.0 * Math.sqrt(3.0) * DBL_ERR * (len1 + len2)) * T_ERR;
            return S2Predicates.signum(cos, cosError);
        }

        public static int exact(S2Point a, S2Point b, S2Point c, S2Point d) {
            return CompareEdgeDirections.exact(S2Predicates.big(a), S2Predicates.big(b), S2Predicates.big(c), S2Predicates.big(d));
        }

        public static int exact(BigPoint a, BigPoint b, BigPoint c, BigPoint d) {
            return a.crossProd(b).dotProd(c.crossProd(d)).signum();
        }
    }

    strictfp static class CompareEdgeDistance {
        private CompareEdgeDistance() {
        }

        public static int triage(S2Point x, S2Point a, S2Point b, double r2) {
            S2Point n = S2Predicates.ndCross(a, b);
            S2Point m = n.crossProd(x);
            S2Point aDir = a.sub(x);
            S2Point bDir = b.sub(x);
            double aSign = aDir.dotProd(m);
            double bSign = bDir.dotProd(m);
            double n2 = n.norm2();
            double n1 = Math.sqrt(n2);
            double n1Error = ((3.5 + 8.0 / Math.sqrt(3.0)) * n1 + 32.0 * Math.sqrt(3.0) * DBL_ERR) * T_ERR;
            double aSignError = n1Error * aDir.norm();
            double bSignError = n1Error * bDir.norm();
            if (Math.abs(aSign) < aSignError || Math.abs(bSign) < bSignError) {
                int lineSign;
                int vertexSign = CompareEdgeDistance.triageLineEndpoints(x, a, b, r2);
                return vertexSign == (lineSign = CompareEdgeDistance.triageLineInterior(x, a, b, r2, n, n1, n2)) ? lineSign : 0;
            }
            if (aSign >= 0.0 || bSign <= 0.0) {
                return CompareEdgeDistance.triageLineEndpoints(x, a, b, r2);
            }
            return CompareEdgeDistance.triageLineInterior(x, a, b, r2, n, n1, n2);
        }

        static int triageLineEndpoints(S2Point x, S2Point a, S2Point b, double r2) {
            return Math.min(CompareDistance.triage(x, a, r2), CompareDistance.triage(x, b, r2));
        }

        static int triageLineInterior(S2Point x, S2Point a, S2Point b, double r2, S2Point n, double n1, double n2) {
            if (r2 < DEG_45.getLength2()) {
                return CompareEdgeDistance.triageLineSin2(x, a, b, r2, n, n1, n2);
            }
            return CompareEdgeDistance.triageLineCos2(x, r2, n, n1, n2);
        }

        static int triageLineSin2(S2Point x, S2Point a, S2Point b, double r2, S2Point n, double n1, double n2) {
            if (r2 >= 2.0) {
                return -1;
            }
            double n2Sin2R = n2 * r2 * (1.0 - 0.25 * r2);
            double n2Sin2RError = 6.0 * T_ERR * n2Sin2R;
            double[] ax2 = new double[]{0.0};
            double xDn = x.sub(S2Predicates.closestVertex(x, a, b, ax2)).dotProd(n);
            double xDn2 = xDn * xDn;
            double c1 = ((3.5 + 2.0 * Math.sqrt(3.0)) * n1 + 32.0 * Math.sqrt(3.0) * DBL_ERR) * T_ERR * Math.sqrt(ax2[0]);
            double xDn2Error = 4.0 * T_ERR * xDn2 + (2.0 * Math.abs(xDn) + c1) * c1;
            n2Sin2RError = T_ERR < DBL_ERR ? (n2Sin2RError += 4.0 * T_ERR * (n2Sin2R *= x.norm2())) : (n2Sin2RError += 8.0 * DBL_ERR * n2Sin2R);
            return S2Predicates.compare(xDn2, xDn2Error, n2Sin2R, n2Sin2RError);
        }

        static int triageLineCos2(S2Point x, double r2, S2Point n, double n1, double n2) {
            if (r2 >= 2.0) {
                return -1;
            }
            double cosR = 1.0 - 0.5 * r2;
            double n2Cos2R = n2 * cosR * cosR;
            double n2Cos2RError = 7.0 * DBL_ERR * n2Cos2R;
            double m2 = x.crossProd(n).norm2();
            double m1 = Math.sqrt(m2);
            double m1Error = ((1.0 + 8.0 / Math.sqrt(3.0)) * n1 + 32.0 * Math.sqrt(3.0) * DBL_ERR) * DBL_ERR;
            double m2Error = 3.0 * DBL_ERR * m2 + (2.0 * m1 + m1Error) * m1Error;
            n2Cos2RError = T_ERR < DBL_ERR ? (n2Cos2RError += 4.0 * T_ERR * (n2Cos2R *= x.norm2())) : (n2Cos2RError += 8.0 * DBL_ERR * n2Cos2R);
            return S2Predicates.compare(n2Cos2R, n2Cos2RError, m2, m2Error);
        }

        public static int exact(S2Point x, S2Point a, S2Point b, double r2) {
            if (S2Predicates.compareEdgeDirections(a, b, a, x) > 0 && S2Predicates.compareEdgeDirections(a, b, x, b) > 0) {
                return CompareEdgeDistance.exactLineInterior(S2Predicates.big(x), S2Predicates.big(a), S2Predicates.big(b), S2Predicates.big(r2));
            }
            return CompareEdgeDistance.exactLineEndpoints(x, a, b, r2);
        }

        static int exactLineEndpoints(S2Point x, S2Point a, S2Point b, double r2) {
            return Math.min(S2Predicates.compareDistance(x, a, r2), S2Predicates.compareDistance(x, b, r2));
        }

        static int exactLineInterior(BigPoint x, BigPoint a, BigPoint b, BigDecimal r2) {
            if (r2.compareTo(TWO) >= 0) {
                return -1;
            }
            BigPoint n = a.crossProd(b);
            BigDecimal sinD = x.dotProd(n);
            BigDecimal sin2R = r2.multiply(BigDecimal.ONE.subtract(QUARTER.multiply(r2)));
            return S2Predicates.square(sinD).compareTo(sin2R.multiply(x.norm2()).multiply(n.norm2()));
        }
    }

    strictfp static class CompareDistance {
        private CompareDistance() {
        }

        public static int triageCos(S2Point x, S2Point y, double r2) {
            double cosXY = S2Predicates.cosDistance(x, y);
            double cosR = 1.0 - 0.5 * r2;
            return S2Predicates.compare(cosR, 2.0 * T_ERR * cosR, cosXY, S2Predicates.cosDistanceError(cosXY));
        }

        public static int triageSin2(S2Point x, S2Point y, double r2) {
            double xySin2 = S2Predicates.sin2Distance(x, y);
            double rSin2 = r2 * (1.0 - 0.25 * r2);
            return S2Predicates.compare(xySin2, S2Predicates.sin2DistanceError(xySin2), rSin2, 3.0 * T_ERR * rSin2);
        }

        public static int triage(S2Point x, S2Point y, double r2) {
            int sign = CompareDistance.triageCos(x, y, r2);
            if (sign == 0 && r2 < DEG_45.getLength2()) {
                sign = CompareDistance.triageSin2(x, y, r2);
            }
            return sign;
        }

        public static int exact(S2Point x, S2Point y, double r2) {
            return CompareDistance.exact(S2Predicates.big(x), S2Predicates.big(y), S2Predicates.big(r2));
        }

        public static int exact(BigPoint x, BigPoint y, BigDecimal r2) {
            int rSign;
            BigDecimal cosXY = x.dotProd(y);
            BigDecimal cosR = BigDecimal.ONE.subtract(HALF.multiply(r2));
            int xySign = cosXY.signum();
            if (xySign != (rSign = cosR.signum())) {
                return Integer.compare(rSign, xySign);
            }
            int cmpSign = S2Predicates.square(cosR).multiply(x.norm2().multiply(y.norm2())).compareTo(S2Predicates.square(cosXY));
            return xySign * cmpSign;
        }
    }

    strictfp static class CompareDistances {
        private CompareDistances() {
        }

        public static int triageCos(S2Point x, S2Point a, S2Point b) {
            double cosAX = S2Predicates.cosDistance(a, x);
            double cosBX = S2Predicates.cosDistance(b, x);
            return S2Predicates.compare(cosBX, S2Predicates.cosDistanceError(cosBX), cosAX, S2Predicates.cosDistanceError(cosAX));
        }

        public static int triageSin2(S2Point x, S2Point a, S2Point b) {
            double sin2AX = S2Predicates.sin2Distance(a, x);
            double sin2BX = S2Predicates.sin2Distance(b, x);
            return S2Predicates.compare(sin2AX, S2Predicates.sin2DistanceError(sin2AX), sin2BX, S2Predicates.sin2DistanceError(sin2BX));
        }

        public static int exact(S2Point x, S2Point a, S2Point b) {
            return CompareDistances.exact(S2Predicates.big(x), S2Predicates.big(a), S2Predicates.big(b));
        }

        public static int exact(BigPoint x, BigPoint a, BigPoint b) {
            int bSign;
            BigDecimal cosAX = x.dotProd(a);
            BigDecimal cosBX = x.dotProd(b);
            int aSign = cosAX.signum();
            if (aSign != (bSign = cosBX.signum())) {
                return Integer.compare(bSign, aSign);
            }
            int cmpSign = cosBX.multiply(cosBX).multiply(a.norm2()).compareTo(cosAX.multiply(cosAX).multiply(b.norm2()));
            return aSign * cmpSign;
        }

        public static int sos(S2Point a, S2Point b) {
            return b.compareTo(a);
        }
    }

    public strictfp static class Sign {
        private Sign() {
        }

        public static int triage(S2Point a, S2Point b, S2Point c) {
            double kMaxDetError = 1.6E-15;
            double det = S2Point.scalarTripleProduct(c, a, b);
            if (det >= 1.6E-15) {
                return 1;
            }
            if (det <= -1.6E-15) {
                return -1;
            }
            return 0;
        }

        public static int sign(S2Point a, S2Point b, S2Point c, boolean perturb) {
            int ccw = Sign.triage(a, b, c);
            if (ccw == 0) {
                ccw = Sign.expensive(a, b, c, perturb);
            }
            return ccw;
        }

        public static int expensive(S2Point a, S2Point b, S2Point c, boolean perturb) {
            if (a.equalsPoint(b) || b.equalsPoint(c) || c.equalsPoint(a)) {
                return 0;
            }
            int sign = Sign.stable(a, b, c);
            if (sign != 0) {
                return sign;
            }
            return Sign.exact(a, b, c, perturb);
        }

        public static int stable(S2Point a, S2Point b, S2Point c) {
            double maxError;
            double det;
            S2Point ab = S2Point.sub(b, a);
            S2Point bc = S2Point.sub(c, b);
            S2Point ca = S2Point.sub(a, c);
            double ab2 = ab.norm2();
            double bc2 = bc.norm2();
            double ca2 = ca.norm2();
            double detErrorMultiplier = 3.2321 * S2.DBL_EPSILON;
            if (ab2 >= bc2 && ab2 >= ca2) {
                det = -S2Point.scalarTripleProduct(c, ca, bc);
                maxError = detErrorMultiplier * Math.sqrt(ca2 * bc2);
            } else if (bc2 >= ca2) {
                det = -S2Point.scalarTripleProduct(a, ab, ca);
                maxError = detErrorMultiplier * Math.sqrt(ab2 * ca2);
            } else {
                det = -S2Point.scalarTripleProduct(b, bc, ab);
                maxError = detErrorMultiplier * Math.sqrt(bc2 * ab2);
            }
            return S2Predicates.signum(det, maxError);
        }

        public static int exact(S2Point a, S2Point b, S2Point c, boolean perturb) {
            BigPoint xc;
            S2Point t;
            int sign = Platform.sign(a, b, c);
            if (sign != 0) {
                return sign;
            }
            int permSign = 1;
            if (a.compareTo(b) > 0) {
                t = a;
                a = b;
                b = t;
                permSign = -permSign;
            }
            if (b.compareTo(c) > 0) {
                t = b;
                b = c;
                c = t;
                permSign = -permSign;
            }
            if (a.compareTo(b) > 0) {
                t = a;
                a = b;
                b = t;
                permSign = -permSign;
            }
            if (!(a.equalsPoint(a) && b.equalsPoint(b) && c.equalsPoint(c))) {
                return -permSign;
            }
            BigPoint xa = S2Predicates.big(a);
            BigPoint xb = S2Predicates.big(b);
            BigPoint xbc = xb.crossProd(xc = S2Predicates.big(c));
            sign = xbc.dotProd(xa).signum();
            if (sign != 0) {
                return permSign * sign;
            }
            if (!perturb) {
                return 0;
            }
            sign = Sign.sos(xa, xb, xc, xbc);
            return permSign * sign;
        }

        public static int sos(BigPoint a, BigPoint b, BigPoint c, BigPoint bc) {
            int sign = bc.z.signum();
            if (sign != 0) {
                return sign;
            }
            sign = bc.y.signum();
            if (sign != 0) {
                return sign;
            }
            sign = bc.x.signum();
            if (sign != 0) {
                return sign;
            }
            sign = c.x.multiply(a.y).subtract(c.y.multiply(a.x)).signum();
            if (sign != 0) {
                return sign;
            }
            sign = c.x.signum();
            if (sign != 0) {
                return sign;
            }
            sign = -c.y.signum();
            if (sign != 0) {
                return sign;
            }
            sign = c.z.multiply(a.x).subtract(c.x.multiply(a.z)).signum();
            if (sign != 0) {
                return sign;
            }
            sign = c.z.signum();
            if (sign != 0) {
                return sign;
            }
            sign = a.x.multiply(b.y).subtract(a.y.multiply(b.x)).signum();
            if (sign != 0) {
                return sign;
            }
            sign = -b.x.signum();
            if (sign != 0) {
                return sign;
            }
            sign = b.y.signum();
            if (sign != 0) {
                return sign;
            }
            sign = a.x.signum();
            if (sign != 0) {
                return sign;
            }
            return 1;
        }
    }
}

