/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.socket.dev;

import com.google.appengine.api.socket.SocketServicePb;
import com.google.appengine.api.socket.dev.LocalSocketService;
import com.google.appengine.api.socket.dev.SocketPermissions;
import com.google.apphosting.api.ApiProxy;
import java.io.IOException;
import java.net.InetAddress;
import java.util.concurrent.atomic.AtomicLong;

abstract class LocalSocket {
    private static final int IPV6_LEN = 16;
    private static final int IPV4_LEN = 4;
    private static final long socketNameSalt = System.currentTimeMillis();
    private static final AtomicLong socketCount = new AtomicLong(0L);
    protected final AtomicLong streamReceiveOffset = new AtomicLong(0L);
    protected final AtomicLong streamSendOffset = new AtomicLong(0L);
    protected final LocalSocketService socketService;
    SocketServicePb.CreateSocketRequest.SocketFamily socketFamily;
    private final String socketId;

    LocalSocket(LocalSocketService socketService) {
        long l = socketNameSalt;
        long l2 = socketCount.getAndIncrement();
        this.socketId = new StringBuilder(48).append("socket:").append(l).append(":").append(l2).toString();
        this.socketService = socketService;
    }

    public String getSocketDescriptor() {
        return this.socketId;
    }

    public abstract IOException close();

    public abstract SocketServicePb.BindReply bind(SocketServicePb.BindRequest var1);

    public abstract SocketServicePb.GetSocketNameReply getSocketName(SocketServicePb.GetSocketNameRequest var1);

    public abstract SocketServicePb.GetPeerNameReply getPeerName(SocketServicePb.GetPeerNameRequest var1);

    public abstract SocketServicePb.ConnectReply connect(SocketServicePb.ConnectRequest var1);

    public abstract SocketServicePb.ListenReply listen(SocketServicePb.ListenRequest var1);

    public abstract SocketServicePb.AcceptReply accept(SocketServicePb.AcceptRequest var1);

    public abstract SocketServicePb.ShutDownReply shutDown(SocketServicePb.ShutDownRequest var1);

    public abstract SocketServicePb.CloseReply close(SocketServicePb.CloseRequest var1);

    public abstract SocketServicePb.SendReply send(SocketServicePb.SendRequest var1);

    public abstract SocketServicePb.ReceiveReply receive(SocketServicePb.ReceiveRequest var1);

    public abstract SocketServicePb.CreateSocketReply createSocket(SocketServicePb.CreateSocketRequest var1);

    public SocketServicePb.SetSocketOptionsReply setSocketOptions(SocketServicePb.SetSocketOptionsRequest request) {
        SocketServicePb.SetSocketOptionsReply response = new SocketServicePb.SetSocketOptionsReply();
        for (SocketServicePb.SocketOption o : request.optionss()) {
            SocketPermissions.getSocketPermissions().checkSetSocketOpt(o);
        }
        return response;
    }

    public SocketServicePb.GetSocketOptionsReply getSocketOptions(SocketServicePb.GetSocketOptionsRequest request) {
        SocketServicePb.GetSocketOptionsReply response = new SocketServicePb.GetSocketOptionsReply();
        for (SocketServicePb.SocketOption o : request.optionss()) {
            byte[] fakeValue = SocketPermissions.getSocketPermissions().checkGetSocketOpt(o);
            response.addOptions().setLevel(o.getLevel()).setOption(o.getOption()).setValueAsBytes(fakeValue);
        }
        return response;
    }

    protected byte[] addrAsBytes(InetAddress address) {
        byte[] bytes = address.getAddress();
        if (bytes.length == 16) {
            if (this.socketFamily == SocketServicePb.CreateSocketRequest.SocketFamily.IPv6) {
                return bytes;
            }
            throw new IllegalStateException("Cannot convert IPV6 address to IPV4");
        }
        if (bytes.length == 4 && this.socketFamily == SocketServicePb.CreateSocketRequest.SocketFamily.IPv6) {
            return new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, bytes[0], bytes[1], bytes[2], bytes[3]};
        }
        return bytes;
    }

    protected ApiProxy.ApplicationException newAppException(SocketServicePb.RemoteSocketServiceError.ErrorCode code, String message) {
        return new ApiProxy.ApplicationException(code.getValue(), message);
    }

    protected ApiProxy.ApplicationException newAppExceptionAndClose(SocketServicePb.RemoteSocketServiceError.ErrorCode code, String message) {
        this.close();
        return this.newAppException(code, message);
    }

    protected ApiProxy.ApplicationException newNotImplementedException(String method) {
        return this.newAppException(SocketServicePb.RemoteSocketServiceError.ErrorCode.FAILURE, new StringBuilder(24 + String.valueOf(method).length()).append("socket ").append(method).append(": Not implemented").toString());
    }
}

