/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.enhancer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.OMFContext;
import org.datanucleus.enhancer.ClassEnhancer;
import org.datanucleus.enhancer.ClassField;
import org.datanucleus.enhancer.ClassMethod;
import org.datanucleus.enhancer.DataNucleusEnhancer;
import org.datanucleus.enhancer.EnhancerClassLoader;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.ClassPersistenceModifier;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractClassEnhancer
implements ClassEnhancer {
    protected static Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.enhancer.Localisation", (ClassLoader)ClassEnhancer.class.getClassLoader());
    protected final ClassLoaderResolver clr;
    protected final ClassMetaData cmd;
    public final String className;
    protected boolean update = false;
    protected List<ClassField> fieldsToAdd = new ArrayList<ClassField>();
    protected List<ClassMethod> methodsToAdd = new ArrayList<ClassMethod>();
    protected boolean initialised = false;

    public AbstractClassEnhancer(ClassMetaData cmd, ClassLoaderResolver clr) {
        this.clr = clr;
        this.cmd = cmd;
        this.className = cmd.getFullClassName();
    }

    protected void initialise() {
        if (this.initialised) {
            return;
        }
        this.initialiseFieldsList();
        this.initialiseMethodsList();
        this.initialised = true;
    }

    protected abstract void initialiseMethodsList();

    protected abstract void initialiseFieldsList();

    public List<ClassMethod> getMethodsList() {
        return this.methodsToAdd;
    }

    public List<ClassField> getFieldsList() {
        return this.fieldsToAdd;
    }

    @Override
    public ClassLoaderResolver getClassLoaderResolver() {
        return this.clr;
    }

    @Override
    public ClassMetaData getClassMetaData() {
        return this.cmd;
    }

    protected boolean requiresDetachable() {
        boolean hasPcsc;
        boolean isDetachable = this.cmd.isDetachable();
        boolean bl = hasPcsc = this.cmd.getPersistenceCapableSuperclass() != null;
        if (!hasPcsc && isDetachable) {
            return true;
        }
        return hasPcsc && !this.cmd.getSuperAbstractClassMetaData().isDetachable() && isDetachable;
    }

    public boolean isPersistenceCapable(String className) {
        if (className.equals(this.className) && this.cmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_AWARE) {
            return true;
        }
        OMFContext omfCtx = this.cmd.getMetaDataManager().getOMFContext();
        Class cls = this.clr.classForName(className, (ClassLoader)new EnhancerClassLoader());
        if (omfCtx.getApiAdapter().isPersistable(cls)) {
            return true;
        }
        AbstractClassMetaData cmd = this.cmd.getMetaDataManager().getMetaDataForClass(cls, this.clr);
        return cmd != null && cmd.getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_CAPABLE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(String directoryName) throws IOException {
        if (!this.update) {
            return;
        }
        File file = null;
        if (directoryName != null) {
            File baseDir = new File(directoryName);
            if (!baseDir.exists()) {
                baseDir.mkdirs();
            } else if (!baseDir.isDirectory()) {
                throw new RuntimeException("not directory " + directoryName);
            }
            String sep = System.getProperty("file.separator");
            String name = this.cmd.getFullClassName();
            name = name.replace('.', sep.charAt(0));
            name = name + ".class";
            file = new File(directoryName, name);
            file.getParentFile().mkdirs();
            DataNucleusEnhancer.LOGGER.info((Object)LOCALISER.msg("Enhancer.UpdateClass", (Object)file.getCanonicalPath()));
        } else {
            URL classURL = this.clr.getResource(this.className.replace('.', '/') + ".class", null);
            DataNucleusEnhancer.LOGGER.info((Object)LOCALISER.msg("Enhancer.UpdateClass", (Object)classURL));
            URL convertedPath = this.cmd.getMetaDataManager().getOMFContext().getPluginManager().resolveURLAsFileURL(classURL);
            if (!convertedPath.toString().equals(classURL.toString())) {
                DataNucleusEnhancer.LOGGER.info((Object)LOCALISER.msg("Enhancer.UpdateClass", (Object)classURL));
            }
            file = StringUtils.getFileForFilename((String)convertedPath.getFile());
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            out.write(this.getBytes());
        }
        finally {
            try {
                out.close();
                out = null;
            }
            catch (Exception ignore) {}
        }
    }
}

