/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.servlet;

import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import com.google.appengine.tools.development.ModulesController;
import com.google.apphosting.api.ApiProxy;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ModulesServlet
extends HttpServlet {
    private static final String AH_ADMIN_MODULES_PATH = "/_ah/admin/modules";
    private static final Logger logger = Logger.getLogger(ModulesServlet.class.getName());
    private static final String DEFAULT_MODULE_NAME = "defaultModuleName";
    private static final String APPLICATION_NAME = "applicationName";
    private static final String MODULES_STATE_INFO = "modulesStateInfo";
    private static final String ACTION_MODULE = "action:module";

    private ModulesController getModulesController() {
        return (ModulesController)ApiProxy.getCurrentEnvironment().getAttributes().get("com.google.appengine.dev.modules_controller");
    }

    private ImmutableList<String> getAllInstanceHostnames(String moduleName, String version) {
        ImmutableList.Builder hostnameListBuilder = ImmutableList.builder();
        for (int i = 0; i < this.getModulesController().getNumInstances(moduleName, version); ++i) {
            hostnameListBuilder.add((Object)this.getModulesController().getHostname(moduleName, version, i));
        }
        return hostnameListBuilder.build();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        req.setAttribute(APPLICATION_NAME, (Object)ApiProxy.getCurrentEnvironment().getAppId());
        final ModulesController modulesController = this.getModulesController();
        req.setAttribute(DEFAULT_MODULE_NAME, Iterables.getFirst((Iterable)modulesController.getModuleNames(), (Object)""));
        Iterable modulesMap = Iterables.transform((Iterable)modulesController.getModuleNames(), (Function)new Function<String, Map<String, Object>>(){

            public Map<String, Object> apply(String moduleName) {
                String version = modulesController.getDefaultVersion(moduleName);
                ImmutableMap.Builder mapBuilder = ImmutableMap.builder().put((Object)"name", (Object)moduleName).put((Object)"state", (Object)modulesController.getModuleState(moduleName).toString()).put((Object)"version", (Object)version).put((Object)"hostname", (Object)modulesController.getHostname(moduleName, version, -1)).put((Object)"type", (Object)modulesController.getScalingType(moduleName));
                if (modulesController.getScalingType(moduleName).startsWith("Manual")) {
                    mapBuilder.put((Object)"instances", (Object)ModulesServlet.this.getAllInstanceHostnames(moduleName, version));
                }
                return mapBuilder.build();
            }
        });
        req.setAttribute(MODULES_STATE_INFO, (Object)ImmutableList.copyOf((Iterable)modulesMap));
        try {
            this.getServletContext().getRequestDispatcher("/_ah/adminConsole?subsection=modules").forward((ServletRequest)req, (ServletResponse)resp);
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        final String moduleName = req.getParameter("moduleName");
        final String moduleVersion = req.getParameter("moduleVersion");
        final String action = req.getParameter(ACTION_MODULE);
        if (action != null && moduleName != null && moduleVersion != null) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        if (action.equals("Stop")) {
                            ModulesServlet.this.getModulesController().stopModule(moduleName, moduleVersion);
                        } else if (action.equals("Start")) {
                            ModulesServlet.this.getModulesController().startModule(moduleName, moduleVersion);
                        }
                    }
                    catch (Exception e) {
                        String string = action;
                        String string2 = moduleName;
                        logger.logp(Level.SEVERE, "com.google.apphosting.utils.servlet.ModulesServlet$2", "run", new StringBuilder(41 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Got error when performing a ").append(string).append(" of module : ").append(string2).toString());
                    }
                    return null;
                }
            });
        } else {
            logger.logp(Level.SEVERE, "com.google.apphosting.utils.servlet.ModulesServlet", "doPost", new StringBuilder(155 + String.valueOf(moduleName).length() + String.valueOf(moduleVersion).length() + String.valueOf(action).length()).append("The post method against the modules servlet was called without all of the expected post parameters, we got [moduleName = ").append(moduleName).append(", moduleVersion = ").append(moduleVersion).append(", and action = ").append(action).append("]").toString());
        }
        resp.sendRedirect(AH_ADMIN_MODULES_PATH);
    }
}

