/**********************************************************************
Copyright (c) 2010 Andy Jefferson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
   ...
**********************************************************************/
package org.datanucleus.api.jdo.query;

import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.typesafe.CharacterExpression;
import org.datanucleus.query.typesafe.PersistableExpression;

/**
 * Implementation of a CharacterExpression
 */
public class CharacterExpressionImpl<T> extends ComparableExpressionImpl<Character> implements CharacterExpression
{
    public CharacterExpressionImpl(PersistableExpression parent, String name)
    {
        super(parent, name);
    }

    public CharacterExpressionImpl(Class<Character> cls, String name, ExpressionType type)
    {
        super(cls, name, type);
    }

    public CharacterExpressionImpl(Expression queryExpr)
    {
        super(queryExpr);
    }
}
