package javax.persistence.metamodel;

public interface Type<X>
{
    public static enum PersistenceType 
    {
        ENTITY, EMBEDDABLE, MAPPED_SUPERCLASS, BASIC
    }

    /**
     * Return the persistence type.
     * @return persistence type
     */
    PersistenceType getPersistenceType();

    /**
     * Return the represented Java type.
     * @return Java type
     */
    Class<X> getJavaType();
}