/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.datanucleus.query;

import com.google.appengine.api.datastore.Entity;
import com.google.appengine.datanucleus.Utils;
import com.google.appengine.datanucleus.query.AbstractIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class LazyResult<T>
implements Iterable<T> {
    private final Utils.Function<Entity, T> entityTransformer;
    private final Iterator<Entity> lazyEntityIterator;
    private final ArrayList<T> resolvedPojos = Utils.newArrayList(new Object[0]);
    private final List<Object> resultKeys;

    public LazyResult(Iterable<Entity> lazyEntities, Utils.Function<Entity, T> entityTransformer, boolean cacheKeys) {
        this.lazyEntityIterator = lazyEntities.iterator();
        this.entityTransformer = entityTransformer;
        this.resultKeys = cacheKeys ? new ArrayList() : null;
    }

    T get(int index) {
        if (index >= this.resolvedPojos.size() && this.lazyEntityIterator.hasNext()) {
            for (int i = this.resolvedPojos.size(); i <= index && this.lazyEntityIterator.hasNext(); ++i) {
                this.resolveNext();
            }
        }
        return this.resolvedPojos.get(index);
    }

    void resolveNext() {
        Entity entity = this.lazyEntityIterator.next();
        this.resolvedPojos.add(this.entityTransformer.apply(entity));
        if (this.resultKeys != null) {
            this.resultKeys.add(entity.getKey());
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this.listIterator();
    }

    public ListIterator<T> listIterator() {
        if (!this.lazyEntityIterator.hasNext()) {
            return this.resolvedPojos.listIterator();
        }
        return new LazyAbstractListIterator();
    }

    public int size() {
        this.resolveAll();
        return this.resolvedPojos.size();
    }

    void resolveAll() {
        while (this.lazyEntityIterator.hasNext()) {
            this.resolveNext();
        }
    }

    public List getEntityKeys() {
        return this.resultKeys;
    }

    final class LazyAbstractListIterator
    extends AbstractListIterator {
        private int curIndex;

        LazyAbstractListIterator() {
            this.curIndex = 0;
        }

        @Override
        protected T computeNext() {
            if (this.curIndex >= LazyResult.this.resolvedPojos.size()) {
                if (!LazyResult.this.lazyEntityIterator.hasNext()) {
                    this.endOfData();
                    return null;
                }
                LazyResult.this.resolveNext();
            }
            return LazyResult.this.resolvedPojos.get(this.curIndex++);
        }

        Iterator<?> getInnerIterator() {
            return LazyResult.this.lazyEntityIterator;
        }
    }

    private abstract class AbstractListIterator
    extends AbstractIterator<T>
    implements ListIterator<T> {
        private int curIndex = 0;
        private int maxIndex = 0;

        private AbstractListIterator() {
        }

        @Override
        public boolean hasPrevious() {
            return this.previousIndex() != -1;
        }

        @Override
        public T previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            Object result = LazyResult.this.resolvedPojos.get(this.previousIndex());
            --this.curIndex;
            return result;
        }

        @Override
        public int nextIndex() {
            return this.curIndex;
        }

        @Override
        public int previousIndex() {
            return this.curIndex - 1;
        }

        @Override
        public boolean hasNext() {
            return this.curIndex < this.maxIndex || super.hasNext();
        }

        @Override
        public T next() {
            if (this.curIndex < this.maxIndex) {
                return LazyResult.this.resolvedPojos.get(this.curIndex++);
            }
            Object result = super.next();
            this.maxIndex = ++this.curIndex;
            return result;
        }

        @Override
        public void set(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Object o) {
            throw new UnsupportedOperationException();
        }
    }
}

