/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import javax.jdo.spi.PersistenceCapable;
import org.datanucleus.ClassConstants;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.PersistableMapping;
import org.datanucleus.util.Localiser;

class AppIDObjectIdFieldManager
extends AbstractFieldManager
implements PersistenceCapable.ObjectIdFieldConsumer {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    private int[] params;
    private int nextParam;
    private ExecutionContext ec;
    private Object statement;
    private JavaTypeMapping[] javaTypeMappings;
    private int mappingNum = 0;

    public AppIDObjectIdFieldManager(int[] param, ExecutionContext ec, Object statement, JavaTypeMapping[] javaTypeMappings) {
        this.params = param;
        this.nextParam = 0;
        this.ec = ec;
        this.statement = statement;
        int numMappings = 0;
        for (int i = 0; i < javaTypeMappings.length; ++i) {
            if (javaTypeMappings[i] instanceof PersistableMapping) {
                numMappings += ((PersistableMapping)javaTypeMappings[i]).getJavaTypeMapping().length;
                continue;
            }
            ++numMappings;
        }
        this.javaTypeMappings = new JavaTypeMapping[numMappings];
        int mappingNum = 0;
        for (int i = 0; i < javaTypeMappings.length; ++i) {
            if (javaTypeMappings[i] instanceof PersistableMapping) {
                PersistableMapping m = (PersistableMapping)javaTypeMappings[i];
                JavaTypeMapping[] subMappings = m.javaTypeMappings;
                for (int j = 0; j < subMappings.length; ++j) {
                    this.javaTypeMappings[mappingNum++] = subMappings[j];
                }
                continue;
            }
            this.javaTypeMappings[mappingNum++] = javaTypeMappings[i];
        }
    }

    private int[] getParamsForField(JavaTypeMapping mapping) {
        if (this.javaTypeMappings.length == 1) {
            return this.params;
        }
        int numCols = mapping.getNumberOfDatastoreMappings();
        int[] fieldParams = new int[numCols];
        for (int i = 0; i < numCols; ++i) {
            fieldParams[i] = this.params[this.nextParam++];
        }
        return fieldParams;
    }

    public void storeBooleanField(int fieldNumber, boolean value) {
        JavaTypeMapping mapping = this.javaTypeMappings[this.mappingNum++];
        mapping.setBoolean(this.ec, this.statement, this.getParamsForField(mapping), value);
    }

    public void storeByteField(int fieldNumber, byte value) {
        JavaTypeMapping mapping = this.javaTypeMappings[this.mappingNum++];
        mapping.setByte(this.ec, this.statement, this.getParamsForField(mapping), value);
    }

    public void storeCharField(int fieldNumber, char value) {
        JavaTypeMapping mapping = this.javaTypeMappings[this.mappingNum++];
        mapping.setChar(this.ec, this.statement, this.getParamsForField(mapping), value);
    }

    public void storeDoubleField(int fieldNumber, double value) {
        JavaTypeMapping mapping = this.javaTypeMappings[this.mappingNum++];
        mapping.setDouble(this.ec, this.statement, this.getParamsForField(mapping), value);
    }

    public void storeFloatField(int fieldNumber, float value) {
        JavaTypeMapping mapping = this.javaTypeMappings[this.mappingNum++];
        mapping.setFloat(this.ec, this.statement, this.getParamsForField(mapping), value);
    }

    public void storeIntField(int fieldNumber, int value) {
        JavaTypeMapping mapping = this.javaTypeMappings[this.mappingNum++];
        mapping.setInt(this.ec, this.statement, this.getParamsForField(mapping), value);
    }

    public void storeLongField(int fieldNumber, long value) {
        JavaTypeMapping mapping = this.javaTypeMappings[this.mappingNum++];
        mapping.setLong(this.ec, this.statement, this.getParamsForField(mapping), value);
    }

    public void storeShortField(int fieldNumber, short value) {
        JavaTypeMapping mapping = this.javaTypeMappings[this.mappingNum++];
        mapping.setShort(this.ec, this.statement, this.getParamsForField(mapping), value);
    }

    public void storeStringField(int fieldNumber, String value) {
        JavaTypeMapping mapping = this.javaTypeMappings[this.mappingNum++];
        mapping.setString(this.ec, this.statement, this.getParamsForField(mapping), value);
    }

    public void storeObjectField(int fieldNumber, Object value) {
        if (this.ec.getApiAdapter().isPersistable(value)) {
            PersistenceCapable pc = (PersistenceCapable)value;
            pc.jdoCopyKeyFieldsFromObjectId((PersistenceCapable.ObjectIdFieldConsumer)this, pc.jdoGetObjectId());
        } else {
            JavaTypeMapping mapping = this.javaTypeMappings[this.mappingNum++];
            mapping.setObject(this.ec, this.statement, this.getParamsForField(mapping), value);
        }
    }
}

