/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import java.io.Serializable;
import org.datanucleus.util.StringUtils;

public class NullValue
implements Serializable {
    public static final NullValue EXCEPTION = new NullValue(1);
    public static final NullValue DEFAULT = new NullValue(2);
    public static final NullValue NONE = new NullValue(3);
    private final int typeId;

    private NullValue(int i) {
        this.typeId = i;
    }

    public int hashCode() {
        return this.typeId;
    }

    public boolean equals(Object o) {
        if (o instanceof NullValue) {
            return ((NullValue)o).typeId == this.typeId;
        }
        return false;
    }

    public String toString() {
        switch (this.typeId) {
            case 1: {
                return "exception";
            }
            case 2: {
                return "default";
            }
            case 3: {
                return "none";
            }
        }
        return "";
    }

    public int getType() {
        return this.typeId;
    }

    public static NullValue getNullValue(String value) {
        if (StringUtils.isWhitespace(value)) {
            return NONE;
        }
        if (DEFAULT.toString().equals(value)) {
            return DEFAULT;
        }
        if (EXCEPTION.toString().equals(value)) {
            return EXCEPTION;
        }
        if (NONE.toString().equals(value)) {
            return NONE;
        }
        return NONE;
    }
}

