/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.NucleusContext;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NoPersistenceInformationException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.ClassPersistenceModifier;
import org.datanucleus.metadata.FetchPlanMetaData;
import org.datanucleus.metadata.FileMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.InterfaceMetaData;
import org.datanucleus.metadata.InvalidMetaDataException;
import org.datanucleus.metadata.MetaDataListener;
import org.datanucleus.metadata.MetaDataMerger;
import org.datanucleus.metadata.MetaDataScanner;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.MetadataFileType;
import org.datanucleus.metadata.PackageMetaData;
import org.datanucleus.metadata.PersistenceFileMetaData;
import org.datanucleus.metadata.PersistenceUnitMetaData;
import org.datanucleus.metadata.QueryMetaData;
import org.datanucleus.metadata.QueryResultMetaData;
import org.datanucleus.metadata.SequenceMetaData;
import org.datanucleus.metadata.StoredProcQueryMetaData;
import org.datanucleus.metadata.TableGeneratorMetaData;
import org.datanucleus.metadata.annotations.AnnotationManager;
import org.datanucleus.metadata.annotations.AnnotationManagerImpl;
import org.datanucleus.metadata.xml.MetaDataParser;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.MultiMap;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MetaDataManager
implements Serializable {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    protected final NucleusContext nucleusContext;
    protected final AnnotationManager annotationManager;
    protected MetaDataParser metaDataParser = null;
    protected boolean validateXML = true;
    protected Collection<String> classesWithoutPersistenceInfo = new HashSet<String>();
    protected Map<String, FileMetaData> fileMetaDataByURLString = new HashMap<String, FileMetaData>();
    protected Map<String, AbstractClassMetaData> classMetaDataByClass = new HashMap<String, AbstractClassMetaData>();
    protected Map<String, AbstractClassMetaData> classMetaDataByEntityName = new HashMap<String, AbstractClassMetaData>();
    protected Map<String, AbstractClassMetaData> classMetaDataByDiscriminatorName = new HashMap<String, AbstractClassMetaData>();
    protected Map<String, Set<String>> directSubclassesByClass = new HashMap<String, Set<String>>();
    protected Map<String, QueryMetaData> queryMetaDataByName = null;
    protected Map<String, StoredProcQueryMetaData> storedProcQueryMetaDataByName = null;
    protected Map<String, FetchPlanMetaData> fetchPlanMetaDataByName = null;
    protected Map<String, SequenceMetaData> sequenceMetaDataByPackageSequence = null;
    protected Map<String, TableGeneratorMetaData> tableGeneratorMetaDataByPackageSequence = null;
    protected Map<String, QueryResultMetaData> queryResultMetaDataByName = null;
    protected MultiMap classMetaDataByAppIdClassName = new MultiMap();
    protected Set<MetaDataListener> listeners = null;
    protected int userMetaDataNumber = 0;
    protected boolean allowMetaDataLoad = true;
    protected boolean allowXML = true;
    protected boolean allowAnnotations = true;
    protected boolean allowORM = true;
    protected ArrayList<FileMetaData> utilisedFileMetaData = new ArrayList();
    protected List<AbstractClassMetaData> loadedMetaData = null;

    public MetaDataManager(NucleusContext ctx) {
        this.nucleusContext = ctx;
        this.validateXML = this.nucleusContext.getPersistenceConfiguration().getBooleanProperty("datanucleus.metadata.validate");
        this.allowXML = this.nucleusContext.getPersistenceConfiguration().getBooleanProperty("datanucleus.metadata.allowXML");
        this.allowAnnotations = this.nucleusContext.getPersistenceConfiguration().getBooleanProperty("datanucleus.metadata.allowAnnotations");
        this.annotationManager = new AnnotationManagerImpl(this);
        Set<String> supportedClasses = this.nucleusContext.getTypeManager().getSupportedSecondClassTypes();
        Iterator<String> iter = supportedClasses.iterator();
        while (iter.hasNext()) {
            this.classesWithoutPersistenceInfo.add(iter.next());
        }
        if (this.nucleusContext.isStoreManagerInitialised()) {
            Boolean configOrm;
            this.allowORM = this.nucleusContext.getStoreManager().getSupportedOptions().contains("ORM");
            if (this.allowORM && (configOrm = this.nucleusContext.getPersistenceConfiguration().getBooleanObjectProperty("datanucleus.metadata.supportORM")) != null && !configOrm.booleanValue()) {
                this.allowORM = false;
            }
        }
    }

    public void close() {
        this.classMetaDataByClass.clear();
        this.classMetaDataByClass = null;
        this.fileMetaDataByURLString.clear();
        this.fileMetaDataByURLString = null;
        this.classesWithoutPersistenceInfo.clear();
        this.classesWithoutPersistenceInfo = null;
        this.directSubclassesByClass.clear();
        this.directSubclassesByClass = null;
        if (this.classMetaDataByEntityName != null) {
            this.classMetaDataByEntityName.clear();
            this.classMetaDataByEntityName = null;
        }
        if (this.classMetaDataByDiscriminatorName != null) {
            this.classMetaDataByDiscriminatorName.clear();
            this.classMetaDataByDiscriminatorName = null;
        }
        if (this.queryMetaDataByName != null) {
            this.queryMetaDataByName.clear();
            this.queryMetaDataByName = null;
        }
        if (this.storedProcQueryMetaDataByName != null) {
            this.storedProcQueryMetaDataByName.clear();
            this.storedProcQueryMetaDataByName = null;
        }
        if (this.fetchPlanMetaDataByName != null) {
            this.fetchPlanMetaDataByName.clear();
            this.fetchPlanMetaDataByName = null;
        }
        if (this.sequenceMetaDataByPackageSequence != null) {
            this.sequenceMetaDataByPackageSequence.clear();
            this.sequenceMetaDataByPackageSequence = null;
        }
        if (this.tableGeneratorMetaDataByPackageSequence != null) {
            this.tableGeneratorMetaDataByPackageSequence.clear();
            this.tableGeneratorMetaDataByPackageSequence = null;
        }
        if (this.queryResultMetaDataByName != null) {
            this.queryResultMetaDataByName.clear();
            this.queryResultMetaDataByName = null;
        }
        if (this.classMetaDataByAppIdClassName != null) {
            this.classMetaDataByAppIdClassName.clear();
            this.classMetaDataByAppIdClassName = null;
        }
        if (this.listeners != null) {
            this.listeners.clear();
            this.listeners = null;
        }
    }

    public void registerListener(MetaDataListener listener) {
        if (this.listeners == null) {
            this.listeners = new HashSet<MetaDataListener>();
        }
        this.listeners.add(listener);
    }

    public void deregisterListener(MetaDataListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
        if (this.listeners.size() == 0) {
            this.listeners = null;
        }
    }

    public void setAllowMetaDataLoad(boolean allow) {
        this.allowMetaDataLoad = allow;
    }

    public boolean getAllowMetaDataLoad() {
        return this.allowMetaDataLoad;
    }

    public boolean isAllowXML() {
        return this.allowXML;
    }

    public void setAllowXML(boolean allow) {
        this.allowXML = allow;
    }

    public boolean isAllowAnnotations() {
        return this.allowAnnotations;
    }

    public void setAllowAnnotations(boolean allow) {
        this.allowAnnotations = allow;
    }

    public boolean supportsORM() {
        return this.allowORM;
    }

    public boolean isEnhancing() {
        return this.getNucleusContext().getType() == NucleusContext.ContextType.ENHANCEMENT;
    }

    public void setValidate(boolean validate) {
        this.validateXML = validate;
    }

    public NucleusContext getNucleusContext() {
        return this.nucleusContext;
    }

    public ApiAdapter getApiAdapter() {
        return this.nucleusContext.getApiAdapter();
    }

    public AnnotationManager getAnnotationManager() {
        return this.annotationManager;
    }

    public FileMetaData[] loadMetadataFiles(String[] metadataFiles, ClassLoader loader) {
        ClassLoaderResolver clr;
        Collection<FileMetaData> fileMetaData;
        if (!this.allowMetaDataLoad) {
            return null;
        }
        if (NucleusLogger.METADATA.isDebugEnabled()) {
            NucleusLogger.METADATA.debug(LOCALISER.msg("044005", (Object)StringUtils.objectArrayToString(metadataFiles)));
        }
        boolean originatingLoadCall = false;
        if (this.loadedMetaData == null) {
            originatingLoadCall = true;
            this.loadedMetaData = new ArrayList<AbstractClassMetaData>();
        }
        if ((fileMetaData = this.loadFiles(metadataFiles, clr = this.nucleusContext.getClassLoaderResolver(loader))).size() > 0) {
            this.initialiseFileMetaDataForUse(fileMetaData, clr);
        }
        if (NucleusLogger.METADATA.isDebugEnabled()) {
            NucleusLogger.METADATA.debug(LOCALISER.msg("044010"));
        }
        if (originatingLoadCall) {
            this.processListenerLoadingCall();
        }
        return fileMetaData.toArray(new FileMetaData[fileMetaData.size()]);
    }

    public FileMetaData[] loadClasses(String[] classNames, ClassLoader loader) {
        if (!this.allowMetaDataLoad) {
            return null;
        }
        if (NucleusLogger.METADATA.isDebugEnabled()) {
            NucleusLogger.METADATA.debug(LOCALISER.msg("044006", (Object)StringUtils.objectArrayToString(classNames)));
        }
        boolean originatingLoadCall = false;
        if (this.loadedMetaData == null) {
            originatingLoadCall = true;
            this.loadedMetaData = new ArrayList<AbstractClassMetaData>();
        }
        ClassLoaderResolver clr = this.nucleusContext.getClassLoaderResolver(loader);
        ArrayList<FileMetaData> fileMetaData = new ArrayList<FileMetaData>();
        HashSet<Exception> exceptions = new HashSet<Exception>();
        for (int i = 0; i < classNames.length; ++i) {
            try {
                Class cls = clr.classForName(classNames[i]);
                AbstractClassMetaData cmd = this.classMetaDataByClass.get(classNames[i]);
                if (cmd == null) {
                    FileMetaData filemd = this.loadAnnotationsForClass(cls, clr, true, false);
                    if (filemd != null) {
                        this.registerFile("annotations:" + classNames[i], filemd, clr);
                        fileMetaData.add(filemd);
                        continue;
                    }
                    cmd = this.getMetaDataForClass(cls, clr);
                    if (cmd == null) {
                        NucleusLogger.METADATA.debug(LOCALISER.msg("044017", (Object)classNames[i]));
                        continue;
                    }
                    fileMetaData.add(cmd.getPackageMetaData().getFileMetaData());
                    continue;
                }
                fileMetaData.add(cmd.getPackageMetaData().getFileMetaData());
                continue;
            }
            catch (ClassNotResolvedException e) {
                NucleusLogger.METADATA.error(StringUtils.getStringFromStackTrace(e));
                continue;
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        if (exceptions.size() > 0) {
            throw new NucleusUserException(LOCALISER.msg("044016"), exceptions.toArray(new Throwable[exceptions.size()]), null);
        }
        if (fileMetaData.size() > 0) {
            this.initialiseFileMetaDataForUse(fileMetaData, clr);
        }
        if (NucleusLogger.METADATA.isDebugEnabled()) {
            NucleusLogger.METADATA.debug(LOCALISER.msg("044010"));
        }
        if (originatingLoadCall) {
            this.processListenerLoadingCall();
        }
        return fileMetaData.toArray(new FileMetaData[fileMetaData.size()]);
    }

    public FileMetaData[] loadJar(String jarFileName, ClassLoader loader) {
        FileMetaData filemd;
        String[] jarClassNames;
        String[] packageJdoFiles;
        if (!this.allowMetaDataLoad) {
            return null;
        }
        if (NucleusLogger.METADATA.isDebugEnabled()) {
            NucleusLogger.METADATA.debug(LOCALISER.msg("044009", (Object)jarFileName));
        }
        boolean originatingLoadCall = false;
        if (this.loadedMetaData == null) {
            originatingLoadCall = true;
            this.loadedMetaData = new ArrayList<AbstractClassMetaData>();
        }
        ClassLoaderResolver clr = this.nucleusContext.getClassLoaderResolver(loader);
        ArrayList<FileMetaData> fileMetaData = new ArrayList<FileMetaData>();
        HashSet<String> mappingFiles = new HashSet<String>();
        if (this.allowXML && (packageJdoFiles = ClassUtils.getPackageJdoFilesForJarFile(jarFileName)) != null) {
            for (int i = 0; i < packageJdoFiles.length; ++i) {
                mappingFiles.add(packageJdoFiles[i]);
            }
        }
        HashSet<String> classNames = new HashSet<String>();
        if (this.allowAnnotations && (jarClassNames = ClassUtils.getClassNamesForJarFile(jarFileName)) != null) {
            for (int i = 0; i < jarClassNames.length; ++i) {
                classNames.add(jarClassNames[i]);
            }
        }
        HashSet<Exception> exceptions = new HashSet<Exception>();
        if (this.allowXML && mappingFiles != null && mappingFiles.size() > 0) {
            for (String mappingFileName : mappingFiles) {
                try {
                    Enumeration<URL> files = clr.getResources(mappingFileName, Thread.currentThread().getContextClassLoader());
                    while (files.hasMoreElements()) {
                        URL url = files.nextElement();
                        if (url == null || this.fileMetaDataByURLString.get(url.toString()) != null || (filemd = this.parseFile(url)) == null) continue;
                        this.registerFile(url.toString(), filemd, clr);
                        fileMetaData.add(filemd);
                    }
                }
                catch (InvalidMetaDataException imde) {
                    NucleusLogger.METADATA.error(StringUtils.getStringFromStackTrace(imde));
                    exceptions.add(imde);
                }
                catch (IOException ioe) {
                    NucleusLogger.METADATA.error(LOCALISER.msg("044027", (Object)jarFileName, (Object)mappingFileName, (Object)ioe.getMessage()), ioe);
                }
            }
        }
        if (this.allowAnnotations && classNames != null && classNames.size() > 0) {
            for (String className : classNames) {
                AbstractClassMetaData cmd = this.classMetaDataByClass.get(className);
                if (cmd != null) continue;
                try {
                    Class cls = clr.classForName(className);
                    filemd = this.loadAnnotationsForClass(cls, clr, true, false);
                    if (filemd == null) continue;
                    fileMetaData.add(filemd);
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
            }
        }
        if (exceptions.size() > 0) {
            throw new NucleusUserException(LOCALISER.msg("044024", (Object)jarFileName), exceptions.toArray(new Throwable[exceptions.size()]));
        }
        if (fileMetaData.size() > 0) {
            this.initialiseFileMetaDataForUse(fileMetaData, clr);
        }
        if (NucleusLogger.METADATA.isDebugEnabled()) {
            NucleusLogger.METADATA.debug(LOCALISER.msg("044010"));
        }
        if (originatingLoadCall) {
            this.processListenerLoadingCall();
        }
        return fileMetaData.toArray(new FileMetaData[fileMetaData.size()]);
    }

    public FileMetaData[] loadPersistenceUnit(PersistenceUnitMetaData pumd, ClassLoader loader) {
        if (!this.allowMetaDataLoad) {
            return null;
        }
        if (NucleusLogger.METADATA.isDebugEnabled()) {
            NucleusLogger.METADATA.debug(LOCALISER.msg("044007", (Object)pumd.getName()));
        }
        boolean originatingLoadCall = false;
        if (this.loadedMetaData == null) {
            originatingLoadCall = true;
            this.loadedMetaData = new ArrayList<AbstractClassMetaData>();
        }
        ClassLoaderResolver clr = this.nucleusContext.getClassLoaderResolver(loader);
        HashSet<Exception> exceptions = new HashSet<Exception>();
        ArrayList<FileMetaData> fileMetaData = new ArrayList<FileMetaData>();
        HashSet<String> mappingFiles = new HashSet<String>();
        if (this.allowXML) {
            HashSet jarFileNames;
            if (this.nucleusContext.getApiName().equalsIgnoreCase("JPA")) {
                mappingFiles.add("META-INF/orm.xml");
            }
            if (pumd.getMappingFiles() != null) {
                mappingFiles.addAll(pumd.getMappingFiles());
            }
            if (this.nucleusContext.getApiName().equalsIgnoreCase("JDO") && (jarFileNames = pumd.getJarFiles()) != null) {
                for (Object jarFile : jarFileNames) {
                    int i;
                    String[] packageJdoFiles;
                    if (jarFile instanceof String) {
                        packageJdoFiles = ClassUtils.getPackageJdoFilesForJarFile((String)jarFile);
                        if (packageJdoFiles == null) continue;
                        for (i = 0; i < packageJdoFiles.length; ++i) {
                            mappingFiles.add(packageJdoFiles[i]);
                        }
                        continue;
                    }
                    if (!(jarFile instanceof URL) || (packageJdoFiles = ClassUtils.getPackageJdoFilesForJarFile((URL)jarFile)) == null) continue;
                    for (i = 0; i < packageJdoFiles.length; ++i) {
                        mappingFiles.add(packageJdoFiles[i]);
                    }
                }
            }
        }
        HashSet<String> classNames = new HashSet<String>();
        if (this.allowAnnotations) {
            HashSet jarFileNames;
            if (pumd.getClassNames() != null) {
                classNames.addAll(pumd.getClassNames());
            }
            if (this.getNucleusContext().getType() == NucleusContext.ContextType.PERSISTENCE && (jarFileNames = pumd.getJarFiles()) != null) {
                for (Object jarFile : jarFileNames) {
                    int i;
                    String[] jarClassNames;
                    if (jarFile instanceof String) {
                        jarClassNames = ClassUtils.getClassNamesForJarFile((String)jarFile);
                        if (jarClassNames == null) continue;
                        for (i = 0; i < jarClassNames.length; ++i) {
                            classNames.add(jarClassNames[i]);
                        }
                        continue;
                    }
                    if (!(jarFile instanceof URL) || (jarClassNames = ClassUtils.getClassNamesForJarFile((URL)jarFile)) == null) continue;
                    for (i = 0; i < jarClassNames.length; ++i) {
                        classNames.add(jarClassNames[i]);
                    }
                }
            }
            if (!pumd.getExcludeUnlistedClasses()) {
                MetaDataScanner scanner = this.getScanner(clr);
                if (scanner != null) {
                    Set<String> scannedClassNames = scanner.scanForPersistableClasses(pumd);
                    if (scannedClassNames != null) {
                        classNames.addAll(scannedClassNames);
                    }
                } else {
                    try {
                        File rootDir;
                        String[] scannedClassNames;
                        if (pumd.getRootURI() != null && pumd.getRootURI().getScheme().equals("file") && (scannedClassNames = ClassUtils.getClassNamesForDirectoryAndBelow(rootDir = new File(pumd.getRootURI()))) != null) {
                            for (int i = 0; i < scannedClassNames.length; ++i) {
                                NucleusLogger.METADATA.debug(LOCALISER.msg("044026", (Object)scannedClassNames[i], (Object)pumd.getName()));
                                classNames.add(scannedClassNames[i]);
                            }
                        }
                    }
                    catch (IllegalArgumentException iae) {
                        NucleusLogger.METADATA.debug("Ignoring scan of classes for this persistence-unit since the URI root is " + pumd.getRootURI() + " and is not hierarchical");
                    }
                }
            }
        }
        if (this.allowXML && mappingFiles != null && mappingFiles.size() > 0) {
            for (String mappingFileName : mappingFiles) {
                try {
                    Enumeration<URL> files = clr.getResources(mappingFileName, Thread.currentThread().getContextClassLoader());
                    if (!files.hasMoreElements()) {
                        NucleusLogger.METADATA.debug("Not found any metadata mapping files for resource name " + mappingFileName + " in CLASSPATH");
                        continue;
                    }
                    while (files.hasMoreElements()) {
                        FileMetaData filemd;
                        URL url = files.nextElement();
                        if (url == null || this.fileMetaDataByURLString.get(url.toString()) != null || (filemd = this.parseFile(url)) == null) continue;
                        this.registerFile(url.toString(), filemd, clr);
                        fileMetaData.add(filemd);
                    }
                }
                catch (InvalidMetaDataException imde) {
                    NucleusLogger.METADATA.error(StringUtils.getStringFromStackTrace(imde));
                    exceptions.add(imde);
                }
                catch (IOException ioe) {
                    NucleusLogger.METADATA.error(LOCALISER.msg("044027", (Object)pumd.getName(), (Object)mappingFileName, (Object)ioe.getMessage()), ioe);
                }
            }
        }
        if (this.allowAnnotations && classNames != null && classNames.size() > 0) {
            for (String className : classNames) {
                AbstractClassMetaData cmd = this.classMetaDataByClass.get(className);
                if (cmd != null) continue;
                try {
                    Class cls = clr.classForName(className);
                    FileMetaData filemd = this.loadAnnotationsForClass(cls, clr, true, false);
                    if (filemd != null) {
                        fileMetaData.add(filemd);
                        continue;
                    }
                    NucleusLogger.METADATA.warn("Class " + className + " was specified in persistence-unit " + pumd.getName() + " but not annotated, so ignoring");
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
            }
        }
        if (exceptions.size() > 0) {
            throw new NucleusUserException(LOCALISER.msg("044023", (Object)pumd.getName()), exceptions.toArray(new Throwable[exceptions.size()]));
        }
        if (fileMetaData.size() > 0) {
            this.initialiseFileMetaDataForUse(fileMetaData, clr);
        }
        if (NucleusLogger.METADATA.isDebugEnabled()) {
            NucleusLogger.METADATA.debug(LOCALISER.msg("044010"));
        }
        if (originatingLoadCall) {
            this.processListenerLoadingCall();
        }
        return fileMetaData.toArray(new FileMetaData[fileMetaData.size()]);
    }

    protected MetaDataScanner getScanner(ClassLoaderResolver clr) {
        Object so = this.nucleusContext.getPersistenceConfiguration().getProperty("datanucleus.metadata.scanner");
        if (so == null) {
            return null;
        }
        if (so instanceof MetaDataScanner) {
            return (MetaDataScanner)so;
        }
        if (so instanceof String) {
            try {
                Class clazz = clr.classForName((String)so);
                return (MetaDataScanner)clazz.newInstance();
            }
            catch (Throwable t) {
                throw new NucleusUserException(LOCALISER.msg("044012", so), t);
            }
        }
        if (NucleusLogger.METADATA.isDebugEnabled()) {
            NucleusLogger.METADATA.debug(LOCALISER.msg("044011", so));
        }
        return null;
    }

    public void loadUserMetaData(FileMetaData fileMetaData, ClassLoader loader) {
        if (!this.allowMetaDataLoad) {
            return;
        }
        if (fileMetaData == null) {
            return;
        }
        if (NucleusLogger.METADATA.isDebugEnabled()) {
            NucleusLogger.METADATA.debug(LOCALISER.msg("044008"));
        }
        boolean originatingLoadCall = false;
        if (this.loadedMetaData == null) {
            originatingLoadCall = true;
            this.loadedMetaData = new ArrayList<AbstractClassMetaData>();
        }
        ClassLoaderResolver clr = this.nucleusContext.getClassLoaderResolver(loader);
        fileMetaData.setFilename("User_Metadata_" + this.userMetaDataNumber);
        ++this.userMetaDataNumber;
        this.registerFile(fileMetaData.getFilename(), fileMetaData, clr);
        ArrayList<FileMetaData> filemds = new ArrayList<FileMetaData>();
        filemds.add(fileMetaData);
        this.initialiseFileMetaDataForUse(filemds, clr);
        if (NucleusLogger.METADATA.isDebugEnabled()) {
            NucleusLogger.METADATA.debug(LOCALISER.msg("044010"));
        }
        if (originatingLoadCall) {
            this.processListenerLoadingCall();
        }
    }

    protected void initialiseFileMetaDataForUse(Collection fileMetaData, ClassLoaderResolver clr) {
        HashSet<Exception> exceptions = new HashSet<Exception>();
        if (NucleusLogger.METADATA.isDebugEnabled()) {
            NucleusLogger.METADATA.debug(LOCALISER.msg("044018"));
        }
        for (FileMetaData filemd : fileMetaData) {
            if (filemd.isInitialised()) continue;
            this.populateFileMetaData(filemd, clr, null);
        }
        if (NucleusLogger.METADATA.isDebugEnabled()) {
            NucleusLogger.METADATA.debug(LOCALISER.msg("044019"));
        }
        for (FileMetaData filemd : fileMetaData) {
            if (filemd.isInitialised()) continue;
            try {
                this.initialiseFileMetaData(filemd, clr, null);
            }
            catch (Exception e) {
                NucleusLogger.METADATA.error(StringUtils.getStringFromStackTrace(e));
                exceptions.add(e);
            }
        }
        if (exceptions.size() > 0) {
            throw new NucleusUserException(LOCALISER.msg("044020"), exceptions.toArray(new Throwable[exceptions.size()]));
        }
    }

    public Collection<FileMetaData> loadFiles(String[] metadataFiles, ClassLoaderResolver clr) {
        ArrayList<FileMetaData> fileMetaData = new ArrayList<FileMetaData>();
        HashSet<Exception> exceptions = new HashSet<Exception>();
        if (this.allowXML) {
            for (int i = 0; i < metadataFiles.length; ++i) {
                try {
                    URL fileURL = null;
                    try {
                        File file = new File(metadataFiles[i]);
                        fileURL = file.toURI().toURL();
                        if (!file.exists()) {
                            fileURL = clr.getResource(metadataFiles[i], null);
                        }
                    }
                    catch (Exception mue) {
                        fileURL = clr.getResource(metadataFiles[i], null);
                    }
                    if (fileURL == null) {
                        NucleusLogger.METADATA.warn("Metadata file " + metadataFiles[i] + " not found in CLASSPATH");
                        continue;
                    }
                    FileMetaData filemd = this.fileMetaDataByURLString.get(fileURL.toString());
                    if (fileURL != null && filemd == null) {
                        filemd = this.parseFile(fileURL);
                        if (filemd != null) {
                            this.registerFile(fileURL.toString(), filemd, clr);
                            fileMetaData.add(filemd);
                            continue;
                        }
                        throw new NucleusUserException(LOCALISER.msg("044015", (Object)metadataFiles[i]));
                    }
                    fileMetaData.add(filemd);
                    continue;
                }
                catch (Exception e) {
                    exceptions.add(e);
                    e.printStackTrace();
                }
            }
        }
        if (exceptions.size() > 0) {
            throw new NucleusUserException(LOCALISER.msg("044016"), exceptions.toArray(new Throwable[exceptions.size()]), null);
        }
        return fileMetaData;
    }

    public boolean isClassPersistable(String className) {
        AbstractClassMetaData acmd = this.readMetaDataForClass(className);
        if (acmd == null) {
            return false;
        }
        return acmd.getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_CAPABLE;
    }

    public FileMetaData[] getFileMetaData() {
        Collection<FileMetaData> filemds = this.fileMetaDataByURLString.values();
        return filemds.toArray(new FileMetaData[filemds.size()]);
    }

    public Collection<String> getClassesWithMetaData() {
        return Collections.unmodifiableCollection(this.classMetaDataByClass.keySet());
    }

    public boolean hasMetaDataForClass(String className) {
        if (className == null) {
            return false;
        }
        if (this.isClassWithoutPersistenceInfo(className)) {
            return false;
        }
        return this.classMetaDataByClass.get(className) != null;
    }

    protected boolean isClassWithoutPersistenceInfo(String className) {
        if (className == null) {
            return true;
        }
        if (className.startsWith("java.") || className.startsWith("javax.")) {
            return true;
        }
        return this.classesWithoutPersistenceInfo.contains(className);
    }

    public Collection<AbstractClassMetaData> getClassMetaDataWithApplicationId(String objectIdClassName) {
        return (Collection)this.classMetaDataByAppIdClassName.get(objectIdClassName);
    }

    public synchronized AbstractClassMetaData getMetaDataForClass(String className, ClassLoaderResolver clr) {
        if (className == null) {
            return null;
        }
        if (this.isClassWithoutPersistenceInfo(className)) {
            return null;
        }
        AbstractClassMetaData cmd = this.classMetaDataByClass.get(className);
        if (cmd != null && cmd.isPopulated() && cmd.isInitialised() && cmd instanceof ClassMetaData) {
            return cmd;
        }
        Class c = null;
        try {
            c = clr == null ? Class.forName(className) : clr.classForName(className, null, false);
        }
        catch (ClassNotFoundException cnfe) {
        }
        catch (ClassNotResolvedException cnre) {
            // empty catch block
        }
        if (c == null) {
            if (cmd != null && cmd.isPopulated() && cmd.isInitialised()) {
                return cmd;
            }
            return null;
        }
        return this.getMetaDataForClass(c, clr);
    }

    public synchronized AbstractClassMetaData getMetaDataForClass(Class c, ClassLoaderResolver clr) {
        if (c == null) {
            return null;
        }
        if (this.isClassWithoutPersistenceInfo(c.getName())) {
            return null;
        }
        boolean originatingLoadCall = false;
        if (this.loadedMetaData == null) {
            originatingLoadCall = true;
            this.loadedMetaData = new ArrayList<AbstractClassMetaData>();
        }
        AbstractClassMetaData cmd = null;
        cmd = c.isInterface() ? this.getClassMetaDataForImplementationOfPersistentInterface(c.getName()) : this.getMetaDataForClassInternal(c, clr);
        if (cmd != null) {
            this.populateAbstractClassMetaData(cmd, clr, c.getClassLoader());
            this.initialiseAbstractClassMetaData(cmd, clr);
            if (this.utilisedFileMetaData.size() > 0) {
                ArrayList utilisedFileMetaData1 = (ArrayList)this.utilisedFileMetaData.clone();
                this.utilisedFileMetaData.clear();
                for (FileMetaData filemd : utilisedFileMetaData1) {
                    this.initialiseFileMetaData(filemd, clr, c.getClassLoader());
                }
                if (this.utilisedFileMetaData.size() > 0) {
                    ArrayList utilisedFileMetaData2 = (ArrayList)this.utilisedFileMetaData.clone();
                    this.utilisedFileMetaData.clear();
                    for (FileMetaData filemd : utilisedFileMetaData2) {
                        this.initialiseFileMetaData(filemd, clr, c.getClassLoader());
                    }
                }
            }
        } else if (!c.isInterface()) {
            this.classesWithoutPersistenceInfo.add(c.getName());
        }
        this.utilisedFileMetaData.clear();
        if (originatingLoadCall) {
            this.processListenerLoadingCall();
        }
        return cmd;
    }

    protected void processListenerLoadingCall() {
        if (!this.loadedMetaData.isEmpty()) {
            for (AbstractClassMetaData acmd : new ArrayList<AbstractClassMetaData>(this.loadedMetaData)) {
                for (MetaDataListener listener : this.listeners) {
                    listener.loaded(acmd);
                }
            }
        }
        this.loadedMetaData = null;
    }

    public synchronized AbstractClassMetaData getMetaDataForEntityName(String entityName) {
        return this.classMetaDataByEntityName.get(entityName);
    }

    public synchronized AbstractClassMetaData getMetaDataForDiscriminator(String discriminator) {
        return this.classMetaDataByDiscriminatorName.get(discriminator);
    }

    public AbstractClassMetaData readMetaDataForClass(String className) {
        return this.classMetaDataByClass.get(className);
    }

    public AbstractMemberMetaData readMetaDataForMember(String className, String memberName) {
        AbstractClassMetaData cmd = this.readMetaDataForClass(className);
        return cmd != null ? cmd.getMetaDataForMember(memberName) : null;
    }

    public abstract AbstractClassMetaData getMetaDataForClassInternal(Class var1, ClassLoaderResolver var2);

    protected void registerMetaDataForClass(String fullClassName, AbstractClassMetaData cmd) {
        this.classMetaDataByClass.put(fullClassName, cmd);
        this.directSubclassesByClass.clear();
    }

    public String[] getSubclassesForClass(String className, boolean includeDescendents) {
        HashSet subclassNames = new HashSet();
        this.provideSubclassesForClass(className, includeDescendents, subclassNames);
        if (subclassNames.size() > 0) {
            return subclassNames.toArray(new String[subclassNames.size()]);
        }
        return null;
    }

    private void provideSubclassesForClass(String className, boolean includeDescendents, Collection consumer) {
        Set directSubClasses = this.directSubclassesByClass.get(className);
        if (directSubClasses == null) {
            directSubClasses = this.computeDirectSubclassesForClass(className);
            this.directSubclassesByClass.put(className, directSubClasses);
        }
        consumer.addAll(directSubClasses);
        if (includeDescendents) {
            Iterator subClassNameIter = directSubClasses.iterator();
            while (subClassNameIter.hasNext()) {
                this.provideSubclassesForClass((String)subClassNameIter.next(), includeDescendents, consumer);
            }
        }
    }

    private Set computeDirectSubclassesForClass(String className) {
        HashSet<String> result = new HashSet<String>();
        Collection<AbstractClassMetaData> cmds = this.classMetaDataByClass.values();
        for (AbstractClassMetaData acmd : cmds) {
            ClassMetaData cmd;
            if (!(acmd instanceof ClassMetaData) || (cmd = (ClassMetaData)acmd).getPersistenceCapableSuperclass() == null || !cmd.getPersistenceCapableSuperclass().equals(className)) continue;
            result.add(cmd.getFullClassName());
        }
        return result;
    }

    public String[] getClassesImplementingInterface(String interfaceName, ClassLoaderResolver clr) {
        HashSet classes = new HashSet();
        Class intfClass = clr.classForName(interfaceName);
        HashSet<String> generatedClassNames = new HashSet<String>();
        Collection<AbstractClassMetaData> cmds = this.classMetaDataByClass.values();
        Iterator<AbstractClassMetaData> cmdIter = cmds.iterator();
        boolean isPersistentInterface = false;
        while (cmdIter.hasNext()) {
            AbstractClassMetaData acmd = cmdIter.next();
            Class implClass = null;
            try {
                implClass = clr.classForName(acmd.getFullClassName());
            }
            catch (ClassNotResolvedException cnre) {
                // empty catch block
            }
            if (implClass != null) {
                if (acmd instanceof ClassMetaData) {
                    this.initialiseAbstractClassMetaData(acmd, clr);
                    if (!intfClass.isAssignableFrom(implClass) || ((ClassMetaData)acmd).isAbstract()) continue;
                    classes.add(implClass);
                    continue;
                }
                if (!(acmd instanceof InterfaceMetaData) || !intfClass.isAssignableFrom(implClass)) continue;
                isPersistentInterface = true;
                continue;
            }
            if (!this.isPersistentInterfaceImplementation(interfaceName, acmd.getFullClassName())) continue;
            isPersistentInterface = true;
            generatedClassNames.add(acmd.getFullClassName());
        }
        if (isPersistentInterface && this.nucleusContext.getImplementationCreator() != null) {
            classes.add(this.nucleusContext.getImplementationCreator().newInstance(intfClass, clr).getClass());
            int numClasses = classes.size() + generatedClassNames.size();
            String[] classNames = new String[numClasses];
            Iterator iter = classes.iterator();
            int i = 0;
            while (iter.hasNext()) {
                classNames[i++] = ((Class)iter.next()).getName();
            }
            iter = generatedClassNames.iterator();
            while (iter.hasNext()) {
                classNames[i++] = (String)iter.next();
            }
            return classNames;
        }
        if (classes.size() > 0) {
            TreeSet classesSorted = new TreeSet(new InterfaceClassComparator());
            Iterator classesIter = classes.iterator();
            while (classesIter.hasNext()) {
                classesSorted.add(classesIter.next());
            }
            String[] classNames = new String[classesSorted.size()];
            Iterator iter = classesSorted.iterator();
            int i = 0;
            while (iter.hasNext()) {
                classNames[i++] = ((Class)iter.next()).getName();
            }
            return classNames;
        }
        return null;
    }

    protected void addORMDataToClass(Class c, ClassLoaderResolver clr) {
    }

    void addAnnotationsDataToClass(Class c, AbstractClassMetaData cmd, ClassLoaderResolver clr) {
        if (this.allowAnnotations) {
            ClassMetaData annotCmd;
            if (cmd.getPackageMetaData() != null && cmd.getPackageMetaData().getFileMetaData() != null && cmd.getPackageMetaData().getFileMetaData().getType() == MetadataFileType.ANNOTATIONS) {
                return;
            }
            FileMetaData filemd = this.loadAnnotationsForClass(c, clr, false, false);
            if (filemd != null && (annotCmd = filemd.getPackage(0).getClass(0)) != null) {
                this.postProcessClassMetaData(annotCmd, clr);
                MetaDataMerger.mergeClassAnnotationsData(cmd, annotCmd, this);
            }
        }
    }

    public ClassMetaData getMetaDataForImplementationOfReference(Class referenceClass, Object implValue, ClassLoaderResolver clr) {
        if (referenceClass == null || !referenceClass.isInterface() && referenceClass != Object.class) {
            return null;
        }
        ClassMetaData intfMetaData = this.getClassMetaDataForImplementationOfPersistentInterface(referenceClass.getName());
        if (intfMetaData != null) {
            return intfMetaData;
        }
        ClassMetaData cmd = null;
        Set<String> classMetaDataClasses = this.classMetaDataByClass.keySet();
        block2: for (String class_name : classMetaDataClasses) {
            AbstractClassMetaData acmd_cls = this.classMetaDataByClass.get(class_name);
            if (!(acmd_cls instanceof ClassMetaData)) continue;
            try {
                Class<?> cls = referenceClass.getClassLoader().loadClass(class_name);
                if (!referenceClass.isAssignableFrom(cls)) continue;
                cmd = (ClassMetaData)acmd_cls;
                if (implValue != null && cmd.getFullClassName().equals(implValue.getClass().getName())) {
                    return cmd;
                }
                AbstractClassMetaData cmd_superclass = cmd.getSuperAbstractClassMetaData();
                while (cmd_superclass != null && referenceClass.isAssignableFrom(clr.classForName(((ClassMetaData)cmd_superclass).getFullClassName()))) {
                    cmd = (ClassMetaData)cmd_superclass;
                    if (implValue != null && cmd.getFullClassName().equals(implValue.getClass().getName())) continue block2;
                    if ((cmd_superclass = cmd_superclass.getSuperAbstractClassMetaData()) != null) continue;
                }
            }
            catch (Exception e) {}
        }
        return cmd;
    }

    public AbstractMemberMetaData getMetaDataForMember(String className, String memberName, ClassLoaderResolver clr) {
        if (className == null || memberName == null) {
            return null;
        }
        AbstractClassMetaData cmd = this.getMetaDataForClass(className, clr);
        return cmd != null ? cmd.getMetaDataForMember(memberName) : null;
    }

    public AbstractMemberMetaData getMetaDataForMember(Class c, ClassLoaderResolver clr, String memberName) {
        if (c == null || memberName == null) {
            return null;
        }
        AbstractClassMetaData cmd = this.getMetaDataForClass(c, clr);
        return cmd != null ? cmd.getMetaDataForMember(memberName) : null;
    }

    public QueryMetaData getMetaDataForQuery(Class cls, ClassLoaderResolver clr, String queryName) {
        if (queryName == null || this.queryMetaDataByName == null) {
            return null;
        }
        String query_key = queryName;
        if (cls != null) {
            query_key = cls.getName() + "_" + queryName;
        }
        return this.queryMetaDataByName.get(query_key);
    }

    public StoredProcQueryMetaData getMetaDataForStoredProcQuery(Class cls, ClassLoaderResolver clr, String queryName) {
        if (queryName == null || this.storedProcQueryMetaDataByName == null) {
            return null;
        }
        String query_key = queryName;
        if (cls != null) {
            query_key = cls.getName() + "_" + queryName;
        }
        return this.storedProcQueryMetaDataByName.get(query_key);
    }

    public FetchPlanMetaData getMetaDataForFetchPlan(String name) {
        if (name == null || this.fetchPlanMetaDataByName == null) {
            return null;
        }
        return this.fetchPlanMetaDataByName.get(name);
    }

    public SequenceMetaData getMetaDataForSequence(ClassLoaderResolver clr, String seqName) {
        if (seqName == null || this.sequenceMetaDataByPackageSequence == null) {
            return null;
        }
        return this.sequenceMetaDataByPackageSequence.get(seqName);
    }

    public TableGeneratorMetaData getMetaDataForTableGenerator(ClassLoaderResolver clr, String genName) {
        if (genName == null || this.tableGeneratorMetaDataByPackageSequence == null) {
            return null;
        }
        return this.tableGeneratorMetaDataByPackageSequence.get(genName);
    }

    public QueryResultMetaData getMetaDataForQueryResult(String name) {
        if (name == null || this.queryResultMetaDataByName == null) {
            return null;
        }
        return this.queryResultMetaDataByName.get(name);
    }

    public InterfaceMetaData getMetaDataForInterface(Class c, ClassLoaderResolver clr) {
        return null;
    }

    public boolean isPersistentInterface(String name) {
        return false;
    }

    public boolean isPersistentInterfaceImplementation(String interfaceName, String implName) {
        return false;
    }

    public boolean isPersistentDefinitionImplementation(String implName) {
        return false;
    }

    public String getImplementationNameForPersistentInterface(String interfaceName) {
        return null;
    }

    public ClassMetaData getClassMetaDataForImplementationOfPersistentInterface(String interfaceName) {
        return null;
    }

    public void registerPersistentInterface(InterfaceMetaData imd, Class implClass, ClassLoaderResolver clr) {
    }

    public void registerImplementationOfAbstractClass(ClassMetaData cmd, Class implClass, ClassLoaderResolver clr) {
    }

    public PersistenceUnitMetaData getMetaDataForPersistenceUnit(String unitName) {
        String filename = this.nucleusContext.getPersistenceConfiguration().getStringProperty("datanucleus.persistenceXmlFilename");
        PersistenceFileMetaData[] files = MetaDataUtils.parsePersistenceFiles(this.nucleusContext.getPluginManager(), filename, this.validateXML);
        if (files == null) {
            throw new NucleusUserException(LOCALISER.msg("044046"));
        }
        for (int i = 0; i < files.length; ++i) {
            PersistenceUnitMetaData[] unitmds = files[i].getPersistenceUnits();
            if (unitmds == null) continue;
            for (int j = 0; j < unitmds.length; ++j) {
                if (!unitmds[j].getName().equals(unitName)) continue;
                return unitmds[j];
            }
        }
        return null;
    }

    protected abstract FileMetaData parseFile(URL var1);

    public abstract void registerFile(String var1, FileMetaData var2, ClassLoaderResolver var3);

    protected void registerSequencesForFile(FileMetaData filemd) {
        for (int i = 0; i < filemd.getNoOfPackages(); ++i) {
            PackageMetaData pmd = filemd.getPackage(i);
            SequenceMetaData[] seqmds = pmd.getSequences();
            if (seqmds == null) continue;
            if (this.sequenceMetaDataByPackageSequence == null) {
                this.sequenceMetaDataByPackageSequence = new HashMap<String, SequenceMetaData>();
            }
            for (int j = 0; j < seqmds.length; ++j) {
                this.sequenceMetaDataByPackageSequence.put(seqmds[j].getFullyQualifiedName(), seqmds[j]);
                this.sequenceMetaDataByPackageSequence.put(seqmds[j].getName(), seqmds[j]);
            }
        }
    }

    protected void registerTableGeneratorsForFile(FileMetaData filemd) {
        for (int i = 0; i < filemd.getNoOfPackages(); ++i) {
            PackageMetaData pmd = filemd.getPackage(i);
            TableGeneratorMetaData[] tgmds = pmd.getTableGenerators();
            if (tgmds == null) continue;
            if (this.tableGeneratorMetaDataByPackageSequence == null) {
                this.tableGeneratorMetaDataByPackageSequence = new HashMap<String, TableGeneratorMetaData>();
            }
            for (int j = 0; j < tgmds.length; ++j) {
                this.tableGeneratorMetaDataByPackageSequence.put(tgmds[j].getFullyQualifiedName(), tgmds[j]);
                this.tableGeneratorMetaDataByPackageSequence.put(tgmds[j].getName(), tgmds[j]);
            }
        }
    }

    protected void registerQueryResultMetaDataForFile(FileMetaData filemd) {
        int i;
        QueryResultMetaData[] fqrmds = filemd.getQueryResultMetaData();
        if (fqrmds != null) {
            if (this.queryResultMetaDataByName == null) {
                this.queryResultMetaDataByName = new HashMap<String, QueryResultMetaData>();
            }
            for (i = 0; i < fqrmds.length; ++i) {
                this.queryResultMetaDataByName.put(fqrmds[i].getName(), fqrmds[i]);
            }
        }
        for (i = 0; i < filemd.getNoOfPackages(); ++i) {
            PackageMetaData pmd = filemd.getPackage(i);
            for (int j = 0; j < pmd.getNoOfClasses(); ++j) {
                ClassMetaData cmd = pmd.getClass(j);
                QueryResultMetaData[] qrmds = cmd.getQueryResultMetaData();
                if (qrmds == null) continue;
                if (this.queryResultMetaDataByName == null) {
                    this.queryResultMetaDataByName = new HashMap<String, QueryResultMetaData>();
                }
                for (int k = 0; k < qrmds.length; ++k) {
                    this.queryResultMetaDataByName.put(qrmds[k].getName(), qrmds[k]);
                }
            }
        }
    }

    protected void registerQueriesForFile(FileMetaData filemd) {
        int i;
        QueryMetaData[] queries = filemd.getQueries();
        if (queries != null) {
            if (this.queryMetaDataByName == null) {
                this.queryMetaDataByName = new HashMap<String, QueryMetaData>();
            }
            for (i = 0; i < queries.length; ++i) {
                String scope = queries[i].getScope();
                String key = queries[i].getName();
                if (scope != null) {
                    key = scope + "_" + key;
                }
                this.queryMetaDataByName.put(key, queries[i]);
            }
        }
        for (i = 0; i < filemd.getNoOfPackages(); ++i) {
            String key;
            String scope;
            int k;
            int j;
            PackageMetaData pmd = filemd.getPackage(i);
            for (j = 0; j < pmd.getNoOfClasses(); ++j) {
                ClassMetaData cmd = pmd.getClass(j);
                QueryMetaData[] classQueries = cmd.getQueries();
                if (classQueries == null) continue;
                if (this.queryMetaDataByName == null) {
                    this.queryMetaDataByName = new HashMap<String, QueryMetaData>();
                }
                for (k = 0; k < classQueries.length; ++k) {
                    scope = classQueries[k].getScope();
                    key = classQueries[k].getName();
                    if (scope != null) {
                        key = scope + "_" + key;
                    }
                    this.queryMetaDataByName.put(key, classQueries[k]);
                }
            }
            for (j = 0; j < pmd.getNoOfInterfaces(); ++j) {
                InterfaceMetaData intfmd = pmd.getInterface(j);
                QueryMetaData[] interfaceQueries = intfmd.getQueries();
                if (interfaceQueries == null) continue;
                if (this.queryMetaDataByName == null) {
                    this.queryMetaDataByName = new HashMap<String, QueryMetaData>();
                }
                for (k = 0; k < interfaceQueries.length; ++k) {
                    scope = interfaceQueries[k].getScope();
                    key = interfaceQueries[k].getName();
                    if (scope != null) {
                        key = scope + "_" + key;
                    }
                    this.queryMetaDataByName.put(key, interfaceQueries[k]);
                }
            }
        }
    }

    protected void registerStoredProcQueriesForFile(FileMetaData filemd) {
        int i;
        StoredProcQueryMetaData[] queries = filemd.getStoredProcQueries();
        if (queries != null) {
            if (this.storedProcQueryMetaDataByName == null) {
                this.storedProcQueryMetaDataByName = new HashMap<String, StoredProcQueryMetaData>();
            }
            for (i = 0; i < queries.length; ++i) {
                String key = queries[i].getName();
                this.storedProcQueryMetaDataByName.put(key, queries[i]);
            }
        }
        for (i = 0; i < filemd.getNoOfPackages(); ++i) {
            String key;
            int k;
            int j;
            PackageMetaData pmd = filemd.getPackage(i);
            for (j = 0; j < pmd.getNoOfClasses(); ++j) {
                ClassMetaData cmd = pmd.getClass(j);
                StoredProcQueryMetaData[] classStoredProcQueries = cmd.getStoredProcQueries();
                if (classStoredProcQueries == null) continue;
                if (this.storedProcQueryMetaDataByName == null) {
                    this.storedProcQueryMetaDataByName = new HashMap<String, StoredProcQueryMetaData>();
                }
                for (k = 0; k < classStoredProcQueries.length; ++k) {
                    key = classStoredProcQueries[k].getName();
                    this.storedProcQueryMetaDataByName.put(key, classStoredProcQueries[k]);
                }
            }
            for (j = 0; j < pmd.getNoOfInterfaces(); ++j) {
                InterfaceMetaData intfmd = pmd.getInterface(j);
                StoredProcQueryMetaData[] interfaceStoredProcQueries = intfmd.getStoredProcQueries();
                if (interfaceStoredProcQueries == null) continue;
                if (this.storedProcQueryMetaDataByName == null) {
                    this.storedProcQueryMetaDataByName = new HashMap<String, StoredProcQueryMetaData>();
                }
                for (k = 0; k < interfaceStoredProcQueries.length; ++k) {
                    key = interfaceStoredProcQueries[k].getName();
                    this.storedProcQueryMetaDataByName.put(key, interfaceStoredProcQueries[k]);
                }
            }
        }
    }

    protected void registerFetchPlansForFile(FileMetaData filemd) {
        FetchPlanMetaData[] fetchPlans = filemd.getFetchPlans();
        if (fetchPlans != null) {
            if (this.fetchPlanMetaDataByName == null) {
                this.fetchPlanMetaDataByName = new HashMap<String, FetchPlanMetaData>();
            }
            for (int i = 0; i < fetchPlans.length; ++i) {
                this.fetchPlanMetaDataByName.put(fetchPlans[i].getName(), fetchPlans[i]);
            }
        }
    }

    protected void populateFileMetaData(FileMetaData filemd, ClassLoaderResolver clr, ClassLoader primary) {
        filemd.setMetaDataManager(this);
        for (int i = 0; i < filemd.getNoOfPackages(); ++i) {
            AbstractClassMetaData cmd;
            int j;
            PackageMetaData pmd = filemd.getPackage(i);
            for (j = 0; j < pmd.getNoOfClasses(); ++j) {
                cmd = pmd.getClass(j);
                this.populateAbstractClassMetaData(cmd, clr, primary);
            }
            for (j = 0; j < pmd.getNoOfInterfaces(); ++j) {
                cmd = pmd.getInterface(j);
                this.populateAbstractClassMetaData(cmd, clr, primary);
            }
        }
    }

    protected void initialiseFileMetaData(FileMetaData filemd, ClassLoaderResolver clr, ClassLoader primary) {
        for (int i = 0; i < filemd.getNoOfPackages(); ++i) {
            int j;
            PackageMetaData pmd = filemd.getPackage(i);
            pmd.initialise(clr, this);
            for (j = 0; j < pmd.getNoOfClasses(); ++j) {
                ClassMetaData cmd = pmd.getClass(j);
                try {
                    this.initialiseClassMetaData(cmd, clr.classForName(cmd.getFullClassName(), primary), clr);
                    continue;
                }
                catch (NucleusException ne) {
                    throw ne;
                }
                catch (RuntimeException re) {
                    // empty catch block
                }
            }
            for (j = 0; j < pmd.getNoOfInterfaces(); ++j) {
                InterfaceMetaData imd = pmd.getInterface(j);
                try {
                    this.initialiseInterfaceMetaData(imd, clr, primary);
                    continue;
                }
                catch (NucleusException jpex) {
                    throw jpex;
                }
                catch (RuntimeException re) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialiseClassMetaData(ClassMetaData cmd, Class cls, ClassLoaderResolver clr) {
        ClassMetaData classMetaData = cmd;
        synchronized (classMetaData) {
            if (this.getNucleusContext().getType() == NucleusContext.ContextType.PERSISTENCE && cmd.getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_CAPABLE && !this.getNucleusContext().getApiAdapter().isPersistable(cls)) {
                throw new NucleusUserException(LOCALISER.msg("044059", (Object)cls.getName()));
            }
            this.populateAbstractClassMetaData(cmd, clr, cls.getClassLoader());
            this.initialiseAbstractClassMetaData(cmd, clr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialiseInterfaceMetaData(InterfaceMetaData imd, ClassLoaderResolver clr, ClassLoader primary) {
        InterfaceMetaData interfaceMetaData = imd;
        synchronized (interfaceMetaData) {
            this.populateAbstractClassMetaData(imd, clr, primary);
            this.initialiseAbstractClassMetaData(imd, clr);
        }
    }

    protected FileMetaData loadAnnotationsForClass(Class cls, ClassLoaderResolver clr, boolean register, boolean populate) {
        if (!this.allowAnnotations) {
            return null;
        }
        if (this.isClassWithoutPersistenceInfo(cls.getName())) {
            return null;
        }
        String clsPackageName = ClassUtils.getPackageNameForClass(cls);
        if (clsPackageName == null) {
            clsPackageName = "";
        }
        FileMetaData filemd = new FileMetaData();
        filemd.setType(MetadataFileType.ANNOTATIONS);
        filemd.setMetaDataManager(this);
        PackageMetaData pmd = filemd.newPackageMetadata(clsPackageName);
        AbstractClassMetaData cmd = this.annotationManager.getMetaDataForClass(cls, pmd, clr);
        if (cmd != null) {
            if (register) {
                this.registerFile("annotations:" + cls.getName(), filemd, clr);
                if (populate) {
                    this.populateFileMetaData(filemd, clr, cls.getClassLoader());
                }
            }
            return filemd;
        }
        return null;
    }

    protected void postProcessClassMetaData(AbstractClassMetaData cmd, ClassLoaderResolver clr) {
    }

    protected void populateAbstractClassMetaData(final AbstractClassMetaData acmd, final ClassLoaderResolver clr, final ClassLoader loader) {
        if (!acmd.isPopulated() && !acmd.isInitialised()) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        acmd.populate(clr, loader, MetaDataManager.this);
                    }
                    catch (NucleusException ne) {
                        throw ne;
                    }
                    catch (Exception e) {
                        throw new NucleusUserException("Exception during population of metadata for " + acmd.getFullClassName(), e);
                    }
                    return null;
                }
            });
        }
    }

    void abstractClassMetaDataInitialised(AbstractClassMetaData acmd) {
        if (acmd.getIdentityType() == IdentityType.APPLICATION && !acmd.usesSingleFieldIdentityClass()) {
            this.classMetaDataByAppIdClassName.put(acmd.getObjectidClass(), acmd);
        }
        if (this.listeners != null && this.loadedMetaData != null) {
            this.loadedMetaData.add(acmd);
        }
    }

    protected void initialiseAbstractClassMetaData(final AbstractClassMetaData acmd, final ClassLoaderResolver clr) {
        if (!acmd.isInitialised()) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        acmd.initialise(clr, MetaDataManager.this);
                        if (acmd.hasExtension("cache-pin") && acmd.getValueForExtension("cache-pin").equalsIgnoreCase("true")) {
                            Class cls = clr.classForName(acmd.getFullClassName());
                            MetaDataManager.this.nucleusContext.getLevel2Cache().pinAll(cls, false);
                        }
                    }
                    catch (NucleusException ne) {
                        throw ne;
                    }
                    catch (Exception e) {
                        throw new NucleusUserException("Exception during initialisation of metadata for " + acmd.getFullClassName(), e);
                    }
                    return null;
                }
            });
        }
    }

    public List<AbstractClassMetaData> getReferencedClasses(String[] classNames, ClassLoaderResolver clr) {
        ArrayList<AbstractClassMetaData> cmds = new ArrayList<AbstractClassMetaData>();
        for (int i = 0; i < classNames.length; ++i) {
            Class cls = null;
            try {
                cls = clr.classForName(classNames[i]);
                if (cls.isInterface()) continue;
                AbstractClassMetaData cmd = this.getMetaDataForClass(classNames[i], clr);
                if (cmd == null) {
                    NucleusLogger.DATASTORE.warn("Class Invalid " + classNames[i]);
                    throw new NoPersistenceInformationException(classNames[i]);
                }
                cmds.addAll(this.getReferencedClassMetaData(cmd, clr));
                continue;
            }
            catch (ClassNotResolvedException cnre) {
                NucleusLogger.DATASTORE.warn("Class " + classNames[i] + " not found so being ignored");
            }
        }
        return cmds;
    }

    protected List<AbstractClassMetaData> getReferencedClassMetaData(AbstractClassMetaData cmd, ClassLoaderResolver clr) {
        if (cmd == null) {
            return null;
        }
        ArrayList<AbstractClassMetaData> orderedCMDs = new ArrayList<AbstractClassMetaData>();
        HashSet referencedCMDs = new HashSet();
        cmd.getReferencedClassMetaData(orderedCMDs, referencedCMDs, clr, this);
        return orderedCMDs;
    }

    public boolean isFieldTypePersistable(Class type) {
        AbstractClassMetaData cmd;
        if (this.isEnhancing() && (cmd = this.readMetaDataForClass(type.getName())) != null && cmd instanceof ClassMetaData && cmd.getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_CAPABLE) {
            return true;
        }
        return this.nucleusContext.getApiAdapter().isPersistable(type);
    }

    private static class InterfaceClassComparator
    implements Comparator,
    Serializable {
        public int compare(Object o1, Object o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null || o2 == null) {
                return Integer.MIN_VALUE;
            }
            Class cls1 = (Class)o1;
            Class cls2 = (Class)o2;
            return cls1.hashCode() - cls2.hashCode();
        }
    }
}

