/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.tool.connections;

import com.google.appengine.repackaged.com.google.common.flags.DocLevel;
import com.google.appengine.repackaged.com.google.common.flags.Flag;
import com.google.appengine.repackaged.com.google.common.flags.FlagSpec;
import com.google.cloud.sql.jdbc.internal.Util;
import com.google.cloud.sql.tool.Log;
import com.google.cloud.sql.tool.connections.ConnectionException;
import com.google.cloud.sql.tool.connections.CredentialsConnectionFactory;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;

public class FlagsConnectionFactory
extends CredentialsConnectionFactory {
    @FlagSpec(help="Database User name (passed to DriverManager.getConnection).")
    static final Flag<String> user = Flag.value("");
    @FlagSpec(help="Database Password (passed to DriverManager.getConnection).")
    private static final Flag<String> pass = Flag.value((String)null);
    @FlagSpec(help="Driver type to use.", docLevel=DocLevel.SECRET)
    private static final Flag<Class<? extends Driver>> driver = Flag.value(null, Driver.class);
    @FlagSpec(help="Server to use.", docLevel=DocLevel.SECRET)
    private static final Flag<String> server = Flag.value("");
    static String password;

    public FlagsConnectionFactory() {
        if (password == null) {
            password = pass.get();
        }
    }

    protected Driver getDriver() throws ConnectionException, SQLException {
        try {
            Log.vlog("Using driver: {0}", driver.get().getName());
            if (driver.get() == null) {
                throw new ConnectionException("--driver was not specified and is required.");
            }
            Driver d = driver.get().newInstance();
            DriverManager.registerDriver(d);
            return d;
        }
        catch (InstantiationException e) {
            throw new ConnectionException("Unable to register JDBC Driver", e);
        }
        catch (IllegalAccessException e) {
            throw new ConnectionException("Unable to register JDBC Driver", e);
        }
    }

    @Override
    public Connection connect(String url, Map<String, String> props) throws ConnectionException, SQLException {
        Driver driver = this.getDriver();
        Properties info = new Properties();
        String username = user.get();
        info.setProperty("user", username);
        if (!Util.isEmpty(username) && password == null) {
            password = Util.makeSafe(this.getPasswordPrompter("Password").get());
        }
        info.setProperty("password", Util.makeSafe(password));
        info.setProperty("jdbcCompliantTruncation", Boolean.FALSE.toString());
        if (!server.get().isEmpty()) {
            info.put("server", server.get());
        }
        if (props != null) {
            for (Map.Entry<String, String> e : props.entrySet()) {
                info.put(e.getKey(), e.getValue());
            }
        }
        Log.vlog("Connecting: url = {0}, properties = {1}", url, info);
        return driver.connect(url, info);
    }
}

