/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.jdbc.internal.googleapi;

import com.google.api.client.googleapis.GoogleHeaders;
import com.google.api.client.googleapis.auth.oauth2.draft10.GoogleAccessProtectedResource;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.protobuf.ProtoHttpContent;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Throwables;
import com.google.appengine.repackaged.com.google.protobuf.Message;
import com.google.cloud.sql.jdbc.internal.SqlRpc;
import com.google.cloud.sql.jdbc.internal.SqlRpcOptions;
import com.google.cloud.sql.jdbc.internal.Url;
import com.google.cloud.sql.jdbc.internal.Util;
import com.google.cloud.sql.jdbc.internal.googleapi.AccessTokenRefresher;
import com.google.cloud.sql.jdbc.internal.googleapi.HeaderProvider;
import com.google.cloud.sql.jdbc.internal.googleapi.HeaderProviderFactory;
import com.google.cloud.sql.jdbc.internal.googleapi.OAuthTokens;
import com.google.protos.cloud.sql.CloseConnectionRequest;
import com.google.protos.cloud.sql.CloseConnectionResponse;
import com.google.protos.cloud.sql.ExecOpRequest;
import com.google.protos.cloud.sql.ExecOpResponse;
import com.google.protos.cloud.sql.ExecRequest;
import com.google.protos.cloud.sql.ExecResponse;
import com.google.protos.cloud.sql.MetadataRequest;
import com.google.protos.cloud.sql.MetadataResponse;
import com.google.protos.cloud.sql.OpenConnectionRequest;
import com.google.protos.cloud.sql.OpenConnectionResponse;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class RpcGoogleApi
implements SqlRpc {
    private final GoogleApi api;

    public RpcGoogleApi(AccessTokenRefresher accessTokenRefresher, Url url, HttpTransport transport, TokenCachePolicy cachePolicy, Preferences prefs) {
        this(new DefaultGoogleApi(accessTokenRefresher, url, transport, cachePolicy, prefs));
    }

    RpcGoogleApi(GoogleApi api) {
        this.api = Util.checkNotNull(api, "api can not be null");
    }

    @Override
    public OpenConnectionResponse openConnection(SqlRpcOptions options, OpenConnectionRequest request) throws SQLException {
        try {
            return this.api.exec(GoogleApi.Method.OPEN_CONNECTION.getMethodName(), request, OpenConnectionResponse.class);
        }
        catch (HttpResponseException e) {
            throw this.newOpenConnectionIOException(e);
        }
        catch (IOException e) {
            throw this.newOpenConnectionIOException(e);
        }
    }

    @Override
    public CloseConnectionResponse closeConnection(SqlRpcOptions options, CloseConnectionRequest request) throws SQLException {
        try {
            return this.api.exec(GoogleApi.Method.CLOSE_CONNECTION.getMethodName(), request, CloseConnectionResponse.class);
        }
        catch (HttpResponseException e) {
            throw this.newSqlException(e);
        }
        catch (IOException e) {
            throw this.newSqlException(e);
        }
    }

    @Override
    public ExecResponse exec(SqlRpcOptions options, ExecRequest request) throws SQLException {
        try {
            return this.api.exec(GoogleApi.Method.EXEC.getMethodName(), request, ExecResponse.class);
        }
        catch (HttpResponseException e) {
            throw this.newSqlException(e);
        }
        catch (IOException e) {
            throw this.newSqlException(e);
        }
    }

    @Override
    public ExecOpResponse execOp(SqlRpcOptions options, ExecOpRequest request) throws SQLException {
        try {
            return this.api.exec(GoogleApi.Method.EXEC_OP.getMethodName(), request, ExecOpResponse.class);
        }
        catch (HttpResponseException e) {
            throw this.newSqlException(e);
        }
        catch (IOException e) {
            throw this.newSqlException(e);
        }
    }

    @Override
    public MetadataResponse getMetadata(SqlRpcOptions options, MetadataRequest request) throws SQLException {
        try {
            return this.api.exec(GoogleApi.Method.GET_METADATA.getMethodName(), request, MetadataResponse.class);
        }
        catch (HttpResponseException e) {
            throw this.newSqlException(e);
        }
        catch (IOException e) {
            throw this.newSqlException(e);
        }
    }

    private SQLException newSqlException(HttpResponseException e) {
        String reason;
        Throwable root = Throwables.getRootCause(e);
        try {
            reason = e.getResponse().parseAsString();
        }
        catch (IOException ioEx) {
            reason = e.getMessage();
            root = e;
        }
        if (Util.isEmpty(reason)) {
            reason = String.format("HTTP Error %d - %s", e.getResponse().getStatusCode(), e.getResponse().getStatusMessage());
        }
        return new SQLException(reason, root);
    }

    private SQLException newSqlException(IOException e) {
        return new SQLException(e.getMessage(), e);
    }

    private SQLException newOpenConnectionIOException(IOException e) {
        return new SQLException(e.getMessage(), "08006", e);
    }

    static class DefaultGoogleApi
    implements GoogleApi {
        private static final int CONNECT_TIMEOUT_MILLIS = 60000;
        private static final int READ_TIMEOUT_MILLIS = 400000;
        private static final String DEFAULT_GOOGLEAPI_SERVER = "https://www.googleapis.com/sql/v1/";
        private static final Logger logger = Logger.getLogger(DefaultGoogleApi.class.getCanonicalName());
        private final AccessTokenRefresher accessTokenRefresher;
        private final Url url;
        private final HeaderProvider headerProvider;
        private final HttpTransport transport;
        private final TokenCachePolicy cachePolicy;
        private final Preferences prefs;
        private final HttpRequestFactory requestFactory;
        private final String urlPrefix;
        private final String urlSuffix;
        private volatile boolean authenticated;
        private final GoogleAccessProtectedResource accessProtectedResource = new GoogleAccessProtectedResource(null);
        private final AtomicReference<OAuthTokens> tokens = new AtomicReference();

        DefaultGoogleApi(AccessTokenRefresher accessTokenRefresher, Url url, HttpTransport transport, TokenCachePolicy cachePolicy, Preferences prefs) {
            this.accessTokenRefresher = Util.checkNotNull(accessTokenRefresher, "accessTokenRefresher can not be null");
            this.url = Util.checkNotNull(url, "url can not be null");
            this.headerProvider = HeaderProviderFactory.createHeaderProvider(url);
            this.transport = Util.checkNotNull(transport, "transport can not be null");
            this.cachePolicy = Util.checkNotNull(cachePolicy, "cachePolicy can not be null");
            this.prefs = prefs;
            if (prefs == null && cachePolicy != TokenCachePolicy.CACHE_NONE) {
                throw new IllegalArgumentException("prefs can only be null when cachePolicy is CACHE_NONE");
            }
            this.tokens.set(OAuthTokens.fromUrl(url));
            this.requestFactory = transport.createRequestFactory(new HttpRequestInitializer(){

                @Override
                public void initialize(HttpRequest request) {
                    GoogleHeaders headers = new GoogleHeaders();
                    headers.setApplicationName("Google SQL Service/1.0");
                    DefaultGoogleApi.this.headerProvider.apply(headers);
                    request.setHeaders(headers).setInterceptor(DefaultGoogleApi.this.accessProtectedResource).setConnectTimeout(60000).setReadTimeout(400000);
                }
            });
            String server = url.getServer();
            if (server == null) {
                server = DEFAULT_GOOGLEAPI_SERVER;
            }
            if (!server.startsWith("http://") && !server.startsWith("https://")) {
                throw new IllegalArgumentException("The server parameter of URL must start with http:// or https:// server = " + server);
            }
            StringBuilder urlPrefixBuilder = new StringBuilder(server);
            if (!server.endsWith("/")) {
                urlPrefixBuilder.append('/');
            }
            this.urlPrefix = urlPrefixBuilder.toString();
            StringBuilder urlSuffixBuilder = new StringBuilder("?alt=proto");
            String googleApiParameters = url.getGoogleApiParameters();
            if (googleApiParameters != null) {
                urlSuffixBuilder.append("&").append(googleApiParameters);
            }
            this.urlSuffix = urlSuffixBuilder.toString();
        }

        @Override
        public <T> T exec(String method, Message message, Class<T> clazz) throws IOException {
            try {
                this.refreshAccessTokenIfNeeded();
                return this.execImpl(method, message, clazz);
            }
            catch (HttpResponseException e) {
                if (e.getResponse().getStatusCode() == 401) {
                    this.refreshAccessToken();
                }
                return this.execImpl(method, message, clazz);
            }
        }

        @VisibleForTesting
        void refreshAccessToken() throws IOException {
            OAuthTokens t = this.accessTokenRefresher.refreshAccessToken(this.tokens.get(), this.transport, this.url);
            this.tokens.set(t);
            try {
                this.cacheTokens(t);
            }
            catch (BackingStoreException e) {
                logger.log(Level.WARNING, "Unable to cache tokens.", e);
            }
            this.setAccessTokenInHeader();
        }

        <T> T execImpl(String method, Message message, Class<T> clazz) throws IOException {
            T t;
            HttpResponse httpResponse = this.createRequest(method, message).execute();
            InputStream is = httpResponse.getContent();
            try {
                Message.Builder b = (Message.Builder)clazz.getMethod("newBuilder", new Class[0]).invoke(clazz, new Object[0]);
                t = clazz.cast(b.mergeFrom(is).build());
            }
            catch (IllegalArgumentException e) {
                throw new IOException(e);
            }
            catch (SecurityException e) {
                throw new IOException(e);
            }
            catch (IllegalAccessException e) {
                throw new IOException(e);
            }
            catch (InvocationTargetException e) {
                throw new IOException(e);
            }
            catch (NoSuchMethodException e) {
                throw new IOException(e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ignored) {}
                }
            }
            return t;
        }

        private HttpRequest createRequest(String method, Message message) throws IOException {
            String url = this.urlPrefix + method + this.urlSuffix;
            logger.log(Level.FINE, "Sending request to {0}", url);
            return this.requestFactory.buildPostRequest(new GenericUrl(url), new ProtoHttpContent(message));
        }

        private void cacheTokens(OAuthTokens t) throws BackingStoreException {
            switch (this.cachePolicy) {
                case CACHE_ACCESS_TOKEN: {
                    logger.fine("Caching access token");
                    if (this.prefs == null || t.getAccessToken() == null) break;
                    this.prefs.put(this.url.getOAuth2AccessTokenKey(), t.getAccessToken());
                    this.prefs.flush();
                    break;
                }
                case CACHE_ALL: {
                    logger.fine("Caching refresh and access tokens");
                    if (this.prefs == null) break;
                    if (t.getRefreshToken() != null) {
                        this.prefs.put(this.url.getOAuth2RefreshTokenKey(), t.getRefreshToken());
                    }
                    if (t.getAccessToken() != null) {
                        this.prefs.put(this.url.getOAuth2AccessTokenKey(), t.getAccessToken());
                    }
                    this.prefs.flush();
                    break;
                }
                case CACHE_NONE: {
                    logger.fine("Not caching any tokens per cache policy.");
                }
            }
        }

        OAuthTokens getTokens() {
            return this.tokens.get();
        }

        void setTokens(OAuthTokens t) {
            this.tokens.set(t);
        }

        private synchronized void refreshAccessTokenIfNeeded() throws IOException {
            String tokenInHeader;
            OAuthTokens t = this.tokens.get();
            if (this.authenticated && (tokenInHeader = this.accessProtectedResource.getAccessToken()) != null && !tokenInHeader.equals(t.getAccessToken())) {
                this.setAccessTokenInHeader();
            }
            if (Util.isEmpty(t.getAccessToken()) && !Util.isEmpty(t.getRefreshToken())) {
                this.refreshAccessToken();
            } else {
                this.setAccessTokenInHeader();
            }
        }

        @Override
        public synchronized void setAccessTokenInHeader() throws IOException {
            String accessToken = this.tokens.get().getAccessToken();
            if (!Util.isEmpty(accessToken)) {
                this.accessProtectedResource.setAccessToken(accessToken);
                this.authenticated = true;
            }
        }
    }

    static interface GoogleApi {
        public <T> T exec(String var1, Message var2, Class<T> var3) throws IOException;

        public void setAccessTokenInHeader() throws IOException;

        public static enum Method {
            OPEN_CONNECTION("jdbc/openConnection"),
            CLOSE_CONNECTION("jdbc/closeConnection"),
            EXEC("jdbc/exec"),
            EXEC_OP("jdbc/execOp"),
            GET_METADATA("jdbc/getMetadata");

            private final String methodName;

            private Method(String methodName) {
                this.methodName = methodName;
            }

            String getMethodName() {
                return this.methodName;
            }
        }
    }

    public static enum TokenCachePolicy {
        CACHE_NONE,
        CACHE_ALL,
        CACHE_ACCESS_TOKEN;

    }
}

