/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.jdbc.internal.googleapi;

import com.google.api.client.http.HttpHeaders;
import com.google.appengine.repackaged.com.google.common.logging.FormattingLogger;
import com.google.cloud.sql.jdbc.internal.Url;
import com.google.cloud.sql.jdbc.internal.googleapi.HeaderProvider;
import java.lang.reflect.InvocationTargetException;

public class HeaderProviderFactory {
    private static final FormattingLogger logger = FormattingLogger.getLogger(HeaderProviderFactory.class);

    public static HeaderProvider createHeaderProvider(Url url) {
        String className = url.getHeaderProviderClassName();
        if (className != null) {
            try {
                return Class.forName(className).asSubclass(HeaderProvider.class).getConstructor(Url.class).newInstance(url);
            }
            catch (ClassNotFoundException e) {
                logger.finestfmt(e, "Could not instantiate %s", className);
            }
            catch (IllegalAccessException e) {
                logger.infofmt(e, "Could not instantiate %s", className);
            }
            catch (InstantiationException e) {
                logger.infofmt(e, "Could not instantiate %s", className);
            }
            catch (InvocationTargetException e) {
                logger.infofmt(e, "Could not instantiate %s", className);
            }
            catch (NoSuchMethodException e) {
                logger.infofmt(e, "Could not instantiate %s", className);
            }
            catch (SecurityException e) {
                logger.infofmt(e, "Could not instantiate %s", className);
            }
        }
        return new HeaderProvider(){

            @Override
            public void apply(HttpHeaders data) {
            }
        };
    }
}

