/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis;

import com.google.api.client.http.HttpHeaders;
import com.google.api.client.util.Key;
import com.google.api.client.util.escape.PercentEscaper;

public class GoogleHeaders
extends HttpHeaders {
    public static final PercentEscaper SLUG_ESCAPER = new PercentEscaper(" !\"#$&'()*+,-./:;<=>?@[\\]^_`{|}~", false);
    @Deprecated
    @Key(value="GData-Version")
    public String gdataVersion;
    @Deprecated
    @Key(value="Slug")
    public String slug;
    @Deprecated
    @Key(value="X-GData-Client")
    public String gdataClient;
    @Deprecated
    @Key(value="X-GData-Key")
    public String gdataKey;
    @Deprecated
    @Key(value="x-goog-acl")
    public String googAcl;
    @Deprecated
    @Key(value="x-goog-copy-source")
    public String googCopySource;
    @Deprecated
    @Key(value="x-goog-copy-source-if-match")
    public String googCopySourceIfMatch;
    @Deprecated
    @Key(value="x-goog-copy-source-if-none-match")
    public String googCopySourceIfNoneMatch;
    @Deprecated
    @Key(value="x-goog-copy-source-if-modified-since")
    public String googCopySourceIfModifiedSince;
    @Deprecated
    @Key(value="x-goog-copy-source-if-unmodified-since")
    public String googCopySourceIfUnmodifiedSince;
    @Deprecated
    @Key(value="x-goog-date")
    public String googDate;
    @Deprecated
    @Key(value="x-goog-metadata-directive")
    public String googMetadataDirective;
    @Deprecated
    @Key(value="X-HTTP-Method-Override")
    public String methodOverride;
    @Key(value="X-Upload-Content-Length")
    private long uploadContentLength;
    @Key(value="X-Upload-Content-Type")
    private String uploadContentType;

    public void setSlugFromFileName(String fileName) {
        this.slug = SLUG_ESCAPER.escape(fileName);
    }

    public void setApplicationName(String applicationName) {
        this.setUserAgent(applicationName);
    }

    public void setDeveloperId(String developerId) {
        this.gdataKey = "key=" + developerId;
    }

    public void setGoogleLogin(String authToken) {
        this.setAuthorization(GoogleHeaders.getGoogleLoginValue(authToken));
    }

    public final long getUploadContentLength() {
        return this.uploadContentLength;
    }

    public final void setUploadContentLength(long uploadContentLength) {
        this.uploadContentLength = uploadContentLength;
    }

    public final String getUploadContentType() {
        return this.uploadContentType;
    }

    public final void setUploadContentType(String uploadContentType) {
        this.uploadContentType = uploadContentType;
    }

    public static String getGoogleLoginValue(String authToken) {
        return "GoogleLogin auth=" + authToken;
    }

    public final String getGDataVersion() {
        return this.gdataVersion;
    }

    public final void setGDataVersion(String gdataVersion) {
        this.gdataVersion = gdataVersion;
    }

    public final String getSlug() {
        return this.slug;
    }

    public final void setSlug(String slug) {
        this.slug = slug;
    }

    public final String getGDataClient() {
        return this.gdataClient;
    }

    public final void setGDataClient(String gdataClient) {
        this.gdataClient = gdataClient;
    }

    public final String getGDataKey() {
        return this.gdataKey;
    }

    public final void setGDataKey(String gdataKey) {
        this.gdataKey = gdataKey;
    }

    public final String getMethodOverride() {
        return this.methodOverride;
    }

    public final void setMethodOverride(String methodOverride) {
        this.methodOverride = methodOverride;
    }
}

