/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.commons.httpclient;

import com.google.appengine.repackaged.org.apache.commons.httpclient.HttpException;
import com.google.appengine.repackaged.org.apache.commons.httpclient.NameValuePair;
import com.google.appengine.repackaged.org.apache.commons.httpclient.util.ParameterParser;
import com.google.appengine.repackaged.org.apache.commons.logging.Log;
import com.google.appengine.repackaged.org.apache.commons.logging.LogFactory;
import java.util.ArrayList;
import java.util.List;

public class HeaderElement
extends NameValuePair {
    private static final Log LOG = LogFactory.getLog(HeaderElement.class);
    private NameValuePair[] parameters = null;

    public HeaderElement() {
        this(null, null, null);
    }

    public HeaderElement(String string, String string2) {
        this(string, string2, null);
    }

    public HeaderElement(String string, String string2, NameValuePair[] nameValuePairArray) {
        super(string, string2);
        this.parameters = nameValuePairArray;
    }

    public HeaderElement(char[] cArray, int n, int n2) {
        this();
        if (cArray == null) {
            return;
        }
        ParameterParser parameterParser = new ParameterParser();
        List list = parameterParser.parse(cArray, n, n2, ';');
        if (list.size() > 0) {
            NameValuePair nameValuePair = (NameValuePair)list.remove(0);
            this.setName(nameValuePair.getName());
            this.setValue(nameValuePair.getValue());
            if (list.size() > 0) {
                this.parameters = list.toArray(new NameValuePair[list.size()]);
            }
        }
    }

    public HeaderElement(char[] cArray) {
        this(cArray, 0, cArray.length);
    }

    public NameValuePair[] getParameters() {
        return this.parameters;
    }

    public static final HeaderElement[] parseElements(char[] cArray) {
        LOG.trace("enter HeaderElement.parseElements(char[])");
        if (cArray == null) {
            return new HeaderElement[0];
        }
        ArrayList<NameValuePair> arrayList = new ArrayList<NameValuePair>();
        int n = 0;
        int n2 = cArray.length;
        boolean bl = false;
        for (int i = 0; i < n2; ++i) {
            char c = cArray[i];
            if (c == '\"') {
                bl = !bl;
            }
            NameValuePair nameValuePair = null;
            if (!bl && c == ',') {
                nameValuePair = new HeaderElement(cArray, n, i);
                n = i + 1;
            } else if (i == n2 - 1) {
                nameValuePair = new HeaderElement(cArray, n, n2);
            }
            if (nameValuePair == null || nameValuePair.getName() == null) continue;
            arrayList.add(nameValuePair);
        }
        return arrayList.toArray(new HeaderElement[arrayList.size()]);
    }

    public static final HeaderElement[] parseElements(String string) {
        LOG.trace("enter HeaderElement.parseElements(String)");
        if (string == null) {
            return new HeaderElement[0];
        }
        return HeaderElement.parseElements(string.toCharArray());
    }

    public static final HeaderElement[] parse(String string) throws HttpException {
        LOG.trace("enter HeaderElement.parse(String)");
        if (string == null) {
            return new HeaderElement[0];
        }
        return HeaderElement.parseElements(string.toCharArray());
    }

    public NameValuePair getParameterByName(String string) {
        LOG.trace("enter HeaderElement.getParameterByName(String)");
        if (string == null) {
            throw new IllegalArgumentException("Name may not be null");
        }
        NameValuePair nameValuePair = null;
        NameValuePair[] nameValuePairArray = this.getParameters();
        if (nameValuePairArray != null) {
            for (int i = 0; i < nameValuePairArray.length; ++i) {
                NameValuePair nameValuePair2 = nameValuePairArray[i];
                if (!nameValuePair2.getName().equalsIgnoreCase(string)) continue;
                nameValuePair = nameValuePair2;
                break;
            }
        }
        return nameValuePair;
    }
}

