/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.appstats;

import com.google.appengine.repackaged.com.google.protobuf.Descriptors;
import com.google.appengine.repackaged.com.google.protobuf.Message;
import com.google.appengine.tools.appstats.StatsProtos;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class StatsUtil {
    private static final double MCYCLES_PER_SECOND = 1200.0;
    private static final Comparator<List<Object>> BY_SECOND_ENTRY = StatsUtil.makeComparator(1, 0);
    private static final Comparator<List<Object>> BY_FIRST_ENTRY = StatsUtil.makeComparator(0, 1);
    private static final Comparator<Map.Entry<String, Long>> BY_ENTRY_VALUE = new Comparator<Map.Entry<String, Long>>(){

        @Override
        public int compare(Map.Entry<String, Long> o1, Map.Entry<String, Long> o2) {
            int c = -o1.getValue().compareTo(o2.getValue());
            if (c == 0) {
                c = o1.getKey().compareTo(o2.getKey());
            }
            return c;
        }
    };

    private StatsUtil() {
    }

    private static String extractKey(StatsProtos.RequestStatProto summary) {
        String result = summary.getHttpPath();
        if (!summary.getHttpMethod().equals("GET")) {
            result = summary.getHttpMethod() + " " + result;
        }
        return result;
    }

    static long megaCyclesToMilliseconds(long megaCycles) {
        return (long)((double)(1000L * megaCycles) / 1200.0);
    }

    private static Map<String, Object> toMap(Message proto) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Descriptors.FieldDescriptor field : proto.getDescriptorForType().getFields()) {
            Object value = proto.getField(field);
            if (value == null) continue;
            result.put(field.getName(), value);
            if (!(value instanceof List)) continue;
            result.put(field.getName() + "_list", value);
            result.put(field.getName() + "_size", ((List)value).size());
        }
        return result;
    }

    private static Map<String, Object> augmentProto(StatsProtos.RequestStatProto proto) {
        Map<String, Object> result = StatsUtil.toMap((Message)proto);
        result.put("api_milliseconds", StatsUtil.megaCyclesToMilliseconds(proto.getApiMcycles()));
        result.put("processor_milliseconds", StatsUtil.megaCyclesToMilliseconds(proto.getProcessorMcycles()));
        result.put("start_time_formatted", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date(proto.getStartTimestampMilliseconds())));
        ArrayList<Map<String, Object>> sublist = new ArrayList<Map<String, Object>>();
        for (StatsProtos.IndividualRpcStatsProto stat : proto.getIndividualStatsList()) {
            Map<String, Object> subMap = StatsUtil.toMap((Message)stat);
            subMap.put("api_milliseconds", StatsUtil.megaCyclesToMilliseconds(stat.getApiMcycles()));
            sublist.add(subMap);
        }
        result.put("individual_stats", sublist);
        result.put("individual_stats_list", sublist);
        long count = 0L;
        for (StatsProtos.AggregateRpcStatsProto stat : proto.getRpcStatsList()) {
            count += stat.getTotalAmountOfCalls();
        }
        result.put("combined_rpc_count", count);
        return result;
    }

    private static List<Map.Entry<String, Long>> order(Map<String, Long> elements) {
        ArrayList<Map.Entry<String, Long>> result = new ArrayList<Map.Entry<String, Long>>(elements.entrySet());
        Collections.sort(result, BY_ENTRY_VALUE);
        return result;
    }

    private static Comparator<List<Object>> makeComparator(final int ... fieldOrder) {
        return new Comparator<List<Object>>(){

            @Override
            public int compare(List<Object> o1, List<Object> o2) {
                int result = 0;
                for (int i : fieldOrder) {
                    Comparable c1 = (Comparable)o1.get(i);
                    Comparable c2 = (Comparable)o2.get(i);
                    int n = result = c1 instanceof Number ? -c1.compareTo(c2) : c1.compareTo(c2);
                    if (result == 0) continue;
                    return result;
                }
                return result;
            }
        };
    }

    static Map<String, Object> createSummaryStats(List<StatsProtos.RequestStatProto> records) {
        records = new ArrayList<StatsProtos.RequestStatProto>(records);
        Collections.sort(records, new Comparator<StatsProtos.RequestStatProto>(){

            @Override
            public int compare(StatsProtos.RequestStatProto o1, StatsProtos.RequestStatProto o2) {
                Long l1 = o1.getStartTimestampMilliseconds();
                Long l2 = o2.getStartTimestampMilliseconds();
                return -l1.compareTo(l2);
            }
        });
        ArrayList<Map<String, Object>> augmented = new ArrayList<Map<String, Object>>();
        for (StatsProtos.RequestStatProto proto : records) {
            augmented.add(StatsUtil.augmentProto(proto));
        }
        HashMap<String, List<Integer>> pathStats = new HashMap<String, List<Integer>>();
        HashMap pivotPathRpc = new HashMap();
        HashMap pivotRpcPath = new HashMap();
        HashMap<String, Long> allStats = new HashMap<String, Long>();
        for (int i = 0; i < records.size(); ++i) {
            List<Integer> list;
            String pathKey = StatsUtil.extractKey(records.get(i));
            if (!pathStats.containsKey(pathKey)) {
                list = new ArrayList<Integer>();
                list.add(1);
                list.add(i + 1);
                pathStats.put(pathKey, list);
            } else {
                list = (List)pathStats.get(pathKey);
                list.set(0, (Integer)list.get(0) + 1);
                if (list.size() >= 11) {
                    if ((Integer)list.get(list.size() - 1) != 0) {
                        list.add(0);
                    }
                } else {
                    list.add(i + 1);
                }
            }
            if (!pivotPathRpc.containsKey(pathKey)) {
                pivotPathRpc.put(pathKey, new HashMap());
            }
            for (StatsProtos.AggregateRpcStatsProto stat : records.get(i).getRpcStatsList()) {
                Map rpcPath;
                String rpcKey = stat.getServiceCallName();
                long previous = allStats.containsKey(rpcKey) ? (Long)allStats.get(rpcKey) : 0L;
                allStats.put(rpcKey, previous + stat.getTotalAmountOfCalls());
                Map pathRpc = (Map)pivotPathRpc.get(pathKey);
                previous = pathRpc.containsKey(rpcKey) ? (Long)pathRpc.get(rpcKey) : 0L;
                pathRpc.put(rpcKey, previous + stat.getTotalAmountOfCalls());
                if (!pivotRpcPath.containsKey(rpcKey)) {
                    pivotRpcPath.put(rpcKey, new HashMap());
                }
                previous = (rpcPath = (Map)pivotRpcPath.get(rpcKey)).containsKey(pathKey) ? (Long)rpcPath.get(pathKey) : 0L;
                rpcPath.put(pathKey, previous + stat.getTotalAmountOfCalls());
            }
        }
        ArrayList allStatsByName = new ArrayList();
        for (Map.Entry stat : allStats.entrySet()) {
            List<Map.Entry<String, Long>> ordered = StatsUtil.order((Map)pivotRpcPath.get(stat.getKey()));
            ArrayList<Object> tuple = new ArrayList<Object>();
            tuple.add(stat.getKey());
            tuple.add(stat.getValue());
            tuple.add(ordered);
            allStatsByName.add(tuple);
        }
        Collections.sort(allStatsByName, BY_FIRST_ENTRY);
        ArrayList allStatsByCount = new ArrayList(allStatsByName);
        Collections.sort(allStatsByCount, BY_SECOND_ENTRY);
        ArrayList pathStatsByName = new ArrayList();
        for (Map.Entry stat : pathStats.entrySet()) {
            List<Map.Entry<String, Long>> ordered = StatsUtil.order((Map)pivotPathRpc.get(stat.getKey()));
            Integer elem0 = (Integer)((List)stat.getValue()).remove(0);
            long rpcCount = 0L;
            for (Map.Entry<String, Long> rpc : ordered) {
                rpcCount += rpc.getValue().longValue();
            }
            ArrayList<Object> tuple = new ArrayList<Object>();
            tuple.add(stat.getKey());
            tuple.add(rpcCount);
            tuple.add(elem0);
            tuple.add(stat.getValue());
            tuple.add(ordered);
            pathStatsByName.add(tuple);
        }
        Collections.sort(pathStatsByName, BY_FIRST_ENTRY);
        ArrayList pathStatsByCount = new ArrayList(pathStatsByName);
        Collections.sort(pathStatsByCount, BY_SECOND_ENTRY);
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("requests", augmented);
        values.put("allstats_by_count", allStatsByCount);
        values.put("pathstats_by_count", pathStatsByCount);
        return values;
    }

    static Map<String, Object> createDetailedStats(StatsProtos.RequestStatProto data) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("record", StatsUtil.augmentProto(data));
        parameters.put("file_url", false);
        HashMap<String, ArrayList<Long>> rpcStatsMap = new HashMap<String, ArrayList<Long>>();
        for (StatsProtos.IndividualRpcStatsProto rpcStat : data.getIndividualStatsList()) {
            String key = rpcStat.getServiceCallName();
            ArrayList<Long> tuple = (ArrayList<Long>)rpcStatsMap.get(key);
            if (tuple == null) {
                tuple = new ArrayList<Long>();
                tuple.add(0L);
                tuple.add(0L);
                tuple.add(0L);
                rpcStatsMap.put(key, tuple);
            }
            tuple.set(0, (Long)tuple.get(0) + 1L);
            tuple.set(1, (Long)tuple.get(1) + rpcStat.getDurationMilliseconds());
            tuple.set(2, (Long)tuple.get(2) + rpcStat.getApiMcycles());
        }
        ArrayList rpcStatsByCount = new ArrayList();
        for (Map.Entry entry : rpcStatsMap.entrySet()) {
            ArrayList<Object> l = new ArrayList<Object>();
            l.add(entry.getKey());
            l.add(((List)entry.getValue()).get(0));
            l.add(((List)entry.getValue()).get(1));
            l.add(StatsUtil.megaCyclesToMilliseconds((Long)((List)entry.getValue()).get(2)));
            rpcStatsByCount.add(l);
        }
        Collections.sort(rpcStatsByCount, BY_SECOND_ENTRY);
        parameters.put("rpcstats_by_count", rpcStatsByCount);
        long realTotal = 0L;
        long apiTotalMcycles = 0L;
        for (StatsProtos.IndividualRpcStatsProto stat : data.getIndividualStatsList()) {
            realTotal += stat.getDurationMilliseconds();
            apiTotalMcycles += stat.getApiMcycles();
        }
        long apiTotal = StatsUtil.megaCyclesToMilliseconds(apiTotalMcycles);
        long chargedTotal = StatsUtil.megaCyclesToMilliseconds(data.getProcessorMcycles() + apiTotalMcycles);
        parameters.put("real_total", realTotal);
        parameters.put("api_total", apiTotal);
        parameters.put("charged_total", chargedTotal);
        return parameters;
    }
}

