/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.conversion;

import com.google.appengine.api.conversion.ConversionErrorCode;
import com.google.appengine.api.conversion.Document;
import com.google.appengine.repackaged.com.google.common.base.Objects;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;

public final class ConversionResult {
    private final ConversionErrorCode errorCode;
    private final Document output;

    ConversionResult(ConversionErrorCode errorCode) {
        this.errorCode = Preconditions.checkNotNull(errorCode);
        this.output = null;
    }

    ConversionResult(Document output) {
        this.errorCode = null;
        this.output = Preconditions.checkNotNull(output);
    }

    public boolean success() {
        return this.output != null;
    }

    public ConversionErrorCode getErrorCode() {
        return this.errorCode;
    }

    public Document getOutputDoc() {
        return this.output;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversionResult other = (ConversionResult)o;
        return Objects.equal((Object)this.errorCode, (Object)other.getErrorCode()) && Objects.equal(this.output, other.getOutputDoc());
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.errorCode, this.output});
    }
}

