/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.enhancer.asm;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.JDOClassLoaderResolver;
import org.datanucleus.enhancer.AbstractImplementationGenerator;
import org.datanucleus.enhancer.EnhancerClassLoader;
import org.datanucleus.enhancer.asm.ASMClassEnhancer;
import org.datanucleus.enhancer.asm.ASMUtils;
import org.datanucleus.enhancer.asm.JdoPropertyGetterAdapter;
import org.datanucleus.enhancer.asm.JdoPropertySetterAdapter;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.InterfaceMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.util.ClassUtils;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class ASMImplementationGenerator
extends AbstractImplementationGenerator {
    ClassWriter writer;
    String asmClassName;
    String asmTypeDescriptor;

    public ASMImplementationGenerator(InterfaceMetaData interfaceMetaData, String implClassName, MetaDataManager mmgr) {
        super(interfaceMetaData, implClassName, mmgr);
        this.asmClassName = this.fullClassName.replace('.', '/');
        this.asmTypeDescriptor = "L" + this.asmClassName + ";";
        ArrayList<String> interfaces = new ArrayList<String>();
        InterfaceMetaData imd = interfaceMetaData;
        do {
            String intfTypeName = imd.getFullClassName().replace('.', '/');
            interfaces.add(intfTypeName);
        } while ((imd = (InterfaceMetaData)imd.getSuperAbstractClassMetaData()) != null);
        this.writer = new ClassWriter(1);
        this.writer.visit(47, 33, this.fullClassName.replace('.', '/'), null, this.fullSuperclassName.replace('.', '/'), interfaces.toArray(new String[interfaces.size()]));
        this.createPropertyFields();
        this.createDefaultConstructor();
        this.createPropertyMethods();
        this.writer.visitEnd();
        this.bytes = this.writer.toByteArray();
    }

    public ASMImplementationGenerator(ClassMetaData cmd, String implClassName, MetaDataManager mmgr) {
        super(cmd, implClassName, mmgr);
        this.asmClassName = this.fullClassName.replace('.', '/');
        this.asmTypeDescriptor = "L" + this.asmClassName + ";";
        this.fullSuperclassName = cmd.getFullClassName();
        this.writer = new ClassWriter(1);
        this.writer.visit(47, 33, this.fullClassName.replace('.', '/'), null, this.fullSuperclassName.replace('.', '/'), null);
        this.createPropertyFields();
        this.createDefaultConstructor();
        this.createPropertyMethods();
        this.writer.visitEnd();
        this.bytes = this.writer.toByteArray();
    }

    public void enhance(ClassLoaderResolver clr) {
        EnhancerClassLoader loader = new EnhancerClassLoader();
        loader.defineClass(this.fullClassName, this.getBytes(), clr);
        JDOClassLoaderResolver genclr = new JDOClassLoaderResolver((ClassLoader)loader);
        final ClassMetaData implementationCmd = this.inputCmd instanceof InterfaceMetaData ? new ClassMetaData((InterfaceMetaData)this.inputCmd, this.className, true) : new ClassMetaData((ClassMetaData)this.inputCmd, this.className);
        AccessController.doPrivileged(new PrivilegedAction((ClassLoaderResolver)genclr){
            final /* synthetic */ ClassLoaderResolver val$genclr;
            {
                this.val$genclr = classLoaderResolver;
            }

            public Object run() {
                implementationCmd.populate(this.val$genclr, null, ASMImplementationGenerator.this.metaDataMgr);
                implementationCmd.initialise(this.val$genclr, ASMImplementationGenerator.this.metaDataMgr);
                return null;
            }
        });
        ASMClassEnhancer gen = new ASMClassEnhancer(implementationCmd, (ClassLoaderResolver)genclr, this.metaDataMgr, this.getBytes());
        gen.enhance();
        this.bytes = gen.getClassBytes();
    }

    protected void createPropertyFields(AbstractClassMetaData acmd) {
        if (acmd == null) {
            return;
        }
        AbstractMemberMetaData[] propertyMetaData = acmd.getManagedMembers();
        for (int i = 0; i < propertyMetaData.length; ++i) {
            this.writer.visitField(2, propertyMetaData[i].getName(), Type.getDescriptor((Class)propertyMetaData[i].getType()), null, null).visitEnd();
        }
    }

    protected void createDefaultConstructor() {
        MethodVisitor visitor = this.writer.visitMethod(1, "<init>", "()V", null, null);
        visitor.visitCode();
        Label l0 = new Label();
        visitor.visitLabel(l0);
        visitor.visitVarInsn(25, 0);
        visitor.visitMethodInsn(183, this.fullSuperclassName.replace('.', '/'), "<init>", "()V");
        visitor.visitInsn(177);
        Label l1 = new Label();
        visitor.visitLabel(l1);
        visitor.visitLocalVariable("this", this.asmTypeDescriptor, null, l0, l1, 0);
        visitor.visitMaxs(1, 1);
        visitor.visitEnd();
    }

    protected void createGetter(AbstractMemberMetaData mmd) {
        boolean isBoolean = mmd.getTypeName().equals("boolean");
        String getterName = ClassUtils.getJavaBeanGetterName((String)mmd.getName(), (boolean)isBoolean);
        String jdoGetterName = "jdoGet" + mmd.getName();
        if (this.inputCmd instanceof InterfaceMetaData) {
            String fieldDesc = Type.getDescriptor((Class)mmd.getType());
            MethodVisitor visitor = this.writer.visitMethod(1, getterName, "()" + fieldDesc, null, null);
            visitor.visitCode();
            Label l0 = new Label();
            visitor.visitLabel(l0);
            visitor.visitVarInsn(25, 0);
            visitor.visitFieldInsn(180, this.asmClassName, mmd.getName(), fieldDesc);
            ASMUtils.addReturnForType(visitor, mmd.getType());
            Label l1 = new Label();
            visitor.visitLabel(l1);
            visitor.visitLocalVariable("this", this.asmTypeDescriptor, null, l0, l1, 0);
            visitor.visitMaxs(1, 1);
            visitor.visitEnd();
        } else {
            String fieldDesc = Type.getDescriptor((Class)mmd.getType());
            int getAccess = (mmd.isPublic() ? 1 : 0) | (mmd.isProtected() ? 4 : 0) | (mmd.isPrivate() ? 2 : 0);
            MethodVisitor getVisitor = this.writer.visitMethod(getAccess, getterName, "()" + fieldDesc, null, null);
            JdoPropertyGetterAdapter.generateGetXXXMethod(getVisitor, mmd, this.asmClassName, this.asmTypeDescriptor, false);
            int access = (mmd.isPublic() ? 1 : 0) | (mmd.isProtected() ? 4 : 0) | (mmd.isPrivate() ? 2 : 0);
            MethodVisitor visitor = this.writer.visitMethod(access, jdoGetterName, "()" + fieldDesc, null, null);
            visitor.visitCode();
            Label l0 = new Label();
            visitor.visitLabel(l0);
            visitor.visitVarInsn(25, 0);
            visitor.visitFieldInsn(180, this.asmClassName, mmd.getName(), fieldDesc);
            ASMUtils.addReturnForType(visitor, mmd.getType());
            Label l1 = new Label();
            visitor.visitLabel(l1);
            visitor.visitLocalVariable("this", this.asmTypeDescriptor, null, l0, l1, 0);
            visitor.visitMaxs(1, 1);
            visitor.visitEnd();
        }
    }

    protected void createSetter(AbstractMemberMetaData mmd) {
        String setterName = ClassUtils.getJavaBeanSetterName((String)mmd.getName());
        String jdoSetterName = "jdoSet" + mmd.getName();
        if (this.inputCmd instanceof InterfaceMetaData) {
            String fieldDesc = Type.getDescriptor((Class)mmd.getType());
            MethodVisitor visitor = this.writer.visitMethod(1, setterName, "(" + fieldDesc + ")V", null, null);
            visitor.visitCode();
            Label l0 = new Label();
            visitor.visitLabel(l0);
            visitor.visitVarInsn(25, 0);
            ASMUtils.addLoadForType(visitor, mmd.getType(), 1);
            visitor.visitFieldInsn(181, this.asmClassName, mmd.getName(), fieldDesc);
            visitor.visitInsn(177);
            Label l2 = new Label();
            visitor.visitLabel(l2);
            visitor.visitLocalVariable("this", this.asmTypeDescriptor, null, l0, l2, 0);
            visitor.visitLocalVariable("val", fieldDesc, null, l0, l2, 1);
            visitor.visitMaxs(2, 2);
            visitor.visitEnd();
        } else {
            String fieldDesc = Type.getDescriptor((Class)mmd.getType());
            int setAccess = (mmd.isPublic() ? 1 : 0) | (mmd.isProtected() ? 4 : 0) | (mmd.isPrivate() ? 2 : 0);
            MethodVisitor setVisitor = this.writer.visitMethod(setAccess, setterName, "(" + fieldDesc + ")V", null, null);
            JdoPropertySetterAdapter.generateSetXXXMethod(setVisitor, mmd, this.asmClassName, this.asmTypeDescriptor);
            int access = (mmd.isPublic() ? 1 : 0) | (mmd.isProtected() ? 4 : 0) | (mmd.isPrivate() ? 2 : 0);
            MethodVisitor visitor = this.writer.visitMethod(access, jdoSetterName, "(" + fieldDesc + ")V", null, null);
            visitor.visitCode();
            Label l0 = new Label();
            visitor.visitLabel(l0);
            visitor.visitVarInsn(25, 0);
            ASMUtils.addLoadForType(visitor, mmd.getType(), 1);
            visitor.visitFieldInsn(181, this.asmClassName, mmd.getName(), fieldDesc);
            visitor.visitInsn(177);
            Label l2 = new Label();
            visitor.visitLabel(l2);
            visitor.visitLocalVariable("this", this.asmTypeDescriptor, null, l0, l2, 0);
            visitor.visitLocalVariable("val", fieldDesc, null, l0, l2, 1);
            visitor.visitMaxs(2, 2);
            visitor.visitEnd();
        }
    }
}

