/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.expression;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.IdentifierFactory;
import org.datanucleus.store.mapped.IdentifierType;
import org.datanucleus.store.mapped.expression.ArrayStoreQueryable;
import org.datanucleus.store.mapped.expression.BooleanExpression;
import org.datanucleus.store.mapped.expression.BooleanLiteral;
import org.datanucleus.store.mapped.expression.ContainerSizeExpression;
import org.datanucleus.store.mapped.expression.ExistsExpression;
import org.datanucleus.store.mapped.expression.IntegerLiteral;
import org.datanucleus.store.mapped.expression.Literal;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.NullLiteral;
import org.datanucleus.store.mapped.expression.NumericExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.expression.UnboundVariable;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.scostore.ArrayStore;

public class ArrayExpression
extends ScalarExpression {
    ScalarExpression[] exprs;
    private ArrayStore arrayStore;
    private String fieldName;

    protected ArrayExpression(QueryExpression qs) {
        super(qs);
    }

    public ArrayExpression(QueryExpression qs, ScalarExpression[] expr) {
        super(qs);
        this.exprs = expr;
    }

    public ArrayExpression(QueryExpression qs, JavaTypeMapping ownerMapping, LogicSetExpression te, ArrayStore arrayStore, String fieldName) {
        super(qs);
        this.mapping = ownerMapping;
        this.arrayStore = arrayStore;
        this.fieldName = fieldName;
        this.te = te;
    }

    public NumericExpression sizeMethod() {
        if (this.arrayStore != null) {
            IdentifierFactory idFactory = this.qs.getStoreManager().getIdentifierFactory();
            String ctIdentifier = idFactory.newIdentifier(this.te.getAlias(), this.fieldName).getIdentifierName();
            DatastoreIdentifier ctRangeVar = idFactory.newIdentifier(IdentifierType.TABLE, ctIdentifier);
            return new ContainerSizeExpression(this.qs, this.getBackingStoreQueryable().getSizeSubquery(this.qs, this.mapping, this.te, ctRangeVar));
        }
        JavaTypeMapping mapping = this.qs.getStoreManager().getMappingManager().getMappingWithDatastoreMapping(Integer.class, false, false, this.qs.getClassLoaderResolver());
        return new IntegerLiteral(this.qs, mapping, new Integer(this.exprs.length));
    }

    public NumericExpression lengthMethod() {
        return this.sizeMethod();
    }

    public ScalarExpression accessField(String subfieldName, boolean innerJoin) {
        if (!subfieldName.endsWith("length")) {
            throw new NucleusUserException("The field " + subfieldName + " is not accessible in an array");
        }
        return this.sizeMethod();
    }

    public BooleanExpression containsMethod(ScalarExpression expr) {
        DatastoreIdentifier etRangeVar;
        IdentifierFactory idFactory = this.qs.getStoreManager().getIdentifierFactory();
        if (expr instanceof NullLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, false).eq(new BooleanLiteral(this.qs, this.mapping, true));
        }
        if (this.exprs != null) {
            ScalarExpression bExpr = null;
            for (int i = 0; i < this.exprs.length; ++i) {
                bExpr = bExpr == null ? this.exprs[i].eq(expr) : ((BooleanExpression)bExpr).ior(this.exprs[i].eq(expr));
            }
            bExpr.encloseWithInParentheses();
            return bExpr;
        }
        if (expr instanceof UnboundVariable) {
            UnboundVariable var = (UnboundVariable)expr;
            if (var.getVariableType() == null) {
                var.setVariableType(this.qs.getClassLoaderResolver().classForName(this.arrayStore.getElementType()));
            }
            String etIdentifier = "UNBOUND." + var.getVariableName();
            String ctIdentifier = idFactory.newIdentifier(idFactory.newIdentifier(this.te.getAlias(), this.fieldName), var.getVariableName()).getIdentifierName();
            DatastoreIdentifier ctRangeVar = idFactory.newIdentifier(IdentifierType.TABLE, ctIdentifier);
            DatastoreIdentifier etRangeVar2 = idFactory.newIdentifier(IdentifierType.TABLE, etIdentifier);
            QueryExpression qexpr = this.getBackingStoreQueryable().getExistsSubquery(this.qs, this.mapping, this.te, ctRangeVar);
            var.bindTo(this.getBackingStoreQueryable().joinElementsTo(qexpr, this.qs, this.mapping, this.te, ctRangeVar, var.getVariableType(), expr, expr.te == null ? etRangeVar2 : expr.te.getAlias()));
            return new ExistsExpression(this.qs, qexpr, true);
        }
        if (expr instanceof Literal) {
            DatastoreIdentifier etRangeVar3;
            String ctIdentifier = idFactory.newIdentifier(this.te.getAlias(), this.fieldName).getIdentifierName();
            DatastoreIdentifier ctRangeVar = this.qs.getStoreManager().getIdentifierFactory().newIdentifier(IdentifierType.TABLE, ctIdentifier);
            if (expr.te == null) {
                String etIdentifier;
                int n = 0;
                do {
                    etIdentifier = ctIdentifier + '.' + ++n;
                } while (this.qs.getTableExpression(etRangeVar3 = this.qs.getStoreManager().getIdentifierFactory().newIdentifier(IdentifierType.TABLE, etIdentifier)) != null);
            } else {
                etRangeVar3 = expr.te.getAlias();
            }
            ClassLoaderResolver clr = this.qs.getClassLoaderResolver();
            QueryExpression qexpr = this.getBackingStoreQueryable().getExistsSubquery(this.qs, this.mapping, this.te, ctRangeVar);
            ScalarExpression expr1 = this.getBackingStoreQueryable().joinElementsTo(qexpr, this.qs, this.mapping, this.te, ctRangeVar, clr.classForName(expr.getMapping().getType()), expr, expr.te == null ? etRangeVar3 : expr.te.getAlias());
            qexpr.andCondition(expr.eq(expr1));
            return new ExistsExpression(this.qs, qexpr, true);
        }
        String ctIdentifier = idFactory.newIdentifier(this.te.getAlias(), this.fieldName).getIdentifierName();
        DatastoreIdentifier ctRangeVar = this.qs.getStoreManager().getIdentifierFactory().newIdentifier(IdentifierType.TABLE, ctIdentifier);
        if (expr.te == null) {
            String etIdentifier;
            int n = 0;
            do {
                etIdentifier = ctIdentifier + '.' + ++n;
            } while (this.qs.getTableExpression(etRangeVar = this.qs.getStoreManager().getIdentifierFactory().newIdentifier(IdentifierType.TABLE, etIdentifier)) != null);
        } else {
            etRangeVar = expr.te.getAlias();
        }
        ClassLoaderResolver clr = this.qs.getClassLoaderResolver();
        ScalarExpression joinExpr = this.getBackingStoreQueryable().joinElementsTo(expr.getQueryExpression(), this.qs, this.mapping, this.te, ctRangeVar, clr.classForName(this.arrayStore.getElementType()), expr, etRangeVar);
        return joinExpr.eq(expr);
    }

    private ArrayStoreQueryable getBackingStoreQueryable() {
        return (ArrayStoreQueryable)((Object)this.arrayStore);
    }
}

