/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.collect;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.base.Optional;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.AbstractSequentialIterator;
import com.google.appengine.repackaged.com.google.common.collect.AbstractSortedMultiset;
import com.google.appengine.repackaged.com.google.common.collect.BoundType;
import com.google.appengine.repackaged.com.google.common.collect.BstAggregate;
import com.google.appengine.repackaged.com.google.common.collect.BstCountBasedBalancePolicies;
import com.google.appengine.repackaged.com.google.common.collect.BstInOrderPath;
import com.google.appengine.repackaged.com.google.common.collect.BstModificationResult;
import com.google.appengine.repackaged.com.google.common.collect.BstModifier;
import com.google.appengine.repackaged.com.google.common.collect.BstMutationResult;
import com.google.appengine.repackaged.com.google.common.collect.BstMutationRule;
import com.google.appengine.repackaged.com.google.common.collect.BstNode;
import com.google.appengine.repackaged.com.google.common.collect.BstNodeFactory;
import com.google.appengine.repackaged.com.google.common.collect.BstOperations;
import com.google.appengine.repackaged.com.google.common.collect.BstPathFactory;
import com.google.appengine.repackaged.com.google.common.collect.BstRangeOps;
import com.google.appengine.repackaged.com.google.common.collect.BstSide;
import com.google.appengine.repackaged.com.google.common.collect.GeneralRange;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import com.google.appengine.repackaged.com.google.common.collect.Multiset;
import com.google.appengine.repackaged.com.google.common.collect.Multisets;
import com.google.appengine.repackaged.com.google.common.collect.Ordering;
import com.google.appengine.repackaged.com.google.common.collect.Serialization;
import com.google.appengine.repackaged.com.google.common.collect.SortedMultiset;
import com.google.appengine.repackaged.com.google.common.primitives.Ints;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import javax.annotation.Nullable;

@GwtCompatible(emulated=true)
public final class TreeMultiset<E>
extends AbstractSortedMultiset<E>
implements Serializable {
    private final transient GeneralRange<E> range;
    private final transient Reference<Node<E>> rootReference;
    private static final BstAggregate<Node<Object>> DISTINCT_AGGREGATE = new BstAggregate<Node<Object>>(){

        @Override
        public int entryValue(Node<Object> entry) {
            return 1;
        }

        @Override
        public long treeValue(@Nullable Node<Object> tree) {
            return TreeMultiset.distinctOrZero(tree);
        }
    };
    private static final BstAggregate<Node<Object>> SIZE_AGGREGATE = new BstAggregate<Node<Object>>(){

        @Override
        public int entryValue(Node<Object> entry) {
            return entry.elemCount();
        }

        @Override
        public long treeValue(@Nullable Node<Object> tree) {
            return TreeMultiset.sizeOrZero(tree);
        }
    };
    private static final BstNodeFactory<Node<Object>> NODE_FACTORY = new BstNodeFactory<Node<Object>>(){

        @Override
        public Node<Object> createNode(Node<Object> source, @Nullable Node<Object> left, @Nullable Node<Object> right) {
            return new Node<Object>(source.getKey(), source.elemCount(), left, right);
        }
    };
    @GwtIncompatible(value="not needed in emulated source")
    private static final long serialVersionUID = 1L;

    public static <E extends Comparable> TreeMultiset<E> create() {
        return new TreeMultiset(Ordering.natural());
    }

    public static <E> TreeMultiset<E> create(@Nullable Comparator<? super E> comparator) {
        return comparator == null ? new TreeMultiset(Ordering.natural()) : new TreeMultiset<E>(comparator);
    }

    public static <E extends Comparable> TreeMultiset<E> create(Iterable<? extends E> elements) {
        TreeMultiset<E> multiset = TreeMultiset.create();
        Iterables.addAll(multiset, elements);
        return multiset;
    }

    @Override
    public Iterator<E> iterator() {
        return super.iterator();
    }

    private TreeMultiset(Comparator<? super E> comparator) {
        super(comparator);
        this.range = GeneralRange.all(comparator);
        this.rootReference = new Reference();
    }

    private TreeMultiset(GeneralRange<E> range, Reference<Node<E>> root) {
        super(range.comparator());
        this.range = range;
        this.rootReference = root;
    }

    E checkElement(Object o) {
        Object cast = o;
        this.comparator.compare(cast, cast);
        return (E)cast;
    }

    @Override
    int distinctElements() {
        Node<E> root = this.rootReference.get();
        return Ints.checkedCast(BstRangeOps.totalInRange(this.distinctAggregate(), this.range, root));
    }

    @Override
    public int size() {
        Node<E> root = this.rootReference.get();
        return Ints.saturatedCast(BstRangeOps.totalInRange(this.sizeAggregate(), this.range, root));
    }

    @Override
    public int count(@Nullable Object element) {
        try {
            E e = this.checkElement(element);
            if (this.range.contains(e)) {
                Node node = (Node)BstOperations.seek(this.comparator(), (BstNode)this.rootReference.get(), e);
                return TreeMultiset.countOrZero(node);
            }
            return 0;
        }
        catch (ClassCastException e) {
            return 0;
        }
        catch (NullPointerException e) {
            return 0;
        }
    }

    private int mutate(@Nullable E e, MultisetModifier modifier) {
        BstMutationRule mutationRule = BstMutationRule.createRule(modifier, BstCountBasedBalancePolicies.singleRebalancePolicy(this.distinctAggregate()), this.nodeFactory());
        BstMutationResult<E, BstNode> mutationResult = BstOperations.mutate(this.comparator(), mutationRule, (BstNode)this.rootReference.get(), e);
        if (!this.rootReference.compareAndSet((Node<E>)mutationResult.getOriginalRoot(), (Node<E>)mutationResult.getChangedRoot())) {
            throw new ConcurrentModificationException();
        }
        Node original = (Node)mutationResult.getOriginalTarget();
        return TreeMultiset.countOrZero(original);
    }

    @Override
    public int add(E element, int occurrences) {
        this.checkElement(element);
        if (occurrences == 0) {
            return this.count(element);
        }
        Preconditions.checkArgument(this.range.contains(element));
        return this.mutate(element, new AddModifier(occurrences));
    }

    @Override
    public int remove(@Nullable Object element, int occurrences) {
        if (occurrences == 0) {
            return this.count(element);
        }
        try {
            E e = this.checkElement(element);
            return this.range.contains(e) ? this.mutate(e, new RemoveModifier(occurrences)) : 0;
        }
        catch (ClassCastException e) {
            return 0;
        }
        catch (NullPointerException e) {
            return 0;
        }
    }

    @Override
    public boolean setCount(E element, int oldCount, int newCount) {
        this.checkElement(element);
        Preconditions.checkArgument(this.range.contains(element));
        return this.mutate(element, new ConditionalSetCountModifier(oldCount, newCount)) == oldCount;
    }

    @Override
    public int setCount(E element, int count) {
        this.checkElement(element);
        Preconditions.checkArgument(this.range.contains(element));
        return this.mutate(element, new SetCountModifier(count));
    }

    private BstPathFactory<Node<E>, BstInOrderPath<Node<E>>> pathFactory() {
        return BstInOrderPath.inOrderFactory();
    }

    @Override
    Iterator<Multiset.Entry<E>> entryIterator() {
        Node<E> root = this.rootReference.get();
        BstInOrderPath startingPath = (BstInOrderPath)((Object)BstRangeOps.furthestPath(this.range, BstSide.LEFT, this.pathFactory(), root));
        return this.iteratorInDirection(startingPath, BstSide.RIGHT);
    }

    @Override
    Iterator<Multiset.Entry<E>> descendingEntryIterator() {
        Node<E> root = this.rootReference.get();
        BstInOrderPath startingPath = (BstInOrderPath)((Object)BstRangeOps.furthestPath(this.range, BstSide.RIGHT, this.pathFactory(), root));
        return this.iteratorInDirection(startingPath, BstSide.LEFT);
    }

    private Iterator<Multiset.Entry<E>> iteratorInDirection(@Nullable BstInOrderPath<Node<E>> start, final BstSide direction) {
        final AbstractSequentialIterator pathIterator = new AbstractSequentialIterator<BstInOrderPath<Node<E>>>(start){

            @Override
            protected BstInOrderPath<Node<E>> computeNext(BstInOrderPath<Node<E>> previous) {
                if (!previous.hasNext(direction)) {
                    return null;
                }
                BstInOrderPath next = previous.next(direction);
                return TreeMultiset.this.range.contains(((Node)next.getTip()).getKey()) ? next : null;
            }
        };
        return new Iterator<Multiset.Entry<E>>(){
            final ToRemove<E> toRemove = new ToRemove();

            @Override
            public boolean hasNext() {
                return pathIterator.hasNext();
            }

            @Override
            public Multiset.Entry<E> next() {
                BstInOrderPath path = (BstInOrderPath)pathIterator.next();
                return new LiveEntry(this.toRemove.setAndGet(((Node)path.getTip()).getKey()), ((Node)path.getTip()).elemCount());
            }

            @Override
            public void remove() {
                TreeMultiset.this.setCount(this.toRemove.getAndClear(), 0);
            }
        };
    }

    @Override
    public void clear() {
        Node<E> cleared;
        Node<E> root = this.rootReference.get();
        if (!this.rootReference.compareAndSet(root, cleared = BstRangeOps.minusRange(this.range, BstCountBasedBalancePolicies.fullRebalancePolicy(this.distinctAggregate()), this.nodeFactory(), root))) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public SortedMultiset<E> headMultiset(E upperBound, BoundType boundType) {
        Preconditions.checkNotNull(upperBound);
        return new TreeMultiset<E>(this.range.intersect(GeneralRange.upTo(this.comparator, upperBound, boundType)), this.rootReference);
    }

    @Override
    public SortedMultiset<E> tailMultiset(E lowerBound, BoundType boundType) {
        Preconditions.checkNotNull(lowerBound);
        return new TreeMultiset<E>(this.range.intersect(GeneralRange.downTo(this.comparator, lowerBound, boundType)), this.rootReference);
    }

    @Override
    public Comparator<? super E> comparator() {
        return super.comparator();
    }

    private static long sizeOrZero(@Nullable Node<?> node) {
        return node == null ? 0L : ((Node)node).size;
    }

    private static int distinctOrZero(@Nullable Node<?> node) {
        return node == null ? 0 : ((Node)node).distinct;
    }

    private static int countOrZero(@Nullable Node<?> entry) {
        return entry == null ? 0 : entry.elemCount();
    }

    private BstAggregate<Node<E>> distinctAggregate() {
        return DISTINCT_AGGREGATE;
    }

    private BstAggregate<Node<E>> sizeAggregate() {
        return SIZE_AGGREGATE;
    }

    private BstNodeFactory<Node<E>> nodeFactory() {
        return NODE_FACTORY;
    }

    @GwtIncompatible(value="java.io.ObjectOutputStream")
    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeObject(this.elementSet().comparator());
        Serialization.writeMultiset(this, stream);
    }

    @GwtIncompatible(value="java.io.ObjectInputStream")
    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        Comparator comparator = (Comparator)stream.readObject();
        Serialization.getFieldSetter(AbstractSortedMultiset.class, "comparator").set((AbstractSortedMultiset)this, comparator);
        Serialization.getFieldSetter(TreeMultiset.class, "range").set(this, GeneralRange.all(comparator));
        Serialization.getFieldSetter(TreeMultiset.class, "rootReference").set(this, new Reference());
        Serialization.populateMultiset(this, stream);
    }

    private final class ConditionalSetCountModifier
    extends MultisetModifier {
        private final int expectedCount;
        private final int setCount;

        private ConditionalSetCountModifier(int expectedCount, int setCount) {
            Preconditions.checkArgument(setCount >= 0 & expectedCount >= 0);
            this.expectedCount = expectedCount;
            this.setCount = setCount;
        }

        @Override
        int newCount(int oldCount) {
            return oldCount == this.expectedCount ? this.setCount : oldCount;
        }
    }

    private final class SetCountModifier
    extends MultisetModifier {
        private final int countToSet;

        private SetCountModifier(int countToSet) {
            Preconditions.checkArgument(countToSet >= 0);
            this.countToSet = countToSet;
        }

        @Override
        int newCount(int oldCount) {
            return this.countToSet;
        }
    }

    private final class RemoveModifier
    extends MultisetModifier {
        private final int countToRemove;

        private RemoveModifier(int countToRemove) {
            Preconditions.checkArgument(countToRemove > 0);
            this.countToRemove = countToRemove;
        }

        @Override
        int newCount(int oldCount) {
            return Math.max(0, oldCount - this.countToRemove);
        }
    }

    private final class AddModifier
    extends MultisetModifier {
        private final int countToAdd;

        private AddModifier(int countToAdd) {
            Preconditions.checkArgument(countToAdd > 0);
            this.countToAdd = countToAdd;
        }

        @Override
        int newCount(int oldCount) {
            Preconditions.checkArgument(this.countToAdd <= Integer.MAX_VALUE - oldCount, "Cannot add this many elements");
            return oldCount + this.countToAdd;
        }
    }

    private abstract class MultisetModifier
    implements BstModifier<E, Node<E>> {
        private MultisetModifier() {
        }

        abstract int newCount(int var1);

        @Override
        @Nullable
        public BstModificationResult<Node<E>> modify(E key, @Nullable Node<E> originalEntry) {
            int newCount;
            int oldCount = TreeMultiset.countOrZero(originalEntry);
            if (oldCount == (newCount = this.newCount(oldCount))) {
                return BstModificationResult.identity(originalEntry);
            }
            if (newCount == 0) {
                return BstModificationResult.rebalancingChange(originalEntry, null);
            }
            if (oldCount == 0) {
                return BstModificationResult.rebalancingChange(null, new Node(key, newCount));
            }
            return BstModificationResult.rebuildingChange(originalEntry, new Node(originalEntry.getKey(), newCount));
        }
    }

    private static final class Node<E>
    extends BstNode<E, Node<E>>
    implements Serializable {
        private final long size;
        private final int distinct;
        private static final long serialVersionUID = 0L;

        private Node(E key, int elemCount, @Nullable Node<E> left, @Nullable Node<E> right) {
            super(key, left, right);
            Preconditions.checkArgument(elemCount > 0);
            this.size = (long)elemCount + TreeMultiset.sizeOrZero(left) + TreeMultiset.sizeOrZero(right);
            this.distinct = 1 + TreeMultiset.distinctOrZero(left) + TreeMultiset.distinctOrZero(right);
        }

        int elemCount() {
            long result = this.size - TreeMultiset.sizeOrZero((Node)this.childOrNull(BstSide.LEFT)) - TreeMultiset.sizeOrZero((Node)this.childOrNull(BstSide.RIGHT));
            return Ints.checkedCast(result);
        }

        private Node(E key, int elemCount) {
            this(key, elemCount, null, null);
        }
    }

    class LiveEntry
    extends Multisets.AbstractEntry<E> {
        private Node<E> expectedRoot;
        private final E element;
        private int count;

        private LiveEntry(E element, int count) {
            this.expectedRoot = (Node)TreeMultiset.this.rootReference.get();
            this.element = element;
            this.count = count;
        }

        @Override
        public E getElement() {
            return this.element;
        }

        @Override
        public int getCount() {
            if (TreeMultiset.this.rootReference.get() == this.expectedRoot) {
                return this.count;
            }
            this.expectedRoot = (Node)TreeMultiset.this.rootReference.get();
            this.count = TreeMultiset.this.count(this.element);
            return this.count;
        }
    }

    private static final class ToRemove<E> {
        @Nullable
        Optional<E> element;

        private ToRemove() {
        }

        E setAndGet(@Nullable E element) {
            this.element = Optional.fromNullable(element);
            return element;
        }

        E getAndClear() {
            Preconditions.checkState(this.element != null);
            E returnValue = this.element.orNull();
            this.element = null;
            return returnValue;
        }
    }

    static final class Reference<T> {
        T value;

        public T get() {
            return this.value;
        }

        public boolean compareAndSet(T expected, T newValue) {
            if (this.value == expected) {
                this.value = newValue;
                return true;
            }
            return false;
        }
    }
}

