/*
 * Decompiled with CFR 0.152.
 */
package de.waldheinz.fs.fat;

import de.waldheinz.fs.fat.AbstractDirectory;
import de.waldheinz.fs.fat.ClusterChain;
import de.waldheinz.fs.fat.DirectoryFullException;
import de.waldheinz.fs.fat.Fat;
import de.waldheinz.fs.fat.Fat32BootSector;
import de.waldheinz.fs.fat.FatType;
import java.io.IOException;
import java.nio.ByteBuffer;

class ClusterChainDirectory
extends AbstractDirectory {
    public static final int MAX_SIZE = 0x200000;
    final ClusterChain chain;

    protected ClusterChainDirectory(ClusterChain chain, boolean isRoot) {
        super((int)(chain.getLengthOnDisk() / 32L), chain.isReadOnly(), isRoot);
        this.chain = chain;
    }

    public static ClusterChainDirectory readRoot(ClusterChain chain) throws IOException {
        ClusterChainDirectory result = new ClusterChainDirectory(chain, true);
        result.read();
        return result;
    }

    public static ClusterChainDirectory createRoot(Fat fat) throws IOException {
        if (fat.getFatType() != FatType.FAT32) {
            throw new IllegalArgumentException("only FAT32 stores root directory in a cluster chain");
        }
        Fat32BootSector bs = (Fat32BootSector)fat.getBootSector();
        ClusterChain cc = new ClusterChain(fat, false);
        cc.setChainLength(1);
        bs.setRootDirFirstCluster(cc.getStartCluster());
        ClusterChainDirectory result = new ClusterChainDirectory(cc, true);
        result.flush();
        return result;
    }

    @Override
    protected final void read(ByteBuffer data) throws IOException {
        this.chain.readData(0L, data);
    }

    @Override
    protected final void write(ByteBuffer data) throws IOException {
        int toWrite = data.remaining();
        this.chain.writeData(0L, data);
        long trueSize = this.chain.getLengthOnDisk();
        if (trueSize > (long)toWrite) {
            int rest = (int)(trueSize - (long)toWrite);
            ByteBuffer fill = ByteBuffer.allocate(rest);
            this.chain.writeData(toWrite, fill);
        }
    }

    @Override
    protected final long getStorageCluster() {
        return this.isRoot() ? 0L : this.chain.getStartCluster();
    }

    public final void delete() throws IOException {
        this.chain.setChainLength(0);
    }

    @Override
    protected final void changeSize(int entryCount) throws IOException, IllegalArgumentException {
        assert (entryCount >= 0);
        int size = entryCount * 32;
        if (size > 0x200000) {
            throw new DirectoryFullException("directory would grow beyond 2097152 bytes", this.getCapacity(), entryCount);
        }
        this.sizeChanged(this.chain.setSize(Math.max(size, this.chain.getClusterSize())));
    }
}

