/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.AdbHelper;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.Device;
import com.android.ddmlib.EmulatorConsole;
import com.android.ddmlib.GetPropReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.ddmlib.MonitorThread;
import com.android.ddmlib.MultiLineReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

final class DeviceMonitor {
    private byte[] mLengthBuffer = new byte[4];
    private byte[] mLengthBuffer2 = new byte[4];
    private boolean mQuit = false;
    private AndroidDebugBridge mServer;
    private SocketChannel mMainAdbConnection = null;
    private boolean mMonitoring = false;
    private int mConnectionAttempt = 0;
    private int mRestartAttemptCount = 0;
    private boolean mInitialDeviceListDone = false;
    private Selector mSelector;
    private final ArrayList<Device> mDevices = new ArrayList();
    private final ArrayList<Integer> mDebuggerPorts = new ArrayList();
    private final HashMap<Client, Integer> mClientsToReopen = new HashMap();

    DeviceMonitor(AndroidDebugBridge server) {
        this.mServer = server;
        this.mDebuggerPorts.add(DdmPreferences.getDebugPortBase());
    }

    void start() {
        new Thread("Device List Monitor"){

            @Override
            public void run() {
                DeviceMonitor.this.deviceMonitorLoop();
            }
        }.start();
    }

    void stop() {
        this.mQuit = true;
        try {
            if (this.mMainAdbConnection != null) {
                this.mMainAdbConnection.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.mSelector != null) {
            this.mSelector.wakeup();
        }
    }

    boolean isMonitoring() {
        return this.mMonitoring;
    }

    int getConnectionAttemptCount() {
        return this.mConnectionAttempt;
    }

    int getRestartAttemptCount() {
        return this.mRestartAttemptCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Device[] getDevices() {
        ArrayList<Device> arrayList = this.mDevices;
        synchronized (arrayList) {
            return this.mDevices.toArray(new Device[this.mDevices.size()]);
        }
    }

    boolean hasInitialDeviceList() {
        return this.mInitialDeviceListDone;
    }

    AndroidDebugBridge getServer() {
        return this.mServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addClientToDropAndReopen(Client client, int port) {
        HashMap<Client, Integer> hashMap = this.mClientsToReopen;
        synchronized (hashMap) {
            Log.d("DeviceMonitor", "Adding " + client + " to list of client to reopen (" + port + ").");
            if (this.mClientsToReopen.get(client) == null) {
                this.mClientsToReopen.put(client, port);
            }
        }
        this.mSelector.wakeup();
    }

    private void deviceMonitorLoop() {
        do {
            try {
                int length;
                if (this.mMainAdbConnection == null) {
                    Log.d("DeviceMonitor", "Opening adb connection");
                    this.mMainAdbConnection = this.openAdbConnection();
                    if (this.mMainAdbConnection == null) {
                        ++this.mConnectionAttempt;
                        Log.e("DeviceMonitor", "Connection attempts: " + this.mConnectionAttempt);
                        if (this.mConnectionAttempt > 10) {
                            if (!this.mServer.startAdb()) {
                                ++this.mRestartAttemptCount;
                                Log.e("DeviceMonitor", "adb restart attempts: " + this.mRestartAttemptCount);
                            } else {
                                this.mRestartAttemptCount = 0;
                            }
                        }
                        this.waitABit();
                    } else {
                        Log.d("DeviceMonitor", "Connected to adb for device monitoring");
                        this.mConnectionAttempt = 0;
                    }
                }
                if (this.mMainAdbConnection != null && !this.mMonitoring) {
                    this.mMonitoring = this.sendDeviceListMonitoringRequest();
                }
                if (!this.mMonitoring || (length = this.readLength(this.mMainAdbConnection, this.mLengthBuffer)) < 0) continue;
                this.processIncomingDeviceData(length);
                this.mInitialDeviceListDone = true;
            }
            catch (AsynchronousCloseException ace) {
            }
            catch (TimeoutException ioe) {
                this.handleExpectionInMonitorLoop(ioe);
            }
            catch (IOException ioe) {
                this.handleExpectionInMonitorLoop(ioe);
            }
        } while (!this.mQuit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleExpectionInMonitorLoop(Exception e) {
        if (!this.mQuit) {
            if (e instanceof TimeoutException) {
                Log.e("DeviceMonitor", "Adb connection Error: timeout");
            } else {
                Log.e("DeviceMonitor", "Adb connection Error:" + e.getMessage());
            }
            this.mMonitoring = false;
            if (this.mMainAdbConnection != null) {
                try {
                    this.mMainAdbConnection.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.mMainAdbConnection = null;
                Object object = AndroidDebugBridge.getLock();
                synchronized (object) {
                    ArrayList<Device> arrayList = this.mDevices;
                    synchronized (arrayList) {
                        for (int n = this.mDevices.size() - 1; n >= 0; --n) {
                            Device device = this.mDevices.get(0);
                            this.removeDevice(device);
                            this.mServer.deviceDisconnected(device);
                        }
                    }
                }
            }
        }
    }

    private void waitABit() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private SocketChannel openAdbConnection() {
        Log.d("DeviceMonitor", "Connecting to adb for Device List Monitoring...");
        SocketChannel adbChannel = null;
        try {
            adbChannel = SocketChannel.open(AndroidDebugBridge.getSocketAddress());
            adbChannel.socket().setTcpNoDelay(true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return adbChannel;
    }

    private boolean sendDeviceListMonitoringRequest() throws TimeoutException, IOException {
        byte[] request = AdbHelper.formAdbRequest("host:track-devices");
        try {
            AdbHelper.write(this.mMainAdbConnection, request);
            AdbHelper.AdbResponse resp = AdbHelper.readAdbResponse(this.mMainAdbConnection, false);
            if (!resp.okay) {
                Log.e("DeviceMonitor", "adb refused request: " + resp.message);
            }
            return resp.okay;
        }
        catch (IOException e) {
            Log.e("DeviceMonitor", "Sending Tracking request failed!");
            this.mMainAdbConnection.close();
            throw e;
        }
    }

    private void processIncomingDeviceData(int length) throws IOException {
        ArrayList<Device> list = new ArrayList<Device>();
        if (length > 0) {
            String[] devices;
            byte[] buffer = new byte[length];
            String result = this.read(this.mMainAdbConnection, buffer);
            for (String d : devices = result.split("\n")) {
                String[] param = d.split("\t");
                if (param.length != 2) continue;
                Device device = new Device(this, param[0], IDevice.DeviceState.getState(param[1]));
                list.add(device);
            }
        }
        this.updateDevices(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDevices(ArrayList<Device> newList) {
        Object object = AndroidDebugBridge.getLock();
        synchronized (object) {
            ArrayList<Device> devicesToQuery = new ArrayList<Device>();
            ArrayList<Device> arrayList = this.mDevices;
            synchronized (arrayList) {
                int d = 0;
                while (d < this.mDevices.size()) {
                    Device device = this.mDevices.get(d);
                    int count = newList.size();
                    boolean foundMatch = false;
                    for (int dd = 0; dd < count; ++dd) {
                        Device newDevice = newList.get(dd);
                        if (!newDevice.getSerialNumber().equals(device.getSerialNumber())) continue;
                        foundMatch = true;
                        if (device.getState() != newDevice.getState()) {
                            device.setState(newDevice.getState());
                            device.update(1);
                            if (device.isOnline()) {
                                if (AndroidDebugBridge.getClientSupport() && !this.startMonitoringDevice(device)) {
                                    Log.e("DeviceMonitor", "Failed to start monitoring " + device.getSerialNumber());
                                }
                                if (device.getPropertyCount() == 0) {
                                    devicesToQuery.add(device);
                                }
                            }
                        }
                        newList.remove(dd);
                        break;
                    }
                    if (!foundMatch) {
                        this.removeDevice(device);
                        this.mServer.deviceDisconnected(device);
                        continue;
                    }
                    ++d;
                }
                for (Device newDevice : newList) {
                    this.mDevices.add(newDevice);
                    this.mServer.deviceConnected(newDevice);
                    if (AndroidDebugBridge.getClientSupport() && newDevice.isOnline()) {
                        this.startMonitoringDevice(newDevice);
                    }
                    if (!newDevice.isOnline()) continue;
                    devicesToQuery.add(newDevice);
                }
            }
            for (Device d : devicesToQuery) {
                this.queryNewDeviceForInfo(d);
            }
        }
        newList.clear();
    }

    private void removeDevice(Device device) {
        device.clearClientList();
        this.mDevices.remove(device);
        SocketChannel channel = device.getClientMonitoringSocket();
        if (channel != null) {
            try {
                channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void queryNewDeviceForInfo(Device device) {
        try {
            EmulatorConsole console;
            device.executeShellCommand("getprop", new GetPropReceiver(device));
            this.queryNewDeviceForMountingPoint(device, "EXTERNAL_STORAGE");
            this.queryNewDeviceForMountingPoint(device, "ANDROID_DATA");
            this.queryNewDeviceForMountingPoint(device, "ANDROID_ROOT");
            if (device.isEmulator() && (console = EmulatorConsole.getConsole(device)) != null) {
                device.setAvdName(console.getAvdName());
                console.close();
            }
        }
        catch (TimeoutException e) {
            Log.w("DeviceMonitor", String.format("Connection timeout getting info for device %s", device.getSerialNumber()));
        }
        catch (AdbCommandRejectedException e) {
            Log.w("DeviceMonitor", String.format("Adb rejected command to get  device %1$s info: %2$s", device.getSerialNumber(), e.getMessage()));
        }
        catch (ShellCommandUnresponsiveException e) {
            Log.w("DeviceMonitor", String.format("Adb shell command took too long returning info for device %s", device.getSerialNumber()));
        }
        catch (IOException e) {
            Log.w("DeviceMonitor", String.format("IO Error getting info for device %s", device.getSerialNumber()));
        }
    }

    private void queryNewDeviceForMountingPoint(final Device device, final String name) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        device.executeShellCommand("echo $" + name, new MultiLineReceiver(){

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public void processNewLines(String[] lines) {
                for (String line : lines) {
                    if (line.isEmpty()) continue;
                    device.setMountingPoint(name, line);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startMonitoringDevice(Device device) {
        block15: {
            SocketChannel socketChannel = this.openAdbConnection();
            if (socketChannel != null) {
                try {
                    boolean result = this.sendDeviceMonitoringRequest(socketChannel, device);
                    if (!result) break block15;
                    if (this.mSelector == null) {
                        this.startDeviceMonitorThread();
                    }
                    device.setClientMonitoringSocket(socketChannel);
                    ArrayList<Device> arrayList = this.mDevices;
                    synchronized (arrayList) {
                        this.mSelector.wakeup();
                        socketChannel.configureBlocking(false);
                        socketChannel.register(this.mSelector, 1, device);
                    }
                    return true;
                }
                catch (TimeoutException e) {
                    try {
                        socketChannel.close();
                    }
                    catch (IOException e1) {
                        // empty catch block
                    }
                    Log.d("DeviceMonitor", "Connection Failure when starting to monitor device '" + device + "' : timeout");
                }
                catch (AdbCommandRejectedException e) {
                    try {
                        socketChannel.close();
                    }
                    catch (IOException e1) {
                        // empty catch block
                    }
                    Log.d("DeviceMonitor", "Adb refused to start monitoring device '" + device + "' : " + e.getMessage());
                }
                catch (IOException e) {
                    try {
                        socketChannel.close();
                    }
                    catch (IOException e1) {
                        // empty catch block
                    }
                    Log.d("DeviceMonitor", "Connection Failure when starting to monitor device '" + device + "' : " + e.getMessage());
                }
            }
        }
        return false;
    }

    private void startDeviceMonitorThread() throws IOException {
        this.mSelector = Selector.open();
        new Thread("Device Client Monitor"){

            @Override
            public void run() {
                DeviceMonitor.this.deviceClientMonitorLoop();
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void deviceClientMonitorLoop() {
        do {
            try {
                ArrayList<Device> arrayList = this.mDevices;
                // MONITORENTER : arrayList
                // MONITOREXIT : arrayList
                int count = this.mSelector.select();
                if (this.mQuit) {
                    return;
                }
                HashMap<Client, Integer> hashMap = this.mClientsToReopen;
                // MONITORENTER : hashMap
                if (!this.mClientsToReopen.isEmpty()) {
                    Set<Client> clients = this.mClientsToReopen.keySet();
                    MonitorThread monitorThread = MonitorThread.getInstance();
                    for (Client client : clients) {
                        Device device = client.getDeviceImpl();
                        int pid = client.getClientData().getPid();
                        monitorThread.dropClient(client, false);
                        this.waitABit();
                        int port = this.mClientsToReopen.get(client);
                        if (port == -1) {
                            port = this.getNextDebuggerPort();
                        }
                        Log.d("DeviceMonitor", "Reopening " + client);
                        this.openClient(device, pid, port, monitorThread);
                        device.update(2);
                    }
                    this.mClientsToReopen.clear();
                }
                // MONITOREXIT : hashMap
                if (count == 0) continue;
                Set<SelectionKey> keys = this.mSelector.selectedKeys();
                Iterator<SelectionKey> iter = keys.iterator();
                while (iter.hasNext()) {
                    Device device;
                    SocketChannel socket;
                    Object attachment;
                    SelectionKey key = iter.next();
                    iter.remove();
                    if (!key.isValid() || !key.isReadable() || !((attachment = key.attachment()) instanceof Device) || (socket = (device = (Device)attachment).getClientMonitoringSocket()) == null) continue;
                    try {
                        int length = this.readLength(socket, this.mLengthBuffer2);
                        this.processIncomingJdwpData(device, socket, length);
                    }
                    catch (IOException ioe) {
                        Log.d("DeviceMonitor", "Error reading jdwp list: " + ioe.getMessage());
                        socket.close();
                        ArrayList<Device> arrayList2 = this.mDevices;
                        // MONITORENTER : arrayList2
                        if (this.mDevices.contains(device)) {
                            Log.d("DeviceMonitor", "Restarting monitoring service for " + device);
                            this.startMonitoringDevice(device);
                        }
                        // MONITOREXIT : arrayList2
                    }
                }
            }
            catch (IOException e) {
                Log.e("DeviceMonitor", "Connection error while monitoring clients.");
            }
        } while (!this.mQuit);
    }

    private boolean sendDeviceMonitoringRequest(SocketChannel socket, Device device) throws TimeoutException, AdbCommandRejectedException, IOException {
        try {
            AdbHelper.setDevice(socket, device);
            byte[] request = AdbHelper.formAdbRequest("track-jdwp");
            AdbHelper.write(socket, request);
            AdbHelper.AdbResponse resp = AdbHelper.readAdbResponse(socket, false);
            if (!resp.okay) {
                Log.e("DeviceMonitor", "adb refused request: " + resp.message);
            }
            return resp.okay;
        }
        catch (TimeoutException e) {
            Log.e("DeviceMonitor", "Sending jdwp tracking request timed out!");
            throw e;
        }
        catch (IOException e) {
            Log.e("DeviceMonitor", "Sending jdwp tracking request failed!");
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processIncomingJdwpData(Device device, SocketChannel monitorSocket, int length) throws IOException {
        String[] arr$;
        if (length < 0) return;
        HashSet<Integer> newPids = new HashSet<Integer>();
        if (length > 0) {
            void var10_12;
            String[] pids;
            byte[] buffer = new byte[length];
            String result = this.read(monitorSocket, buffer);
            arr$ = pids = result.split("\n");
            int len$ = arr$.length;
            boolean bl = false;
            while (var10_12 < len$) {
                String pid = arr$[var10_12];
                try {
                    newPids.add(Integer.valueOf(pid));
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
                ++var10_12;
            }
        }
        MonitorThread monitorThread = MonitorThread.getInstance();
        String[] clients = device.getClientList();
        HashMap<Integer, Client> existingClients = new HashMap<Integer, Client>();
        arr$ = clients;
        synchronized (clients) {
            for (Client client : clients) {
                existingClients.put(client.getClientData().getPid(), client);
            }
            // ** MonitorExit[arr$] (shouldn't be in output)
            HashSet clientsToRemove = new HashSet();
            for (Integer n : existingClients.keySet()) {
                if (newPids.contains(n)) continue;
                clientsToRemove.add(existingClients.get(n));
            }
            HashSet pidsToAdd = new HashSet(newPids);
            pidsToAdd.removeAll(existingClients.keySet());
            monitorThread.dropClients(clientsToRemove, false);
            Iterator iterator = pidsToAdd.iterator();
            while (iterator.hasNext()) {
                int newPid = (Integer)iterator.next();
                this.openClient(device, newPid, this.getNextDebuggerPort(), monitorThread);
            }
            if (pidsToAdd.isEmpty() && clientsToRemove.isEmpty()) return;
            this.mServer.deviceChanged(device, 2);
            return;
        }
    }

    private void openClient(Device device, int pid, int port, MonitorThread monitorThread) {
        SocketChannel clientSocket;
        try {
            clientSocket = AdbHelper.createPassThroughConnection(AndroidDebugBridge.getSocketAddress(), device, pid);
            clientSocket.configureBlocking(false);
        }
        catch (UnknownHostException uhe) {
            Log.d("DeviceMonitor", "Unknown Jdwp pid: " + pid);
            return;
        }
        catch (TimeoutException e) {
            Log.w("DeviceMonitor", "Failed to connect to client '" + pid + "': timeout");
            return;
        }
        catch (AdbCommandRejectedException e) {
            Log.w("DeviceMonitor", "Adb rejected connection to client '" + pid + "': " + e.getMessage());
            return;
        }
        catch (IOException ioe) {
            Log.w("DeviceMonitor", "Failed to connect to client '" + pid + "': " + ioe.getMessage());
            return;
        }
        this.createClient(device, pid, clientSocket, port, monitorThread);
    }

    private void createClient(Device device, int pid, SocketChannel socket, int debuggerPort, MonitorThread monitorThread) {
        Client client = new Client(device, socket, pid);
        if (client.sendHandshake()) {
            try {
                if (AndroidDebugBridge.getClientSupport()) {
                    client.listenForDebugger(debuggerPort);
                }
            }
            catch (IOException ioe) {
                client.getClientData().setDebuggerConnectionStatus(ClientData.DebuggerStatus.ERROR);
                Log.e("ddms", "Can't bind to local " + debuggerPort + " for debugger");
            }
            client.requestAllocationStatus();
        } else {
            Log.e("ddms", "Handshake with " + client + " failed!");
        }
        if (client.isValid()) {
            device.addClient(client);
            monitorThread.addClient(client);
        } else {
            client = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextDebuggerPort() {
        ArrayList<Integer> arrayList = this.mDebuggerPorts;
        synchronized (arrayList) {
            if (!this.mDebuggerPorts.isEmpty()) {
                int port = this.mDebuggerPorts.get(0);
                this.mDebuggerPorts.remove(0);
                if (this.mDebuggerPorts.isEmpty()) {
                    this.mDebuggerPorts.add(port + 1);
                }
                return port;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPortToAvailableList(int port) {
        if (port > 0) {
            ArrayList<Integer> arrayList = this.mDebuggerPorts;
            synchronized (arrayList) {
                if (this.mDebuggerPorts.indexOf(port) == -1) {
                    int count = this.mDebuggerPorts.size();
                    for (int i = 0; i < count; ++i) {
                        if (port >= this.mDebuggerPorts.get(i)) continue;
                        this.mDebuggerPorts.add(i, port);
                        break;
                    }
                }
            }
        }
    }

    private int readLength(SocketChannel socket, byte[] buffer) throws IOException {
        String msg = this.read(socket, buffer);
        if (msg != null) {
            try {
                return Integer.parseInt(msg, 16);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        throw new IOException("Unable to read length");
    }

    private String read(SocketChannel socket, byte[] buffer) throws IOException {
        ByteBuffer buf = ByteBuffer.wrap(buffer, 0, buffer.length);
        while (buf.position() != buf.limit()) {
            int count = socket.read(buf);
            if (count >= 0) continue;
            throw new IOException("EOF");
        }
        try {
            return new String(buffer, 0, buf.position(), "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }
}

