/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewerlib.ui;

import com.android.ddmuilib.ImageLoader;
import com.android.hierarchyviewerlib.HierarchyViewerDirector;
import com.android.hierarchyviewerlib.models.ViewNode;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CaptureDisplay {
    private static Shell sShell;
    private static Canvas sCanvas;
    private static Image sImage;
    private static ViewNode sViewNode;
    private static Composite sButtonBar;
    private static Button sOnWhite;
    private static Button sOnBlack;
    private static Button sShowExtras;
    private static PaintListener sPaintListener;
    private static ShellAdapter sShellListener;
    private static SelectionListener sWhiteSelectionListener;
    private static SelectionListener sBlackSelectionListener;
    private static SelectionListener sExtrasSelectionListener;

    public static void show(Shell parentShell, ViewNode viewNode, Image image) {
        if (sShell == null) {
            CaptureDisplay.createShell();
        }
        if (sShell.isVisible() && sViewNode != null) {
            sViewNode.dereferenceImage();
        }
        sImage = image;
        sViewNode = viewNode;
        viewNode.referenceImage();
        sShell.setText(viewNode.name);
        boolean shellVisible = sShell.isVisible();
        if (!shellVisible) {
            sShell.setSize(0, 0);
        }
        Rectangle bounds = sShell.computeTrim(0, 0, Math.max(CaptureDisplay.sButtonBar.getBounds().width, image.getBounds().width), CaptureDisplay.sButtonBar.getBounds().height + image.getBounds().height + 5);
        sShell.setSize(bounds.width, bounds.height);
        if (!shellVisible) {
            sShell.setLocation(parentShell.getBounds().x + (parentShell.getBounds().width - bounds.width) / 2, parentShell.getBounds().y + (parentShell.getBounds().height - bounds.height) / 2);
        }
        sShell.open();
        if (shellVisible) {
            sCanvas.redraw();
        }
    }

    private static void createShell() {
        sShell = new Shell(Display.getDefault(), 96);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        sShell.setLayout((Layout)gridLayout);
        sButtonBar = new Composite((Composite)sShell, 0);
        RowLayout rowLayout = new RowLayout(256);
        rowLayout.pack = true;
        rowLayout.center = true;
        sButtonBar.setLayout((Layout)rowLayout);
        Composite buttons = new Composite(sButtonBar, 0);
        buttons.setLayout((Layout)new FillLayout());
        sOnWhite = new Button(buttons, 2);
        sOnWhite.setText("On White");
        sOnBlack = new Button(buttons, 2);
        sOnBlack.setText("On Black");
        sOnBlack.setSelection(true);
        sOnWhite.addSelectionListener(sWhiteSelectionListener);
        sOnBlack.addSelectionListener(sBlackSelectionListener);
        sShowExtras = new Button(sButtonBar, 32);
        sShowExtras.setText("Show Extras");
        sShowExtras.addSelectionListener(sExtrasSelectionListener);
        sCanvas = new Canvas((Composite)sShell, 0);
        sCanvas.setLayoutData((Object)new GridData(1808));
        sCanvas.addPaintListener(sPaintListener);
        sShell.addShellListener((ShellListener)sShellListener);
        ImageLoader imageLoader = ImageLoader.getLoader(HierarchyViewerDirector.class);
        Image image = imageLoader.loadImage("display.png", Display.getDefault());
        sShell.setImage(image);
    }

    static {
        sPaintListener = new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (sOnWhite.getSelection()) {
                    e.gc.setBackground(Display.getDefault().getSystemColor(1));
                } else {
                    e.gc.setBackground(Display.getDefault().getSystemColor(2));
                }
                e.gc.fillRectangle(0, 0, sCanvas.getBounds().width, sCanvas.getBounds().height);
                if (sImage != null) {
                    int width = sImage.getBounds().width;
                    int height = sImage.getBounds().height;
                    int x = (sCanvas.getBounds().width - width) / 2;
                    int y = (sCanvas.getBounds().height - height) / 2;
                    e.gc.drawImage(sImage, x, y);
                    if (sShowExtras.getSelection()) {
                        if ((sViewNode.paddingLeft | sViewNode.paddingRight | sViewNode.paddingTop | sViewNode.paddingBottom) != 0) {
                            e.gc.setForeground(Display.getDefault().getSystemColor(9));
                            e.gc.drawRectangle(x + sViewNode.paddingLeft, y + sViewNode.paddingTop, width - sViewNode.paddingLeft - sViewNode.paddingRight - 1, height - sViewNode.paddingTop - sViewNode.paddingBottom - 1);
                        }
                        if (sViewNode.hasMargins) {
                            e.gc.setForeground(Display.getDefault().getSystemColor(5));
                            e.gc.drawRectangle(x - sViewNode.marginLeft, y - sViewNode.marginTop, width + sViewNode.marginLeft + sViewNode.marginRight - 1, height + sViewNode.marginTop + sViewNode.marginBottom - 1);
                        }
                        if (sViewNode.baseline != -1) {
                            e.gc.setForeground(Display.getDefault().getSystemColor(3));
                            e.gc.drawLine(x, y + sViewNode.baseline, x + width - 1, sViewNode.baseline);
                        }
                    }
                }
            }
        };
        sShellListener = new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                e.doit = false;
                sShell.setVisible(false);
                if (sViewNode != null) {
                    sViewNode.dereferenceImage();
                }
            }
        };
        sWhiteSelectionListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                sOnWhite.setSelection(true);
                sOnBlack.setSelection(false);
                sCanvas.redraw();
            }
        };
        sBlackSelectionListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                sOnBlack.setSelection(true);
                sOnWhite.setSelection(false);
                sCanvas.redraw();
            }
        };
        sExtrasSelectionListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                sCanvas.redraw();
            }
        };
    }
}

