/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.syntax;

import com.google.clearsilver.jsilver.autoescape.EscapeMode;
import com.google.clearsilver.jsilver.exceptions.JSilverIOException;
import com.google.clearsilver.jsilver.syntax.SyntaxTreeBuilder;
import com.google.clearsilver.jsilver.syntax.TemplateSyntaxTree;
import com.google.clearsilver.jsilver.syntax.analysis.DepthFirstAdapter;
import com.google.clearsilver.jsilver.syntax.node.EOF;
import com.google.clearsilver.jsilver.syntax.node.Node;
import com.google.clearsilver.jsilver.syntax.node.Start;
import com.google.clearsilver.jsilver.syntax.node.Token;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;

public class SyntaxTreeDumper
extends DepthFirstAdapter {
    private final Appendable out;
    private final String newLine = System.getProperty("line.separator");
    private int indent;

    public SyntaxTreeDumper(Appendable out) {
        this.out = out;
    }

    public SyntaxTreeDumper() {
        this(System.out);
    }

    public void defaultIn(Node node) {
        this.write(this.nodeName(node) + " {");
        ++this.indent;
    }

    public void defaultOut(Node node) {
        --this.indent;
        this.write("}");
    }

    public void defaultCase(Node node) {
        this.write(this.nodeName(node));
    }

    private String nodeName(Node node) {
        if (node instanceof Start || node instanceof EOF) {
            return node.getClass().getSimpleName();
        }
        if (node instanceof Token) {
            Token token = (Token)node;
            String tokenType = token.getClass().getSimpleName().substring(1);
            return tokenType + " [line:" + token.getLine() + ",pos:" + token.getPos() + "] \"" + this.escape(token.getText()) + "\"";
        }
        String p = node.getClass().getSuperclass().getSimpleName().substring(1);
        String a = node.getClass().getSimpleName().substring(1);
        a = a.substring(0, a.length() - p.length());
        return "<" + a + ">" + p;
    }

    private String escape(String text) {
        StringBuilder result = new StringBuilder();
        block7: for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '\\': {
                    result.append("\\\\");
                    continue block7;
                }
                case '\"': {
                    result.append("\\\"");
                    continue block7;
                }
                case '\n': {
                    result.append("\\n");
                    continue block7;
                }
                case '\r': {
                    result.append("\\r");
                    continue block7;
                }
                case '\t': {
                    result.append("\\t");
                    continue block7;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    private void write(String text) {
        try {
            StringBuilder line = new StringBuilder();
            for (int i = 0; i < this.indent; ++i) {
                line.append("  ");
            }
            line.append(text);
            line.append(this.newLine);
            this.out.append(line);
        }
        catch (IOException e) {
            throw new JSilverIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.err.println("Provide filename of template.");
            return;
        }
        String filename = args[0];
        BufferedReader reader = new BufferedReader(new FileReader(filename));
        try {
            SyntaxTreeBuilder builder = new SyntaxTreeBuilder();
            TemplateSyntaxTree tree = builder.parse(reader, filename, EscapeMode.ESCAPE_NONE);
            tree.apply(new SyntaxTreeDumper(System.out));
        }
        finally {
            ((Reader)reader).close();
        }
    }
}

