/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.interpreter;

import com.google.clearsilver.jsilver.autoescape.EscapeMode;
import com.google.clearsilver.jsilver.data.Data;
import com.google.clearsilver.jsilver.data.DataContext;
import com.google.clearsilver.jsilver.exceptions.ExceptionUtil;
import com.google.clearsilver.jsilver.exceptions.JSilverIOException;
import com.google.clearsilver.jsilver.exceptions.JSilverInterpreterException;
import com.google.clearsilver.jsilver.functions.FunctionExecutor;
import com.google.clearsilver.jsilver.interpreter.ExpressionEvaluator;
import com.google.clearsilver.jsilver.interpreter.InterpretedMacro;
import com.google.clearsilver.jsilver.interpreter.VariableLocator;
import com.google.clearsilver.jsilver.syntax.analysis.DepthFirstAdapter;
import com.google.clearsilver.jsilver.syntax.node.AAltCommand;
import com.google.clearsilver.jsilver.syntax.node.AAutoescapeCommand;
import com.google.clearsilver.jsilver.syntax.node.ACallCommand;
import com.google.clearsilver.jsilver.syntax.node.ADataCommand;
import com.google.clearsilver.jsilver.syntax.node.ADefCommand;
import com.google.clearsilver.jsilver.syntax.node.AEachCommand;
import com.google.clearsilver.jsilver.syntax.node.AEscapeCommand;
import com.google.clearsilver.jsilver.syntax.node.AEvarCommand;
import com.google.clearsilver.jsilver.syntax.node.AHardIncludeCommand;
import com.google.clearsilver.jsilver.syntax.node.AHardLincludeCommand;
import com.google.clearsilver.jsilver.syntax.node.AIfCommand;
import com.google.clearsilver.jsilver.syntax.node.AIncludeCommand;
import com.google.clearsilver.jsilver.syntax.node.ALincludeCommand;
import com.google.clearsilver.jsilver.syntax.node.ALoopCommand;
import com.google.clearsilver.jsilver.syntax.node.ALoopIncCommand;
import com.google.clearsilver.jsilver.syntax.node.ALoopToCommand;
import com.google.clearsilver.jsilver.syntax.node.ALvarCommand;
import com.google.clearsilver.jsilver.syntax.node.ANameCommand;
import com.google.clearsilver.jsilver.syntax.node.ANameVariable;
import com.google.clearsilver.jsilver.syntax.node.ASetCommand;
import com.google.clearsilver.jsilver.syntax.node.AUvarCommand;
import com.google.clearsilver.jsilver.syntax.node.AVarCommand;
import com.google.clearsilver.jsilver.syntax.node.AWithCommand;
import com.google.clearsilver.jsilver.syntax.node.PCommand;
import com.google.clearsilver.jsilver.syntax.node.PExpression;
import com.google.clearsilver.jsilver.syntax.node.PPosition;
import com.google.clearsilver.jsilver.syntax.node.PVariable;
import com.google.clearsilver.jsilver.syntax.node.TCsOpen;
import com.google.clearsilver.jsilver.syntax.node.TWord;
import com.google.clearsilver.jsilver.template.Macro;
import com.google.clearsilver.jsilver.template.RenderingContext;
import com.google.clearsilver.jsilver.template.Template;
import com.google.clearsilver.jsilver.template.TemplateLoader;
import com.google.clearsilver.jsilver.values.Value;
import com.google.clearsilver.jsilver.values.VariableValue;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateInterpreter
extends DepthFirstAdapter {
    private final Template template;
    private final ExpressionEvaluator expressionEvaluator;
    private final VariableLocator variableLocator;
    private final TemplateLoader templateLoader;
    private final RenderingContext context;
    private final DataContext dataContext;

    public TemplateInterpreter(Template template, TemplateLoader templateLoader, RenderingContext context, FunctionExecutor functionExecutor) {
        this.template = template;
        this.templateLoader = templateLoader;
        this.context = context;
        this.dataContext = context.getDataContext();
        this.expressionEvaluator = new ExpressionEvaluator(this.dataContext, functionExecutor);
        this.variableLocator = new VariableLocator(this.expressionEvaluator);
    }

    @Override
    public void caseADataCommand(ADataCommand node) {
        this.context.writeUnescaped(node.getData().getText());
    }

    @Override
    public void caseAVarCommand(AVarCommand node) {
        this.setLastPosition(node.getPosition());
        Value value = this.expressionEvaluator.evaluate(node.getExpression());
        this.writeVariable(value);
    }

    @Override
    public void caseAUvarCommand(AUvarCommand node) {
        this.setLastPosition(node.getPosition());
        Value value = this.expressionEvaluator.evaluate(node.getExpression());
        this.context.writeUnescaped(value.asString());
    }

    @Override
    public void caseALvarCommand(ALvarCommand node) {
        this.setLastPosition(node.getPosition());
        this.evaluateVariable(node.getExpression(), "[lvar expression]");
    }

    @Override
    public void caseAEvarCommand(AEvarCommand node) {
        this.setLastPosition(node.getPosition());
        this.evaluateVariable(node.getExpression(), "[evar expression]");
    }

    private void evaluateVariable(PExpression expression, String stackTraceDescription) {
        Value value = this.expressionEvaluator.evaluate(expression);
        Template template = this.templateLoader.createTemp(stackTraceDescription, value.asString(), this.context.getAutoEscapeMode());
        try {
            template.render(this.context);
        }
        catch (IOException e) {
            throw new JSilverInterpreterException(e.getMessage());
        }
    }

    @Override
    public void caseAHardLincludeCommand(AHardLincludeCommand node) {
        this.setLastPosition(node.getPosition());
        this.include(node.getExpression(), false);
    }

    @Override
    public void caseALincludeCommand(ALincludeCommand node) {
        this.setLastPosition(node.getPosition());
        this.include(node.getExpression(), true);
    }

    @Override
    public void caseAHardIncludeCommand(AHardIncludeCommand node) {
        this.setLastPosition(node.getPosition());
        this.include(node.getExpression(), false);
    }

    @Override
    public void caseAIncludeCommand(AIncludeCommand node) {
        this.setLastPosition(node.getPosition());
        this.include(node.getExpression(), true);
    }

    @Override
    public void caseASetCommand(ASetCommand node) {
        this.setLastPosition(node.getPosition());
        String variableName = this.variableLocator.getVariableName(node.getVariable());
        try {
            Data variable = this.dataContext.findVariable(variableName, true);
            Value value = this.expressionEvaluator.evaluate(node.getExpression());
            variable.setValue(value.asString());
            variable.setEscapeMode(value.getEscapeMode());
        }
        catch (UnsupportedOperationException e) {
            throw new UnsupportedOperationException(this.createUnsupportedOperationMessage(node, this.context.getIncludedTemplateNames()), e);
        }
    }

    @Override
    public void caseANameCommand(ANameCommand node) {
        this.setLastPosition(node.getPosition());
        String variableName = this.variableLocator.getVariableName(node.getVariable());
        Data variable = this.dataContext.findVariable(variableName, false);
        if (variable != null) {
            this.context.writeEscaped(variable.getSymlink().getName());
        }
    }

    @Override
    public void caseAIfCommand(AIfCommand node) {
        this.setLastPosition(node.getPosition());
        Value value = this.expressionEvaluator.evaluate(node.getExpression());
        if (value.asBoolean()) {
            node.getBlock().apply(this);
        } else {
            node.getOtherwise().apply(this);
        }
    }

    @Override
    public void caseAEscapeCommand(AEscapeCommand node) {
        this.setLastPosition(node.getPosition());
        Value value = this.expressionEvaluator.evaluate(node.getExpression());
        String escapeStrategy = value.asString();
        this.context.pushEscapingFunction(escapeStrategy);
        node.getCommand().apply(this);
        this.context.popEscapingFunction();
    }

    @Override
    public void caseAAutoescapeCommand(AAutoescapeCommand node) {
        this.setLastPosition(node.getPosition());
        Value value = this.expressionEvaluator.evaluate(node.getExpression());
        String escapeStrategy = value.asString();
        EscapeMode mode = EscapeMode.computeEscapeMode(escapeStrategy);
        this.context.pushAutoEscapeMode(mode);
        node.getCommand().apply(this);
        this.context.popAutoEscapeMode();
    }

    @Override
    public void caseAWithCommand(AWithCommand node) {
        this.setLastPosition(node.getPosition());
        VariableLocator variableLocator = new VariableLocator(this.expressionEvaluator);
        String withVar = variableLocator.getVariableName(node.getVariable());
        Value value = this.expressionEvaluator.evaluate(node.getExpression());
        if (value instanceof VariableValue && ((VariableValue)value).getReference() == null) {
            return;
        }
        this.dataContext.pushVariableScope();
        this.setTempVariable(withVar, value);
        node.getCommand().apply(this);
        this.dataContext.popVariableScope();
    }

    @Override
    public void caseALoopToCommand(ALoopToCommand node) {
        this.setLastPosition(node.getPosition());
        int end = this.expressionEvaluator.evaluate(node.getExpression()).asNumber();
        if (end < 0) {
            return;
        }
        this.loop(node.getVariable(), 0, end, 1, node.getCommand());
    }

    @Override
    public void caseALoopCommand(ALoopCommand node) {
        this.setLastPosition(node.getPosition());
        int start = this.expressionEvaluator.evaluate(node.getStart()).asNumber();
        int end = this.expressionEvaluator.evaluate(node.getEnd()).asNumber();
        if (end < start) {
            return;
        }
        this.loop(node.getVariable(), start, end, 1, node.getCommand());
    }

    @Override
    public void caseALoopIncCommand(ALoopIncCommand node) {
        this.setLastPosition(node.getPosition());
        int start = this.expressionEvaluator.evaluate(node.getStart()).asNumber();
        int end = this.expressionEvaluator.evaluate(node.getEnd()).asNumber();
        int incr = this.expressionEvaluator.evaluate(node.getIncrement()).asNumber();
        if (incr == 0) {
            return;
        }
        if (incr > 0 && start > end) {
            return;
        }
        if (incr < 0 && start < end) {
            return;
        }
        this.loop(node.getVariable(), start, end, incr, node.getCommand());
    }

    @Override
    public void caseAEachCommand(AEachCommand node) {
        VariableValue variableValue;
        Data parent;
        this.setLastPosition(node.getPosition());
        Value expression = this.expressionEvaluator.evaluate(node.getExpression());
        if (expression instanceof VariableValue && (parent = (variableValue = (VariableValue)expression).getReference()) != null) {
            this.each(node.getVariable(), variableValue.getName(), parent, node.getCommand());
        }
    }

    @Override
    public void caseAAltCommand(AAltCommand node) {
        this.setLastPosition(node.getPosition());
        Value value = this.expressionEvaluator.evaluate(node.getExpression());
        if (value.asBoolean()) {
            this.writeVariable(value);
        } else {
            node.getCommand().apply(this);
        }
    }

    private void writeVariable(Value value) {
        if (this.template.getEscapeMode().isAutoEscapingMode()) {
            this.autoEscapeAndWriteVariable(value);
        } else if (value.isPartiallyEscaped()) {
            this.context.writeUnescaped(value.asString());
        } else {
            this.context.writeEscaped(value.asString());
        }
    }

    private void autoEscapeAndWriteVariable(Value value) {
        if (this.isTrustedValue(value) || value.isPartiallyEscaped()) {
            this.context.writeUnescaped(value.asString());
        } else {
            this.context.writeEscaped(value.asString());
        }
    }

    private boolean isTrustedValue(Value value) {
        return this.context.getAutoEscapeOptions().getPropagateEscapeStatus() && !value.getEscapeMode().equals((Object)EscapeMode.ESCAPE_NONE);
    }

    @Override
    public void caseADefCommand(ADefCommand node) {
        String macroName = this.makeWord(node.getMacro());
        LinkedList<PVariable> arguments = node.getArguments();
        String[] argumentNames = new String[arguments.size()];
        int i = 0;
        for (PVariable argument : arguments) {
            if (!(argument instanceof ANameVariable)) {
                throw new JSilverInterpreterException("Invalid name for macro '" + macroName + "' argument " + i + " : " + argument);
            }
            argumentNames[i++] = ((ANameVariable)argument).getWord().getText();
        }
        this.context.registerMacro(macroName, new InterpretedMacro(node.getCommand(), this.template, macroName, argumentNames, this, this.context));
    }

    private String makeWord(LinkedList<TWord> words) {
        if (words.size() == 1) {
            return words.getFirst().getText();
        }
        StringBuilder result = new StringBuilder();
        for (TWord word : words) {
            if (result.length() > 0) {
                result.append('.');
            }
            result.append(word.getText());
        }
        return result.toString();
    }

    @Override
    public void caseACallCommand(ACallCommand node) {
        String macroName = this.makeWord(node.getMacro());
        Macro macro = this.context.findMacro(macroName);
        if (node.getArguments().size() != macro.getArgumentCount()) {
            throw new JSilverInterpreterException("Number of arguments to macro " + macroName + " (" + node.getArguments().size() + ") does not match " + "number of expected arguments (" + macro.getArgumentCount() + ")");
        }
        int numArgs = node.getArguments().size();
        if (numArgs > 0) {
            Value[] argValues = new Value[numArgs];
            Iterator argumentValues = node.getArguments().iterator();
            int i = 0;
            while (argumentValues.hasNext()) {
                argValues[i] = this.expressionEvaluator.evaluate((PExpression)argumentValues.next());
                ++i;
            }
            this.dataContext.pushVariableScope();
            for (i = 0; i < argValues.length; ++i) {
                this.setTempVariable(macro.getArgumentName(i), argValues[i]);
            }
        }
        try {
            macro.render(this.context);
        }
        catch (IOException e) {
            throw new JSilverIOException(e);
        }
        if (numArgs > 0) {
            this.dataContext.popVariableScope();
        }
    }

    private void each(PVariable variable, String parentName, Data items, PCommand command) {
        VariableLocator variableLocator = new VariableLocator(this.expressionEvaluator);
        String eachVar = variableLocator.getVariableName(variable);
        StringBuilder pathBuilder = new StringBuilder(parentName);
        pathBuilder.append('.');
        int length = pathBuilder.length();
        this.dataContext.pushVariableScope();
        for (Data data : items.getChildren()) {
            pathBuilder.delete(length, pathBuilder.length());
            pathBuilder.append(data.getName());
            this.setTempVariable(eachVar, Value.variableValue(pathBuilder.toString(), this.dataContext));
            command.apply(this);
        }
        this.dataContext.popVariableScope();
    }

    private void loop(PVariable loopVar, int start, int end, int incr, PCommand command) {
        VariableLocator variableLocator = new VariableLocator(this.expressionEvaluator);
        String varName = variableLocator.getVariableName(loopVar);
        this.dataContext.pushVariableScope();
        int index = start;
        while (incr > 0 ? index <= end : index >= end) {
            this.dataContext.createLocalVariableByValue(varName, String.valueOf(index), index == start, index == end);
            command.apply(this);
            index += incr;
        }
        this.dataContext.popVariableScope();
    }

    private void include(PExpression expression, boolean ignoreMissingFile) {
        Value path = this.expressionEvaluator.evaluate(expression);
        String templateName = path.asString();
        if (!this.context.pushIncludeStackEntry(templateName)) {
            throw new JSilverInterpreterException(this.createIncludeLoopErrorMessage(templateName, this.context.getIncludedTemplateNames()));
        }
        this.loadAndRenderIncludedTemplate(templateName, ignoreMissingFile);
        if (!this.context.popIncludeStackEntry(templateName)) {
            throw new IllegalStateException("Unable to find on include stack: " + templateName);
        }
    }

    private String createIncludeLoopErrorMessage(String templateName, Iterable<String> includeStack) {
        StringBuilder message = new StringBuilder();
        message.append("File included twice: ");
        message.append(templateName);
        message.append(" Include stack:");
        for (String fileName : includeStack) {
            message.append("\n -> ");
            message.append(fileName);
        }
        message.append("\n -> ");
        message.append(templateName);
        return message.toString();
    }

    private String createUnsupportedOperationMessage(PCommand node, Iterable<String> includeStack) {
        StringBuilder message = new StringBuilder();
        message.append("exception thrown while parsing node: ");
        message.append(node.toString());
        message.append(" (class ").append(node.getClass().getSimpleName()).append(")");
        message.append("\nTemplate include stack: ");
        Iterator<String> iter = includeStack.iterator();
        while (iter.hasNext()) {
            message.append(iter.next());
            if (!iter.hasNext()) continue;
            message.append(" -> ");
        }
        message.append("\n");
        return message.toString();
    }

    private void loadAndRenderIncludedTemplate(String templateName, boolean ignoreMissingFile) {
        Template template = null;
        try {
            template = this.templateLoader.load(templateName, this.context.getResourceLoader(), this.context.getAutoEscapeMode());
        }
        catch (RuntimeException e) {
            if (ignoreMissingFile && ExceptionUtil.isFileNotFoundException(e)) {
                return;
            }
            throw e;
        }
        try {
            template.render(this.context);
        }
        catch (IOException e) {
            throw new JSilverInterpreterException(e.getMessage());
        }
    }

    private void setLastPosition(PPosition position) {
        position.apply(this);
    }

    @Override
    public void caseTCsOpen(TCsOpen node) {
        int line = node.getLine();
        int column = node.getPos();
        this.context.setCurrentPosition(line, column);
    }

    private void setTempVariable(String variableName, Value value) {
        if (value instanceof VariableValue) {
            this.dataContext.createLocalVariableByPath(variableName, ((VariableValue)value).getName());
        } else {
            this.dataContext.createLocalVariableByValue(variableName, value.asString(), value.getEscapeMode());
        }
    }
}

