/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.functions.escape;

import com.google.clearsilver.jsilver.functions.TextFilter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class UrlEscapeFunction
implements TextFilter {
    private final String encoding;

    public UrlEscapeFunction(String encoding) {
        try {
            new OutputStreamWriter((OutputStream)new ByteArrayOutputStream(), encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Unsupported encoding : " + encoding);
        }
        this.encoding = encoding;
    }

    public void filter(String in, Appendable out) throws IOException {
        try {
            out.append(URLEncoder.encode(in, this.encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("Unsuported encoding : " + this.encoding);
        }
    }
}

