/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.data;

import com.google.clearsilver.jsilver.data.Data;
import com.google.clearsilver.jsilver.data.Parser;
import com.google.clearsilver.jsilver.data.ParserFactory;
import com.google.clearsilver.jsilver.data.StringInternStrategy;
import com.google.clearsilver.jsilver.data.UniqueStack;
import com.google.clearsilver.jsilver.resourceloader.ResourceLoader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewHdfParser
implements Parser {
    private final StringInternStrategy internStrategy;
    static final String UNNAMED_INPUT = "[UNNAMED_INPUT]";
    private static final String INCLUDE_WS = "#include ";
    private static final int NO_MATCH = -1;
    private static final String DEFAULT_ATTR_VALUE = "1";

    public NewHdfParser(StringInternStrategy internPool) {
        this.internStrategy = internPool;
    }

    public static ParserFactory newFactory(StringInternStrategy stringInternStrategy) {
        return new NewHdfParserFactory(stringInternStrategy);
    }

    @Override
    public void parse(Reader reader, Data output, Parser.ErrorHandler errorHandler, ResourceLoader resourceLoader, String dataFileName, boolean ignoreAttributes) throws IOException {
        this.parse(ParseState.createNewParseState(output, reader, errorHandler, resourceLoader, this, dataFileName, ignoreAttributes));
    }

    private void parse(ParseState state) throws IOException {
        while ((state.line = state.lineReader.readLine()) != null) {
            String seq = NewHdfParser.stripWhitespace(state.line);
            try {
                this.parseCommand(seq, state);
            }
            catch (OutOfCharsException e) {
                NewHdfParser.reportError(state, "End of line was prematurely reached. Parse error.");
            }
        }
    }

    private void parseCommand(String seq, ParseState state) throws IOException, OutOfCharsException {
        if (seq.length() == 0) {
            return;
        }
        if (NewHdfParser.charAt(seq, 0) == '#') {
            if (NewHdfParser.matches(seq, 0, INCLUDE_WS)) {
                int start = NewHdfParser.skipLeadingWhitespace(seq, INCLUDE_WS.length());
                this.parseInclude(seq, start, state);
            }
            return;
        }
        if (NewHdfParser.charAt(seq, 0) == '}') {
            if (NewHdfParser.skipLeadingWhitespace(seq, 1) != seq.length()) {
                NewHdfParser.reportError(state, "Extra chars after '}'");
                return;
            }
            this.handleAscend(state);
        } else {
            this.parseHdfElement(seq, state);
        }
    }

    private void parseInclude(String seq, int start, ParseState state) throws IOException, OutOfCharsException {
        int end = seq.length();
        if (NewHdfParser.charAt(seq, start) == '\"') {
            if (NewHdfParser.charAt(seq, end - 1) == '\"') {
                ++start;
                --end;
            } else {
                NewHdfParser.reportError(state, "Missing '\"' at end of include");
                return;
            }
        }
        this.handleInclude(seq.substring(start, end), state);
    }

    private void parseHdfElement(String seq, ParseState state) throws IOException, OutOfCharsException {
        HdfNameAttrs element = state.hdfNameAttrs;
        if (!this.parseHdfNameAttrs(element, seq, 0, state)) {
            return;
        }
        int index = NewHdfParser.skipLeadingWhitespace(seq, element.endOfSequence);
        switch (NewHdfParser.charAt(seq, index)) {
            case '{': {
                if (index + 1 != seq.length()) {
                    NewHdfParser.reportError(state, "No characters expected after '{'");
                    return;
                }
                this.handleDescend(state, element);
                return;
            }
            case '=': {
                index = NewHdfParser.skipLeadingWhitespace(seq, index + 1);
                String value = this.internStrategy.intern(seq.substring(index, seq.length()));
                this.handleAssign(state, element, value);
                return;
            }
            case ':': {
                if (NewHdfParser.charAt(seq, index + 1) == '=') {
                    String src = this.parseHdfName(seq, index = NewHdfParser.skipLeadingWhitespace(seq, index + 2));
                    if (src == null) {
                        NewHdfParser.reportError(state, "Invalid HDF name");
                        return;
                    }
                    if (index + src.length() != seq.length()) {
                        NewHdfParser.reportError(state, "No characters expected after '{'");
                        return;
                    }
                    this.handleCopy(state, element, src);
                } else {
                    String src = this.parseHdfName(seq, index = NewHdfParser.skipLeadingWhitespace(seq, index + 1));
                    if (src == null) {
                        NewHdfParser.reportError(state, "Invalid HDF name");
                        return;
                    }
                    if (index + src.length() != seq.length()) {
                        NewHdfParser.reportError(state, "No characters expected after '{'");
                        return;
                    }
                    this.handleLink(state, element, src);
                }
                return;
            }
            case '<': {
                String eomMarker;
                String multilineValue;
                if (NewHdfParser.charAt(seq, index + 1) != '<') {
                    NewHdfParser.reportError(state, "Expected '<<'");
                }
                if ((multilineValue = this.internStrategy.intern(this.parseMultilineValue(state, eomMarker = seq.substring(index = NewHdfParser.skipLeadingWhitespace(seq, index + 2), seq.length())))) == null) {
                    return;
                }
                this.handleAssign(state, element, multilineValue);
                return;
            }
        }
        NewHdfParser.reportError(state, "No valid operator");
    }

    private boolean parseHdfNameAttrs(HdfNameAttrs destination, String seq, int index, ParseState state) throws OutOfCharsException {
        String hdfName = this.parseHdfName(seq, index);
        if (hdfName == null) {
            NewHdfParser.reportError(state, "Invalid HDF name");
            return false;
        }
        destination.reset(hdfName);
        index = NewHdfParser.skipLeadingWhitespace(seq, index + hdfName.length());
        int end = this.parseAttributes(seq, index, state, destination);
        if (end == -1) {
            return false;
        }
        destination.endOfSequence = end;
        return true;
    }

    private String parseHdfName(String seq, int index) throws OutOfCharsException {
        int end;
        for (end = index; end < seq.length() && NewHdfParser.isHdfNameChar(NewHdfParser.charAt(seq, end)); ++end) {
        }
        if (end == index) {
            return null;
        }
        return this.internStrategy.intern(seq.substring(index, end));
    }

    private int parseAttributes(String seq, int index, ParseState state, HdfNameAttrs element) throws OutOfCharsException {
        if (NewHdfParser.charAt(seq, index) != '[') {
            return index;
        }
        index = NewHdfParser.skipLeadingWhitespace(seq, index + 1);
        if (state.ignoreAttributes) {
            while (NewHdfParser.charAt(seq, index) != ']') {
                ++index;
            }
            return index + 1;
        }
        boolean first = true;
        do {
            if (first) {
                first = false;
            } else if (NewHdfParser.charAt(seq, index) == ',') {
                index = NewHdfParser.skipLeadingWhitespace(seq, index + 1);
            } else {
                NewHdfParser.reportError(state, "Error parsing attribute list");
            }
            index = this.parseAttribute(seq, index, state, element);
            if (index != -1) continue;
            return -1;
        } while (NewHdfParser.charAt(seq, index = NewHdfParser.skipLeadingWhitespace(seq, index)) != ']');
        return index + 1;
    }

    private int parseAttribute(String seq, int index, ParseState state, HdfNameAttrs element) throws OutOfCharsException {
        int end = this.parseAttributeKey(seq, index);
        if (index == end) {
            NewHdfParser.reportError(state, "No valid attribute key");
            return -1;
        }
        String attrKey = this.internStrategy.intern(seq.substring(index, end));
        index = NewHdfParser.skipLeadingWhitespace(seq, end);
        if (NewHdfParser.charAt(seq, index) != '=') {
            element.addAttribute(attrKey, DEFAULT_ATTR_VALUE);
            return index;
        }
        if (NewHdfParser.charAt(seq, index = NewHdfParser.skipLeadingWhitespace(seq, index + 1)) == '\"') {
            StringBuilder sb = new StringBuilder();
            if ((end = this.parseQuotedAttributeValue(seq, ++index, sb)) == -1) {
                NewHdfParser.reportError(state, "Unable to parse quoted attribute value");
                return -1;
            }
            String attrValue = this.internStrategy.intern(sb.toString());
            element.addAttribute(attrKey, attrValue);
            ++end;
        } else {
            String attrValue = this.parseAttributeValue(seq, index, state);
            if (attrValue == null || attrValue.length() == 0) {
                NewHdfParser.reportError(state, "No attribute for key " + attrKey);
                return -1;
            }
            attrValue = this.internStrategy.intern(attrValue);
            element.addAttribute(attrKey, attrValue);
            end = index + attrValue.length();
        }
        return end;
    }

    private int parseAttributeKey(String seq, int index) throws OutOfCharsException {
        while (NewHdfParser.isAlphaNumericChar(NewHdfParser.charAt(seq, index))) {
            ++index;
        }
        return index;
    }

    private int parseQuotedAttributeValue(String seq, int index, StringBuilder sb) throws OutOfCharsException {
        int c;
        while ((c = NewHdfParser.charAt(seq, index)) != 34) {
            if (c == 92) {
                char next;
                if (NewHdfParser.isNumericChar(next = NewHdfParser.charAt(seq, ++index))) {
                    int val = next - 48;
                    if (NewHdfParser.isNumericChar(NewHdfParser.charAt(seq, index + 1))) {
                        val = val * 8 + (NewHdfParser.charAt(seq, ++index) - 48);
                        if (NewHdfParser.isNumericChar(NewHdfParser.charAt(seq, index + 1))) {
                            val = val * 8 + (NewHdfParser.charAt(seq, ++index) - 48);
                        }
                    }
                    c = (char)val;
                } else {
                    c = next == 'n' ? 10 : (next == 't' ? 9 : (next == 'r' ? 13 : (int)next));
                }
            }
            sb.append((char)c);
            ++index;
        }
        return index;
    }

    private String parseAttributeValue(String seq, int index, ParseState state) throws OutOfCharsException {
        int end = index;
        char c = NewHdfParser.charAt(seq, end);
        while (c != ',' && c != ']' && c != '\"' && !Character.isWhitespace(c)) {
            c = NewHdfParser.charAt(seq, ++end);
        }
        return seq.substring(index, end);
    }

    private String parseMultilineValue(ParseState state, String eomMarker) throws IOException {
        String line;
        StringBuilder sb = new StringBuilder(256);
        while ((line = state.lineReader.readLine()) != null) {
            if (line.startsWith(eomMarker) && NewHdfParser.skipLeadingWhitespace(line, eomMarker.length()) == line.length()) {
                return sb.toString();
            }
            sb.append(line).append('\n');
        }
        NewHdfParser.reportError(state, "EOM " + eomMarker + " never found");
        return null;
    }

    private void handleDescend(ParseState state, HdfNameAttrs element) {
        Data child = this.handleNodeCreation(state.currentNode, element);
        state.context.push(state.currentNode);
        state.currentNode = child;
    }

    private Data handleNodeCreation(Data node, HdfNameAttrs element) {
        return element.toData(node);
    }

    private void handleAssign(ParseState state, HdfNameAttrs element, String value) {
        Data child = this.handleNodeCreation(state.currentNode, element);
        child.setValue(value);
    }

    private void handleCopy(ParseState state, HdfNameAttrs element, String srcName) {
        Data child = this.handleNodeCreation(state.currentNode, element);
        Data src = state.output.getChild(srcName);
        if (src != null) {
            child.setValue(src.getValue());
        } else {
            child.setValue("");
        }
    }

    private void handleLink(ParseState state, HdfNameAttrs element, String srcName) {
        Data child = this.handleNodeCreation(state.currentNode, element);
        child.setSymlink(state.output.createChild(srcName));
    }

    private void handleAscend(ParseState state) {
        if (state.context.isEmpty()) {
            NewHdfParser.reportError(state, "Too many '}'");
            return;
        }
        state.currentNode = state.context.pop();
    }

    private void handleInclude(String seq, ParseState state) throws IOException {
        String includeFileName = this.internStrategy.intern(seq);
        Reader reader = state.resourceLoader.open(includeFileName);
        if (reader == null) {
            NewHdfParser.reportError(state, "Unable to find file " + includeFileName);
            return;
        }
        if (!state.includeStack.push(includeFileName)) {
            NewHdfParser.reportError(state, this.createIncludeStackTraceMessage(state.includeStack, includeFileName));
            return;
        }
        state.hdfParser.parse(ParseState.createParseStateForIncludedFile(state, includeFileName, reader));
        if (!includeFileName.equals(state.includeStack.pop())) {
            throw new IllegalStateException("Unable to find on include stack: " + includeFileName);
        }
    }

    private String createIncludeStackTraceMessage(UniqueStack<String> includeStack, String includeFileName) {
        StringBuilder message = new StringBuilder();
        message.append("File included twice: ");
        message.append(includeFileName);
        message.append(" Include stack: ");
        for (String fileName : includeStack) {
            message.append(fileName);
            message.append(" -> ");
        }
        message.append(includeFileName);
        return message.toString();
    }

    private static boolean isNumericChar(char c) {
        return '0' <= c && c <= '9';
    }

    private static boolean isAlphaNumericChar(char c) {
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9';
    }

    private static boolean isHdfNameChar(char c) {
        return NewHdfParser.isAlphaNumericChar(c) || c == '_' || c == '.';
    }

    private static String stripWhitespace(String seq) {
        int end;
        int start = NewHdfParser.skipLeadingWhitespace(seq, 0);
        for (end = seq.length() - 1; end > start && Character.isWhitespace(seq.charAt(end)); --end) {
        }
        if (start == 0 && end == seq.length() - 1) {
            return seq;
        }
        return seq.substring(start, end + 1);
    }

    private static int skipLeadingWhitespace(String seq, int index) {
        while (index < seq.length() && Character.isWhitespace(seq.charAt(index))) {
            ++index;
        }
        return index;
    }

    private static boolean matches(String seq, int start, String match) {
        if (seq.length() - start < match.length()) {
            return false;
        }
        for (int i = 0; i < match.length(); ++i) {
            if (match.charAt(i) == seq.charAt(start + i)) continue;
            return false;
        }
        return true;
    }

    private static char charAt(String seq, int index) throws OutOfCharsException {
        if (0 <= index && index < seq.length()) {
            return seq.charAt(index);
        }
        throw new OutOfCharsException();
    }

    private static void reportError(ParseState state, String errorMessage) {
        if (state.errorHandler == null) {
            throw new RuntimeException("Parse Error on line " + state.lineReader.getLineNumber() + ": " + errorMessage + " : " + state.line);
        }
        state.errorHandler.error(state.lineReader.getLineNumber(), state.line, state.parsedFileName, errorMessage);
    }

    private static class NewHdfParserFactory
    implements ParserFactory {
        private final StringInternStrategy stringInternStrategy;

        public NewHdfParserFactory(StringInternStrategy stringInternStrategy) {
            this.stringInternStrategy = stringInternStrategy;
        }

        public Parser newInstance() {
            return new NewHdfParser(this.stringInternStrategy);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ParseState {
        final Stack<Data> context = new Stack();
        final Data output;
        final LineNumberReader lineReader;
        final Parser.ErrorHandler errorHandler;
        final ResourceLoader resourceLoader;
        final NewHdfParser hdfParser;
        final boolean ignoreAttributes;
        final HdfNameAttrs hdfNameAttrs;
        final UniqueStack<String> includeStack;
        final String parsedFileName;
        String line;
        Data currentNode;

        private ParseState(Data output, LineNumberReader lineReader, Parser.ErrorHandler errorHandler, ResourceLoader resourceLoader, NewHdfParser hdfParser, String parsedFileName, boolean ignoreAttributes, HdfNameAttrs hdfNameAttrs, UniqueStack<String> includeStack) {
            this.lineReader = lineReader;
            this.errorHandler = errorHandler;
            this.output = output;
            this.currentNode = output;
            this.resourceLoader = resourceLoader;
            this.hdfParser = hdfParser;
            this.parsedFileName = parsedFileName;
            this.ignoreAttributes = ignoreAttributes;
            this.hdfNameAttrs = hdfNameAttrs;
            this.includeStack = includeStack;
        }

        public static ParseState createNewParseState(Data output, Reader reader, Parser.ErrorHandler errorHandler, ResourceLoader resourceLoader, NewHdfParser hdfParser, String parsedFileName, boolean ignoreAttributes) {
            if (parsedFileName == null) {
                parsedFileName = NewHdfParser.UNNAMED_INPUT;
            }
            UniqueStack<String> includeStack = new UniqueStack<String>();
            includeStack.push(parsedFileName);
            return new ParseState(output, new LineNumberReader(reader), errorHandler, resourceLoader, hdfParser, parsedFileName, ignoreAttributes, new HdfNameAttrs(), includeStack);
        }

        public static ParseState createParseStateForIncludedFile(ParseState originalState, String includeFileName, Reader includeFileReader) {
            return new ParseState(originalState.output, new LineNumberReader(includeFileReader), originalState.errorHandler, originalState.resourceLoader, originalState.hdfParser, originalState.parsedFileName, originalState.ignoreAttributes, new HdfNameAttrs(), originalState.includeStack);
        }
    }

    private static class HdfNameAttrs {
        String name;
        ArrayList<String> attrs = null;
        int endOfSequence;

        private HdfNameAttrs() {
        }

        void reset(String newname) {
            this.name = newname;
            if (this.attrs != null) {
                this.attrs.clear();
            }
            this.endOfSequence = 0;
        }

        void addAttribute(String key, String value) {
            if (this.attrs == null) {
                this.attrs = new ArrayList(10);
            }
            this.attrs.ensureCapacity(this.attrs.size() + 2);
            this.attrs.add(key);
            this.attrs.add(value);
        }

        Data toData(Data data) {
            Data child = data.createChild(this.name);
            if (this.attrs != null) {
                Iterator<String> it = this.attrs.iterator();
                while (it.hasNext()) {
                    String key = it.next();
                    String value = it.next();
                    child.setAttribute(key, value);
                }
            }
            return child;
        }
    }

    private static class OutOfCharsException
    extends Exception {
        private OutOfCharsException() {
        }
    }
}

