/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.data;

import com.google.clearsilver.jsilver.data.AbstractData;
import com.google.clearsilver.jsilver.data.ChainedData;
import com.google.clearsilver.jsilver.data.Data;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedMapData
extends AbstractData {
    private static final int CHILD_MAP_THRESHOLD = 4;
    private String name;
    private NestedMapData parent;
    private final NestedMapData root;
    private Map<String, NestedMapData> children = null;
    private int childCount = 0;
    private NestedMapData firstChild = null;
    private NestedMapData lastChild = null;
    private Iterable<NestedMapData> iterableChildren = null;
    private Map<String, String> attributeList = null;
    private String value = null;
    private NestedMapData symLink = this;
    private NestedMapData prevSibling = null;
    private NestedMapData nextSibling = null;

    public NestedMapData() {
        this.name = null;
        this.parent = null;
        this.root = this;
    }

    protected NestedMapData(String name, NestedMapData parent, NestedMapData root) {
        this.name = name;
        this.parent = parent;
        this.root = root;
    }

    protected NestedMapData createChildNode(String chunk) {
        NestedMapData sym = this.followSymLinkToTheBitterEnd();
        NestedMapData data = new NestedMapData(chunk, sym, sym.root);
        if (sym.children == null && sym.childCount >= 4) {
            sym.children = new HashMap<String, NestedMapData>();
            NestedMapData curr = sym.firstChild;
            while (curr != null) {
                sym.children.put(curr.getName(), curr);
                curr = curr.nextSibling;
            }
        }
        if (sym.children != null) {
            sym.children.put(chunk, data);
        }
        data.prevSibling = sym.lastChild;
        if (sym.lastChild != null) {
            sym.lastChild.nextSibling = data;
        } else {
            sym.firstChild = data;
        }
        sym.lastChild = data;
        ++sym.childCount;
        return data;
    }

    private void severNode() {
        if (this.parent == null) {
            return;
        }
        if (this.parent.children != null) {
            this.parent.children.remove(this.name);
        }
        if (this.prevSibling != null) {
            this.prevSibling.nextSibling = this.nextSibling;
        } else {
            this.parent.firstChild = this.nextSibling;
        }
        if (this.nextSibling != null) {
            this.nextSibling.prevSibling = this.prevSibling;
        } else {
            this.parent.lastChild = this.prevSibling;
        }
        --this.parent.childCount;
        this.parent = null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void getPathName(StringBuilder sb) {
        String name;
        if (this.parent != null && this.parent != this.root) {
            this.parent.getPathName(sb);
            sb.append(".");
        }
        if ((name = this.getName()) != null) {
            sb.append(name);
        }
    }

    @Override
    public String getFullPath() {
        StringBuilder sb = new StringBuilder();
        this.getPathName(sb);
        return sb.toString();
    }

    @Override
    public String getValue() {
        return this.followSymLinkToTheBitterEnd().value;
    }

    @Override
    public void setValue(String value) {
        this.symLink = this;
        this.value = value;
    }

    @Override
    public void setAttribute(String key, String value) {
        if (key == null) {
            throw new NullPointerException("Attribute name cannot be null.");
        }
        if (this.attributeList == null) {
            this.attributeList = new HashMap<String, String>();
        }
        if (value == null) {
            this.attributeList.remove(key);
        } else {
            this.attributeList.put(key, value);
        }
    }

    @Override
    public String getAttribute(String key) {
        return this.attributeList == null ? null : this.attributeList.get(key);
    }

    @Override
    public boolean hasAttribute(String key) {
        return this.attributeList != null && this.attributeList.containsKey(key);
    }

    @Override
    public int getAttributeCount() {
        return this.attributeList == null ? 0 : this.attributeList.size();
    }

    @Override
    public Iterable<Map.Entry<String, String>> getAttributes() {
        if (this.attributeList == null) {
            return Collections.emptySet();
        }
        return this.attributeList.entrySet();
    }

    @Override
    public Data getRoot() {
        return this.root;
    }

    @Override
    public Data getParent() {
        return this.parent;
    }

    @Override
    public boolean isFirstSibling() {
        return this.prevSibling == null;
    }

    @Override
    public boolean isLastSibling() {
        return this.nextSibling == null;
    }

    @Override
    public Data getNextSibling() {
        return this.nextSibling;
    }

    @Override
    public int getChildCount() {
        return this.followSymLinkToTheBitterEnd().childCount;
    }

    @Override
    public Iterable<? extends Data> getChildren() {
        if (this.iterableChildren == null) {
            this.iterableChildren = new IterableChildren();
        }
        return this.iterableChildren;
    }

    @Override
    public NestedMapData getChild(String path) {
        NestedMapData current = this;
        int lastDot = 0;
        int nextDot = 0;
        while (nextDot != -1 && current != null) {
            nextDot = path.indexOf(46, lastDot);
            String chunk = nextDot == -1 ? path.substring(lastDot) : path.substring(lastDot, nextDot);
            current = current.followSymLinkToTheBitterEnd().getChildNode(chunk);
            lastDot = nextDot + 1;
        }
        return current;
    }

    @Override
    public NestedMapData createChild(String path) {
        NestedMapData current = this;
        int lastDot = 0;
        int nextDot = 0;
        while (nextDot != -1) {
            nextDot = path.indexOf(46, lastDot);
            String chunk = nextDot == -1 ? path.substring(lastDot) : path.substring(lastDot, nextDot);
            NestedMapData currentSymLink = current.followSymLinkToTheBitterEnd();
            if ((current = currentSymLink.getChildNode(chunk)) == null) {
                current = currentSymLink.createChildNode(chunk);
            }
            lastDot = nextDot + 1;
        }
        return current;
    }

    private NestedMapData getChildNode(String name) {
        NestedMapData sym = this.followSymLinkToTheBitterEnd();
        if (sym.getChildCount() == 0) {
            return null;
        }
        if (sym.children != null) {
            return sym.children.get(name);
        }
        NestedMapData curr = sym.firstChild;
        while (curr != null) {
            if (curr.getName().equals(name)) {
                return curr;
            }
            curr = curr.nextSibling;
        }
        return null;
    }

    @Override
    public void removeTree(String path) {
        NestedMapData removed = this.getChild(path);
        if (removed != null) {
            removed.severNode();
        }
    }

    private NestedMapData followSymLinkToTheBitterEnd() {
        NestedMapData current = this;
        while (current.symLink != current) {
            current = current.symLink;
        }
        return current;
    }

    @Override
    public void setSymlink(String sourcePath, String destinationPath) {
        this.setSymlink(sourcePath, this.createChild(destinationPath));
    }

    @Override
    public void setSymlink(String sourcePath, Data destination) {
        this.createChild(sourcePath).setSymlink(destination);
    }

    @Override
    public void setSymlink(Data symLink) {
        if (!(symLink instanceof NestedMapData)) {
            String errorMessage = "Cannot set symlink of incompatible Data type: " + symLink.getClass().getName();
            if (symLink instanceof ChainedData) {
                errorMessage = errorMessage + "\nOther type is ChainedData indicating there are multiple valid Data nodes for the path: " + symLink.getFullPath();
            }
            throw new IllegalArgumentException(errorMessage);
        }
        this.symLink = (NestedMapData)symLink;
    }

    @Override
    public Data getSymlink() {
        return this.symLink;
    }

    @Override
    public void copy(String toPath, Data from) {
        if (toPath == null) {
            throw new NullPointerException("Invalid copy destination path");
        }
        if (from == null) {
            return;
        }
        NestedMapData to = this.createChild(toPath);
        to.copy(from);
    }

    @Override
    public void copy(Data from) {
        if (from == null) {
            return;
        }
        this.symLink = this;
        if (this.attributeList != null) {
            this.attributeList.clear();
        }
        for (Map.Entry<String, String> entry : from.getAttributes()) {
            this.setAttribute(entry.getKey(), entry.getValue());
        }
        if (from.getSymlink() != from) {
            this.setSymlink(from.getSymlink());
            return;
        }
        this.setValue(from.getValue());
        for (Data data : from.getChildren()) {
            NestedMapData toChild = this.createChild(data.getName());
            toChild.copy(data);
        }
    }

    @Override
    public void write(Appendable out, int indent) throws IOException {
        if (this.symLink != this) {
            this.indent(out, indent);
            this.writeNameAttrs(out);
            out.append(" : ").append(this.symLink.getFullPath()).append('\n');
            return;
        }
        if (this.getValue() != null) {
            this.indent(out, indent);
            this.writeNameAttrs(out);
            if (this.getValue().contains("\n")) {
                this.writeMultiline(out);
            } else {
                out.append(" = ").append(this.getValue()).append('\n');
            }
        }
        if (this.getChildCount() > 0) {
            int childIndent = indent;
            if (this != this.root) {
                this.indent(out, indent);
                this.writeNameAttrs(out);
                out.append(" {\n");
                ++childIndent;
            }
            for (Data data : this.getChildren()) {
                data.write(out, childIndent);
            }
            if (this != this.root) {
                this.indent(out, indent);
                out.append("}\n");
            }
        }
    }

    @Override
    public void optimize() {
        this.name = this.name == null ? null : this.name.intern();
        String string = this.value = this.value == null ? null : this.value.intern();
        if (this.attributeList != null) {
            HashMap<String, String> newList = new HashMap<String, String>(this.attributeList.size());
            for (Map.Entry<String, String> entry : this.attributeList.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                key = key == null ? null : key.intern();
                value = value == null ? null : value.intern();
                newList.put(key, value);
            }
            this.attributeList = newList;
        }
        NestedMapData child = this.firstChild;
        while (child != null) {
            child.optimize();
            child = child.nextSibling;
        }
    }

    private void writeMultiline(Appendable out) throws IOException {
        String marker = "EOM";
        while (this.getValue().contains(marker)) {
            marker = marker + System.nanoTime() % 10L;
        }
        out.append(" << ").append(marker).append('\n').append(this.getValue());
        if (!this.getValue().endsWith("\n")) {
            out.append('\n');
        }
        out.append(marker).append('\n');
    }

    private void indent(Appendable out, int indent) throws IOException {
        for (int i = 0; i < indent; ++i) {
            out.append("  ");
        }
    }

    private void writeNameAttrs(Appendable out) throws IOException {
        out.append(this.getName());
        if (this.attributeList != null && !this.attributeList.isEmpty()) {
            out.append(" [");
            boolean first = true;
            for (Map.Entry<String, String> attr : this.attributeList.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    out.append(", ");
                }
                out.append(attr.getKey());
                if (attr.getValue().equals("1")) continue;
                out.append(" = \"");
                NestedMapData.writeAttributeValue(out, attr.getValue());
                out.append('\"');
            }
            out.append(']');
        }
    }

    static void writeAttributeValue(Appendable out, String value) throws IOException {
        block7: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\"': {
                    out.append("\\\"");
                    continue block7;
                }
                case '\n': {
                    out.append("\\n");
                    continue block7;
                }
                case '\t': {
                    out.append("\\t");
                    continue block7;
                }
                case '\\': {
                    out.append("\\\\");
                    continue block7;
                }
                case '\r': {
                    out.append("\\r");
                    continue block7;
                }
                default: {
                    out.append(c);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ChildrenIterator
    implements Iterator<NestedMapData> {
        NestedMapData current;
        NestedMapData next;

        ChildrenIterator(NestedMapData first) {
            this.next = first;
            this.current = null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public NestedMapData next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.current = this.next;
            this.next = this.next.nextSibling;
            return this.current;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            this.current.severNode();
            this.current = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IterableChildren
    implements Iterable<NestedMapData> {
        private IterableChildren() {
        }

        @Override
        public Iterator<NestedMapData> iterator() {
            return new ChildrenIterator(NestedMapData.this.followSymLinkToTheBitterEnd().firstChild);
        }
    }
}

