/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.compiler;

import com.google.clearsilver.jsilver.autoescape.EscapeMode;
import com.google.clearsilver.jsilver.compiler.BaseCompiledTemplate;
import com.google.clearsilver.jsilver.compiler.EscapingEvaluator;
import com.google.clearsilver.jsilver.compiler.ExpressionTranslator;
import com.google.clearsilver.jsilver.compiler.JavaExpression;
import com.google.clearsilver.jsilver.compiler.JavaSourceWriter;
import com.google.clearsilver.jsilver.compiler.VariableTranslator;
import com.google.clearsilver.jsilver.data.Data;
import com.google.clearsilver.jsilver.data.DataContext;
import com.google.clearsilver.jsilver.functions.Function;
import com.google.clearsilver.jsilver.functions.FunctionExecutor;
import com.google.clearsilver.jsilver.syntax.analysis.DepthFirstAdapter;
import com.google.clearsilver.jsilver.syntax.node.AAltCommand;
import com.google.clearsilver.jsilver.syntax.node.AAutoescapeCommand;
import com.google.clearsilver.jsilver.syntax.node.ACallCommand;
import com.google.clearsilver.jsilver.syntax.node.ADataCommand;
import com.google.clearsilver.jsilver.syntax.node.ADefCommand;
import com.google.clearsilver.jsilver.syntax.node.AEachCommand;
import com.google.clearsilver.jsilver.syntax.node.AEscapeCommand;
import com.google.clearsilver.jsilver.syntax.node.AEvarCommand;
import com.google.clearsilver.jsilver.syntax.node.AHardIncludeCommand;
import com.google.clearsilver.jsilver.syntax.node.AHardLincludeCommand;
import com.google.clearsilver.jsilver.syntax.node.AIfCommand;
import com.google.clearsilver.jsilver.syntax.node.AIncludeCommand;
import com.google.clearsilver.jsilver.syntax.node.ALincludeCommand;
import com.google.clearsilver.jsilver.syntax.node.ALoopCommand;
import com.google.clearsilver.jsilver.syntax.node.ALoopIncCommand;
import com.google.clearsilver.jsilver.syntax.node.ALoopToCommand;
import com.google.clearsilver.jsilver.syntax.node.ALvarCommand;
import com.google.clearsilver.jsilver.syntax.node.ANameCommand;
import com.google.clearsilver.jsilver.syntax.node.ANoopCommand;
import com.google.clearsilver.jsilver.syntax.node.ASetCommand;
import com.google.clearsilver.jsilver.syntax.node.AUvarCommand;
import com.google.clearsilver.jsilver.syntax.node.AVarCommand;
import com.google.clearsilver.jsilver.syntax.node.AWithCommand;
import com.google.clearsilver.jsilver.syntax.node.PCommand;
import com.google.clearsilver.jsilver.syntax.node.PExpression;
import com.google.clearsilver.jsilver.syntax.node.PPosition;
import com.google.clearsilver.jsilver.syntax.node.PVariable;
import com.google.clearsilver.jsilver.syntax.node.Start;
import com.google.clearsilver.jsilver.syntax.node.TCsOpen;
import com.google.clearsilver.jsilver.syntax.node.TWord;
import com.google.clearsilver.jsilver.template.Macro;
import com.google.clearsilver.jsilver.template.RenderingContext;
import com.google.clearsilver.jsilver.template.Template;
import com.google.clearsilver.jsilver.values.Value;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateTranslator
extends DepthFirstAdapter {
    public static final JavaExpression DATA = JavaExpression.symbol(JavaExpression.Type.DATA, "data");
    public static final JavaExpression CONTEXT = JavaExpression.symbol("context");
    public static final JavaExpression DATA_CONTEXT = JavaExpression.symbol(JavaExpression.Type.DATA_CONTEXT, "dataContext");
    public static final JavaExpression NULL = JavaExpression.symbol("null");
    public static final JavaExpression RESOURCE_LOADER = JavaExpression.callOn(CONTEXT, "getResourceLoader", new JavaExpression[0]);
    public static final JavaExpression TEMPLATE_LOADER = JavaExpression.symbol("getTemplateLoader()");
    public static final JavaExpression THIS_TEMPLATE = JavaExpression.symbol("this");
    private final JavaSourceWriter java;
    private final String packageName;
    private final String className;
    private final ExpressionTranslator expressionTranslator = new ExpressionTranslator();
    private final VariableTranslator variableTranslator = new VariableTranslator(this.expressionTranslator);
    private final EscapingEvaluator escapingEvaluator = new EscapingEvaluator(this.variableTranslator);
    private static final Method RENDER_METHOD;
    private int tempVariable = 0;
    private boolean propagateEscapeStatus;
    private final Map<String, MacroInfo> macroMap = new HashMap<String, MacroInfo>();
    private final Queue<MacroInfo> macroQueue = new LinkedList<MacroInfo>();

    private void addMacro(String name, JavaExpression symbol, ADefCommand defNode) {
        if (this.macroMap.get(name) != null) {
            // empty if block
        }
        MacroInfo info = new MacroInfo();
        info.symbol = symbol;
        info.defNode = defNode;
        this.macroMap.put(name, info);
        this.macroQueue.add(info);
        this.java.writeStatement(JavaExpression.callOn(CONTEXT, "registerMacro", JavaExpression.string(name), symbol));
    }

    public TemplateTranslator(String packageName, String className, Writer output, boolean propagateEscapeStatus) {
        this.packageName = packageName;
        this.className = className;
        this.java = new JavaSourceWriter(output);
        this.propagateEscapeStatus = propagateEscapeStatus;
    }

    @Override
    public void caseStart(Start node) {
        this.java.writeComment("This class is autogenerated by JSilver. Do not edit.");
        this.java.writePackage(this.packageName);
        this.java.writeImports(BaseCompiledTemplate.class, Template.class, Macro.class, RenderingContext.class, Data.class, DataContext.class, Function.class, FunctionExecutor.class, Value.class, EscapeMode.class, IOException.class);
        this.java.startClass(this.className, BaseCompiledTemplate.class.getSimpleName(), new String[0]);
        this.java.startMethod(RENDER_METHOD, "context");
        this.java.writeStatement(JavaExpression.declare(JavaExpression.Type.DATA_CONTEXT, "dataContext", JavaExpression.callOn(CONTEXT, "getDataContext", new JavaExpression[0])));
        this.java.writeStatement(JavaExpression.callOn(CONTEXT, "pushExecutionContext", THIS_TEMPLATE));
        super.caseStart(node);
        this.java.writeStatement(JavaExpression.callOn(CONTEXT, "popExecutionContext", new JavaExpression[0]));
        this.java.endMethod();
        MacroTransformer macroTransformer = new MacroTransformer();
        while (!this.macroQueue.isEmpty()) {
            MacroInfo curr = this.macroQueue.remove();
            macroTransformer.parseDefNode(curr.symbol, curr.defNode);
        }
        this.java.endClass();
    }

    @Override
    public void caseADataCommand(ADataCommand node) {
        String content = node.getData().getText();
        this.java.writeStatement(JavaExpression.callOn(CONTEXT, "writeUnescaped", JavaExpression.string(content)));
    }

    @Override
    public void caseAVarCommand(AVarCommand node) {
        this.capturePosition(node.getPosition());
        String tempVariableName = this.generateTempVariable("result");
        JavaExpression result = JavaExpression.symbol(JavaExpression.Type.STRING, tempVariableName);
        this.java.writeStatement(JavaExpression.declare(JavaExpression.Type.STRING, tempVariableName, this.expressionTranslator.translateToString(node.getExpression())));
        JavaExpression escaping = this.escapingEvaluator.computeIfExemptFromEscaping(node.getExpression(), this.propagateEscapeStatus);
        this.writeVariable(result, escaping);
    }

    @Override
    public void caseAUvarCommand(AUvarCommand node) {
        this.capturePosition(node.getPosition());
        this.java.writeStatement(JavaExpression.callOn(CONTEXT, "writeUnescaped", this.expressionTranslator.translateToString(node.getExpression())));
    }

    @Override
    public void caseASetCommand(ASetCommand node) {
        this.capturePosition(node.getPosition());
        String tempVariableName = this.generateTempVariable("setNode");
        JavaExpression setNode = JavaExpression.symbol(JavaExpression.Type.DATA, tempVariableName);
        this.java.writeStatement(JavaExpression.declare(JavaExpression.Type.DATA, tempVariableName, JavaExpression.callFindVariable(this.variableTranslator.translate(node.getVariable()), true)));
        this.java.writeStatement(JavaExpression.callOn(setNode, "setValue", this.expressionTranslator.translateToString(node.getExpression())));
        if (this.propagateEscapeStatus) {
            this.java.writeStatement(JavaExpression.callOn(setNode, "setEscapeMode", this.escapingEvaluator.computeEscaping(node.getExpression(), this.propagateEscapeStatus)));
        }
    }

    @Override
    public void caseANameCommand(ANameCommand node) {
        this.capturePosition(node.getPosition());
        JavaExpression readNode = JavaExpression.callFindVariable(this.variableTranslator.translate(node.getVariable()), false);
        this.java.writeStatement(JavaExpression.callOn(CONTEXT, "writeEscaped", JavaExpression.call("getNodeName", readNode)));
    }

    @Override
    public void caseAIfCommand(AIfCommand node) {
        this.capturePosition(node.getPosition());
        this.java.startIfBlock(this.expressionTranslator.translateToBoolean(node.getExpression()));
        node.getBlock().apply(this);
        if (!(node.getOtherwise() instanceof ANoopCommand)) {
            this.java.endIfStartElseBlock();
            node.getOtherwise().apply(this);
        }
        this.java.endIfBlock();
    }

    @Override
    public void caseAEachCommand(AEachCommand node) {
        this.capturePosition(node.getPosition());
        JavaExpression parent = this.expressionTranslator.translateToData(node.getExpression());
        this.writeEach(node.getVariable(), parent, node.getCommand());
    }

    @Override
    public void caseAWithCommand(AWithCommand node) {
        this.capturePosition(node.getPosition());
        this.java.startScopedBlock();
        this.java.writeComment("with:");
        JavaExpression value = this.expressionTranslator.translateUntyped(node.getExpression());
        String methodName = null;
        if (value.getType() == JavaExpression.Type.VAR_NAME) {
            String withValueName = this.generateTempVariable("withValue");
            this.java.writeStatement(JavaExpression.declare(JavaExpression.Type.STRING, withValueName, value));
            value = JavaExpression.symbol(JavaExpression.Type.VAR_NAME, withValueName);
            methodName = "createLocalVariableByPath";
            this.java.startIfBlock(JavaExpression.infix(JavaExpression.Type.BOOLEAN, "!=", value.cast(JavaExpression.Type.DATA), JavaExpression.literal(JavaExpression.Type.DATA, "null")));
        } else {
            value = value.cast(JavaExpression.Type.STRING);
            methodName = "createLocalVariableByValue";
        }
        JavaExpression itemKey = this.variableTranslator.translate(node.getVariable());
        this.java.writeStatement(JavaExpression.callOn(DATA_CONTEXT, "pushVariableScope", new JavaExpression[0]));
        this.java.writeStatement(JavaExpression.callOn(DATA_CONTEXT, methodName, itemKey, value));
        node.getCommand().apply(this);
        this.java.writeStatement(JavaExpression.callOn(DATA_CONTEXT, "popVariableScope", new JavaExpression[0]));
        if (value.getType() == JavaExpression.Type.VAR_NAME) {
            this.java.endIfBlock();
        }
        this.java.endScopedBlock();
    }

    @Override
    public void caseALoopToCommand(ALoopToCommand node) {
        this.capturePosition(node.getPosition());
        JavaExpression start = JavaExpression.integer(0);
        JavaExpression end = this.expressionTranslator.translateToNumber(node.getExpression());
        JavaExpression incr = JavaExpression.integer(1);
        this.writeLoop(node.getVariable(), start, end, incr, node.getCommand());
    }

    @Override
    public void caseALoopCommand(ALoopCommand node) {
        this.capturePosition(node.getPosition());
        JavaExpression start = this.expressionTranslator.translateToNumber(node.getStart());
        JavaExpression end = this.expressionTranslator.translateToNumber(node.getEnd());
        JavaExpression incr = JavaExpression.integer(1);
        this.writeLoop(node.getVariable(), start, end, incr, node.getCommand());
    }

    @Override
    public void caseALoopIncCommand(ALoopIncCommand node) {
        this.capturePosition(node.getPosition());
        JavaExpression start = this.expressionTranslator.translateToNumber(node.getStart());
        JavaExpression end = this.expressionTranslator.translateToNumber(node.getEnd());
        JavaExpression incr = this.expressionTranslator.translateToNumber(node.getIncrement());
        this.writeLoop(node.getVariable(), start, end, incr, node.getCommand());
    }

    private void writeLoop(PVariable itemVariable, JavaExpression start, JavaExpression end, JavaExpression incr, PCommand command) {
        this.java.startScopedBlock();
        String startVarName = this.generateTempVariable("start");
        this.java.writeStatement(JavaExpression.declare(JavaExpression.Type.INT, startVarName, start));
        JavaExpression startVar = JavaExpression.symbol(JavaExpression.Type.INT, startVarName);
        String endVarName = this.generateTempVariable("end");
        this.java.writeStatement(JavaExpression.declare(JavaExpression.Type.INT, endVarName, end));
        JavaExpression endVar = JavaExpression.symbol(JavaExpression.Type.INT, endVarName);
        String incrVarName = this.generateTempVariable("incr");
        this.java.writeStatement(JavaExpression.declare(JavaExpression.Type.INT, incrVarName, incr));
        JavaExpression incrVar = JavaExpression.symbol(JavaExpression.Type.INT, incrVarName);
        this.java.startIfBlock(JavaExpression.call(JavaExpression.Type.BOOLEAN, "validateLoopArgs", startVar, endVar, incrVar));
        JavaExpression itemKey = this.variableTranslator.translate(itemVariable);
        this.java.writeStatement(JavaExpression.callOn(DATA_CONTEXT, "pushVariableScope", new JavaExpression[0]));
        String loopVariable = this.generateTempVariable("loop");
        JavaExpression loopVar = JavaExpression.symbol(JavaExpression.Type.INT, loopVariable);
        JavaExpression ifStart = JavaExpression.declare(JavaExpression.Type.INT, loopVariable, startVar);
        JavaExpression ifEnd = JavaExpression.inlineIf(JavaExpression.Type.BOOLEAN, JavaExpression.infix(JavaExpression.Type.BOOLEAN, ">=", incrVar, JavaExpression.integer(0)), JavaExpression.infix(JavaExpression.Type.BOOLEAN, "<=", loopVar, endVar), JavaExpression.infix(JavaExpression.Type.BOOLEAN, ">=", loopVar, endVar));
        this.java.startForLoop(ifStart, ifEnd, JavaExpression.increment(JavaExpression.Type.INT, loopVar, incrVar));
        this.java.writeStatement(JavaExpression.callOn(DATA_CONTEXT, "createLocalVariableByValue", itemKey, JavaExpression.symbol(loopVariable).cast(JavaExpression.Type.STRING), JavaExpression.infix(JavaExpression.Type.BOOLEAN, "==", JavaExpression.symbol(loopVariable), startVar), JavaExpression.infix(JavaExpression.Type.BOOLEAN, "==", JavaExpression.symbol(loopVariable), endVar)));
        command.apply(this);
        this.java.endLoop();
        this.java.writeStatement(JavaExpression.callOn(DATA_CONTEXT, "popVariableScope", new JavaExpression[0]));
        this.java.endIfBlock();
        this.java.endScopedBlock();
    }

    private void writeEach(PVariable itemVariable, JavaExpression parentData, PCommand command) {
        JavaExpression itemKey = this.variableTranslator.translate(itemVariable);
        this.java.writeStatement(JavaExpression.callOn(DATA_CONTEXT, "pushVariableScope", new JavaExpression[0]));
        String childDataVariable = this.generateTempVariable("child");
        this.java.startIterableForLoop("Data", childDataVariable, JavaExpression.call("getChildren", parentData));
        this.java.writeStatement(JavaExpression.callOn(DATA_CONTEXT, "createLocalVariableByPath", itemKey, JavaExpression.callOn(JavaExpression.Type.STRING, JavaExpression.symbol(childDataVariable), "getFullPath", new JavaExpression[0])));
        command.apply(this);
        this.java.endLoop();
        this.java.writeStatement(JavaExpression.callOn(DATA_CONTEXT, "popVariableScope", new JavaExpression[0]));
    }

    @Override
    public void caseAAltCommand(AAltCommand node) {
        this.capturePosition(node.getPosition());
        String tempVariableName = this.generateTempVariable("altVar");
        JavaExpression declaration = this.expressionTranslator.declareAsVariable(tempVariableName, node.getExpression());
        JavaExpression reference = JavaExpression.symbol(declaration.getType(), tempVariableName);
        this.java.writeStatement(declaration);
        this.java.startIfBlock(reference.cast(JavaExpression.Type.BOOLEAN));
        JavaExpression escaping = this.escapingEvaluator.computeIfExemptFromEscaping(node.getExpression(), this.propagateEscapeStatus);
        this.writeVariable(reference, escaping);
        this.java.endIfStartElseBlock();
        node.getCommand().apply(this);
        this.java.endIfBlock();
    }

    private void writeVariable(JavaExpression result, JavaExpression escapingExpression) {
        if (escapingExpression instanceof JavaExpression.BooleanLiteralExpression) {
            JavaExpression.BooleanLiteralExpression expr = (JavaExpression.BooleanLiteralExpression)escapingExpression;
            if (expr.getValue()) {
                this.java.writeStatement(JavaExpression.callOn(CONTEXT, "writeUnescaped", result.cast(JavaExpression.Type.STRING)));
            } else {
                this.java.writeStatement(JavaExpression.callOn(CONTEXT, "writeEscaped", result.cast(JavaExpression.Type.STRING)));
            }
        } else {
            this.java.startIfBlock(escapingExpression);
            this.java.writeStatement(JavaExpression.callOn(CONTEXT, "writeUnescaped", result.cast(JavaExpression.Type.STRING)));
            this.java.endIfStartElseBlock();
            this.java.writeStatement(JavaExpression.callOn(CONTEXT, "writeEscaped", result.cast(JavaExpression.Type.STRING)));
            this.java.endIfBlock();
        }
    }

    @Override
    public void caseAEscapeCommand(AEscapeCommand node) {
        this.capturePosition(node.getPosition());
        this.java.writeStatement(JavaExpression.callOn(CONTEXT, "pushEscapingFunction", this.expressionTranslator.translateToString(node.getExpression())));
        node.getCommand().apply(this);
        this.java.writeStatement(JavaExpression.callOn(CONTEXT, "popEscapingFunction", new JavaExpression[0]));
    }

    @Override
    public void caseAAutoescapeCommand(AAutoescapeCommand node) {
        this.capturePosition(node.getPosition());
        this.java.writeStatement(JavaExpression.callOn(CONTEXT, "pushAutoEscapeMode", JavaExpression.callOn(JavaExpression.symbol("EscapeMode"), "computeEscapeMode", this.expressionTranslator.translateToString(node.getExpression()))));
        node.getCommand().apply(this);
        this.java.writeStatement(JavaExpression.callOn(CONTEXT, "popAutoEscapeMode", new JavaExpression[0]));
    }

    @Override
    public void caseAHardLincludeCommand(AHardLincludeCommand node) {
        this.capturePosition(node.getPosition());
        this.java.writeStatement(JavaExpression.call("include", this.expressionTranslator.translateToString(node.getExpression()), JavaExpression.bool(false), CONTEXT));
    }

    @Override
    public void caseALincludeCommand(ALincludeCommand node) {
        this.capturePosition(node.getPosition());
        this.java.writeStatement(JavaExpression.call("include", this.expressionTranslator.translateToString(node.getExpression()), JavaExpression.bool(true), CONTEXT));
    }

    @Override
    public void caseAHardIncludeCommand(AHardIncludeCommand node) {
        this.capturePosition(node.getPosition());
        this.java.writeStatement(JavaExpression.call("include", this.expressionTranslator.translateToString(node.getExpression()), JavaExpression.bool(false), CONTEXT));
    }

    @Override
    public void caseAIncludeCommand(AIncludeCommand node) {
        this.capturePosition(node.getPosition());
        this.java.writeStatement(JavaExpression.call("include", this.expressionTranslator.translateToString(node.getExpression()), JavaExpression.bool(true), CONTEXT));
    }

    @Override
    public void caseALvarCommand(ALvarCommand node) {
        this.capturePosition(node.getPosition());
        this.evaluateVariable(node.getExpression(), "[lvar expression]");
    }

    @Override
    public void caseAEvarCommand(AEvarCommand node) {
        this.capturePosition(node.getPosition());
        this.evaluateVariable(node.getExpression(), "[evar expression]");
    }

    private void evaluateVariable(PExpression expression, String stackTraceDescription) {
        this.java.writeStatement(JavaExpression.callOn(JavaExpression.callOn(TEMPLATE_LOADER, "createTemp", JavaExpression.string(stackTraceDescription), this.expressionTranslator.translateToString(expression), JavaExpression.callOn(CONTEXT, "getAutoEscapeMode", new JavaExpression[0])), "render", CONTEXT));
    }

    @Override
    public void caseADefCommand(ADefCommand node) {
        this.capturePosition(node.getPosition());
        String name = this.makeWord(node.getMacro());
        if (this.macroMap.containsKey(name)) {
            // empty if block
        }
        this.addMacro(name, JavaExpression.macro("macro" + this.macroMap.size()), node);
    }

    private String makeWord(LinkedList<TWord> words) {
        if (words.size() == 1) {
            return words.getFirst().getText();
        }
        StringBuilder result = new StringBuilder();
        for (TWord word : words) {
            if (result.length() > 0) {
                result.append('.');
            }
            result.append(word.getText());
        }
        return result.toString();
    }

    @Override
    public void caseACallCommand(ACallCommand node) {
        JavaExpression macroCalled;
        this.capturePosition(node.getPosition());
        String name = this.makeWord(node.getMacro());
        this.java.startScopedBlock();
        this.java.writeComment("call:" + name);
        MacroInfo macroInfo = this.macroMap.get(name);
        if (macroInfo == null) {
            String macroCall = this.generateTempVariable("macroCall");
            this.java.writeStatement(JavaExpression.declare(JavaExpression.Type.MACRO, macroCall, JavaExpression.callOn(CONTEXT, "findMacro", JavaExpression.string(name))));
            macroCalled = JavaExpression.macro(macroCall);
        } else {
            macroCalled = macroInfo.symbol;
        }
        int numArgs = node.getArguments().size();
        if (numArgs > 0) {
            JavaExpression[] argValues = new JavaExpression[numArgs];
            JavaExpression[] argStatus = new JavaExpression[numArgs];
            int i = 0;
            for (PExpression argNode : node.getArguments()) {
                JavaExpression value = this.expressionTranslator.translateUntyped(argNode);
                if (value.getType() != JavaExpression.Type.VAR_NAME) {
                    value = value.cast(JavaExpression.Type.STRING);
                }
                String valueName = this.generateTempVariable("argValue");
                this.java.writeStatement(JavaExpression.declare(JavaExpression.Type.STRING, valueName, value));
                argValues[i] = JavaExpression.symbol(value.getType(), valueName);
                argStatus[i] = this.propagateEscapeStatus ? this.escapingEvaluator.computeEscaping(argNode, this.propagateEscapeStatus) : JavaExpression.symbol("EscapeMode.ESCAPE_NONE");
                ++i;
            }
            this.java.writeStatement(JavaExpression.callOn(DATA_CONTEXT, "pushVariableScope", new JavaExpression[0]));
            for (i = 0; i < argValues.length; ++i) {
                String methodName;
                JavaExpression value = argValues[i];
                JavaExpression tempVar = JavaExpression.callOn(macroCalled, "getArgumentName", JavaExpression.integer(i));
                if (value.getType() == JavaExpression.Type.VAR_NAME) {
                    methodName = "createLocalVariableByPath";
                    this.java.writeStatement(JavaExpression.callOn(DATA_CONTEXT, methodName, tempVar, value));
                    continue;
                }
                methodName = "createLocalVariableByValue";
                this.java.writeStatement(JavaExpression.callOn(DATA_CONTEXT, methodName, tempVar, value, argStatus[i]));
            }
        }
        this.java.writeStatement(JavaExpression.callOn(macroCalled, "render", CONTEXT));
        if (numArgs > 0) {
            this.java.writeStatement(JavaExpression.callOn(DATA_CONTEXT, "popVariableScope", new JavaExpression[0]));
        }
        this.java.endScopedBlock();
    }

    private void capturePosition(PPosition position) {
        position.apply(this);
    }

    @Override
    public void caseTCsOpen(TCsOpen node) {
        int line = node.getLine();
        int column = node.getPos();
        this.java.writeStatement(JavaExpression.callOn(CONTEXT, "setCurrentPosition", JavaExpression.integer(line), JavaExpression.integer(column)));
    }

    private String generateTempVariable(String prefix) {
        return prefix + this.tempVariable++;
    }

    static {
        try {
            RENDER_METHOD = Template.class.getMethod("render", RenderingContext.class);
        }
        catch (NoSuchMethodException e) {
            throw new Error("Cannot find CompiledTemplate.render() method! Has signature changed?", e);
        }
    }

    private class MacroTransformer {
        private MacroTransformer() {
        }

        public void parseDefNode(JavaExpression macroName, ADefCommand node) {
            TemplateTranslator.this.java.startField("Macro", macroName);
            int i = 0;
            JavaExpression[] args = new JavaExpression[1 + node.getArguments().size()];
            args[i++] = JavaExpression.string(TemplateTranslator.this.makeWord(node.getMacro()));
            for (PVariable argName : node.getArguments()) {
                args[i++] = TemplateTranslator.this.variableTranslator.translate(argName);
            }
            TemplateTranslator.this.java.startAnonymousClass("CompiledMacro", args);
            TemplateTranslator.this.java.startMethod(RENDER_METHOD, "context");
            TemplateTranslator.this.java.writeStatement(JavaExpression.declare(JavaExpression.Type.DATA_CONTEXT, "dataContext", JavaExpression.callOn(CONTEXT, "getDataContext", new JavaExpression[0])));
            TemplateTranslator.this.java.writeStatement(JavaExpression.callOn(CONTEXT, "pushExecutionContext", THIS_TEMPLATE));
            String tempVariableName = TemplateTranslator.this.generateTempVariable("doRuntimeAutoEscaping");
            JavaExpression value = JavaExpression.prefix(JavaExpression.Type.BOOLEAN, "!", JavaExpression.callOn(CONTEXT, "isRuntimeAutoEscaping", new JavaExpression[0]));
            JavaExpression stmt = JavaExpression.declare(JavaExpression.Type.BOOLEAN, tempVariableName, value);
            TemplateTranslator.this.java.writeStatement(stmt);
            JavaExpression doRuntimeAutoEscaping = JavaExpression.symbol(JavaExpression.Type.BOOLEAN, tempVariableName);
            TemplateTranslator.this.java.startIfBlock(doRuntimeAutoEscaping.cast(JavaExpression.Type.BOOLEAN));
            TemplateTranslator.this.java.writeStatement(JavaExpression.callOn(CONTEXT, "startRuntimeAutoEscaping", new JavaExpression[0]));
            TemplateTranslator.this.java.endIfBlock();
            node.getCommand().apply(TemplateTranslator.this);
            TemplateTranslator.this.java.startIfBlock(doRuntimeAutoEscaping.cast(JavaExpression.Type.BOOLEAN));
            TemplateTranslator.this.java.writeStatement(JavaExpression.callOn(CONTEXT, "stopRuntimeAutoEscaping", new JavaExpression[0]));
            TemplateTranslator.this.java.endIfBlock();
            TemplateTranslator.this.java.writeStatement(JavaExpression.callOn(CONTEXT, "popExecutionContext", new JavaExpression[0]));
            TemplateTranslator.this.java.endMethod();
            TemplateTranslator.this.java.endAnonymousClass();
            TemplateTranslator.this.java.endField();
        }
    }

    private static class MacroInfo {
        JavaExpression symbol;
        ADefCommand defNode;

        private MacroInfo() {
        }
    }
}

